/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.softenvironment.util.StringUtils;
import ch.softenvironment.view.BasePanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class TriStatePanel
extends BasePanel {
    private static String ACTION_ALL = "ALL";
    private static String ACTION_YES = "YES";
    private static String ACTION_NO = "NO";
    private boolean changing = false;
    private ButtonGroup group = new ButtonGroup();
    private JRadioButton ivjRbtFalse = null;
    private JRadioButton ivjRbtTrue = null;
    private JRadioButton ivjRbtAll = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private Boolean fieldValue;

    public TriStatePanel() {
        this.initialize();
    }

    public TriStatePanel(LayoutManager layout) {
        super(layout);
    }

    public TriStatePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public TriStatePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    private void changed(ItemEvent itemEvent) {
        if (!this.changing) {
            if (this.group.getSelection().getActionCommand().equals(ACTION_NO)) {
                this.setValue(Boolean.FALSE);
            } else if (this.group.getSelection().getActionCommand().equals(ACTION_YES)) {
                this.setValue(Boolean.TRUE);
            } else {
                this.setValue(null);
            }
        }
    }

    private void connEtoC1(ItemEvent arg1) {
        try {
            this.changed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.changed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ItemEvent arg1) {
        try {
            this.changed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public Boolean getNotValue() {
        if (this.fieldValue != null) {
            return this.fieldValue == false;
        }
        return null;
    }

    private JRadioButton getRbtAll() {
        if (this.ivjRbtAll == null) {
            try {
                this.ivjRbtAll = new JRadioButton();
                this.ivjRbtAll.setName("RbtAll");
                this.ivjRbtAll.setText("Alle");
                this.ivjRbtAll.setBounds(0, 0, 93, 22);
                this.ivjRbtAll.setActionCommand(ACTION_ALL);
                this.ivjRbtAll.setText(this.getResourceString("CI_All_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtAll;
    }

    private JRadioButton getRbtFalse() {
        if (this.ivjRbtFalse == null) {
            try {
                this.ivjRbtFalse = new JRadioButton();
                this.ivjRbtFalse.setName("RbtFalse");
                this.ivjRbtFalse.setText("Nein");
                this.ivjRbtFalse.setBounds(200, 0, 93, 22);
                this.ivjRbtFalse.setActionCommand(ACTION_NO);
                this.ivjRbtFalse.setText(TriStatePanel.getResourceString(StringUtils.class, "CI_No_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtFalse;
    }

    private JRadioButton getRbtTrue() {
        if (this.ivjRbtTrue == null) {
            try {
                this.ivjRbtTrue = new JRadioButton();
                this.ivjRbtTrue.setName("RbtTrue");
                this.ivjRbtTrue.setText("Ja");
                this.ivjRbtTrue.setBounds(100, 0, 93, 21);
                this.ivjRbtTrue.setActionCommand(ACTION_YES);
                this.ivjRbtTrue.setText(TriStatePanel.getResourceString(StringUtils.class, "CI_Yes_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtTrue;
    }

    public Boolean getValue() {
        return this.fieldValue;
    }

    public String getValueString() {
        if (this.getRbtTrue().isSelected()) {
            return this.getRbtTrue().getText();
        }
        if (this.getRbtFalse().isSelected()) {
            return this.getRbtFalse().getText();
        }
        return this.getRbtAll().getText();
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getRbtAll().addItemListener(this.ivjEventHandler);
        this.getRbtTrue().addItemListener(this.ivjEventHandler);
        this.getRbtFalse().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("TriStatePanel");
            this.setLayout(null);
            this.setSize(300, 22);
            this.add((Component)this.getRbtAll(), this.getRbtAll().getName());
            this.add((Component)this.getRbtTrue(), this.getRbtTrue().getName());
            this.add((Component)this.getRbtFalse(), this.getRbtFalse().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.group.add(this.getRbtAll());
        this.group.add(this.getRbtTrue());
        this.group.add(this.getRbtFalse());
        this.setValue(null);
        this.getRbtAll().setSelected(true);
    }

    public void setValue(Boolean value) {
        if (value == null && this.fieldValue != null) {
            this.changing = true;
            Boolean oldValue = this.fieldValue;
            this.fieldValue = value;
            this.firePropertyChange("value", oldValue, value);
            this.getRbtAll().setSelected(true);
            this.changing = false;
            return;
        }
        if (value != null && !value.equals(this.fieldValue)) {
            this.changing = true;
            Boolean oldValue = this.fieldValue;
            this.fieldValue = value;
            this.firePropertyChange("value", oldValue, value);
            if (value.booleanValue()) {
                this.getRbtTrue().setSelected(true);
            } else {
                this.getRbtFalse().setSelected(true);
            }
            this.changing = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getRbtAll().setEnabled(enabled);
        this.getRbtTrue().setEnabled(enabled);
        this.getRbtFalse().setEnabled(enabled);
    }

    public void showTriState(boolean triState) {
        this.getRbtAll().setVisible(triState);
    }

    class IvjEventHandler
    implements ItemListener {
        IvjEventHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == TriStatePanel.this.getRbtAll()) {
                TriStatePanel.this.connEtoC1(e);
            }
            if (e.getSource() == TriStatePanel.this.getRbtTrue()) {
                TriStatePanel.this.connEtoC2(e);
            }
            if (e.getSource() == TriStatePanel.this.getRbtFalse()) {
                TriStatePanel.this.connEtoC3(e);
            }
        }
    }
}

