/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import org.freehep.swing.layout.ToolBarLayout;
import org.freehep.swing.popup.HasPopupItems;

public class ToolBarHolder
extends JPanel
implements HasPopupItems {
    private static final String nameKey = "nameKey";
    private static final String modeKey = "modekey";
    private HashMap toolbars = new HashMap();
    private HashMap autos = new HashMap();

    protected ToolBarHolder() {
        super(new ToolBarLayout(0, 5, 5));
    }

    void add(JToolBar bar, String name, int mode) {
        if (!this.toolbars.containsKey(name)) {
            if (mode == 0) {
                mode = 3;
            }
            if (mode == 3) {
                this.addAuto(bar);
            } else {
                bar.setVisible(mode == 2);
            }
            bar.putClientProperty(modeKey, new Integer(mode));
            bar.putClientProperty(nameKey, name);
            this.toolbars.put(name, bar);
            this.add(bar);
        }
    }

    void save(Properties props) {
        Iterator i = this.toolbars.values().iterator();
        while (i.hasNext()) {
            JToolBar bar = (JToolBar)i.next();
            props.setProperty("ToolBar." + bar.getClientProperty(nameKey).toString(), bar.getClientProperty(modeKey).toString());
        }
    }

    void remove(JToolBar bar) {
        this.toolbars.remove(bar);
        this.removeAuto(bar);
        this.remove(bar);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu popup, Component src, Point p) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            final JToolBar bar = (JToolBar)this.getComponent(i);
            String name = (String)bar.getClientProperty(nameKey);
            int mode = (Integer)bar.getClientProperty(modeKey);
            if (mode == 4) continue;
            JMenu menu = new JMenu(name);
            final JRadioButtonMenuItem show = new JRadioButtonMenuItem("Show");
            final JRadioButtonMenuItem hide = new JRadioButtonMenuItem("Hide");
            final JRadioButtonMenuItem auto = new JRadioButtonMenuItem("Auto");
            show.setSelected(mode == 2);
            hide.setSelected(mode == 1);
            auto.setSelected(mode == 3);
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source == hide) {
                        bar.putClientProperty(ToolBarHolder.modeKey, new Integer(1));
                        bar.setVisible(false);
                        ToolBarHolder.this.removeAuto(bar);
                    } else if (source == show) {
                        bar.putClientProperty(ToolBarHolder.modeKey, new Integer(2));
                        bar.setVisible(true);
                        ToolBarHolder.this.removeAuto(bar);
                    } else if (source == auto) {
                        bar.putClientProperty(ToolBarHolder.modeKey, new Integer(3));
                        ToolBarHolder.this.addAuto(bar);
                    }
                }
            };
            show.addActionListener(al);
            hide.addActionListener(al);
            auto.addActionListener(al);
            menu.add(show);
            menu.add(hide);
            menu.add(auto);
            popup.add(menu);
        }
        return popup;
    }

    private void addAuto(JToolBar bar) {
        this.autos.put(bar, new AutoToolbarListener(bar));
    }

    private void removeAuto(JToolBar bar) {
        AutoToolbarListener l = (AutoToolbarListener)this.autos.remove(bar);
        if (l != null) {
            l.dispose();
        }
    }

    private class AutoToolbarListener
    implements PropertyChangeListener {
        private JToolBar bar;
        int count = 0;

        AutoToolbarListener(JToolBar bar) {
            this.bar = bar;
            int n = bar.getComponentCount();
            boolean visible = false;
            for (int i = 0; i < n; ++i) {
                Component c = bar.getComponent(i);
                if (c.isEnabled()) {
                    ++this.count;
                }
                c.addPropertyChangeListener("enabled", this);
            }
            bar.setVisible(this.count > 0);
        }

        void dispose() {
            int n = this.bar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.bar.getComponent(i);
                c.removePropertyChangeListener("enabled", this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component source = (Component)evt.getSource();
            this.count = source.isEnabled() ? ++this.count : --this.count;
            this.bar.setVisible(this.count > 0);
        }
    }
}

