/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;

public abstract class LineType
extends Type {
    protected PrecisionDecimal maxOverlap = null;
    protected LineForm[] lineForms = new LineForm[0];
    protected Domain controlPointDomain = null;

    @Override
    public boolean isAbstract() {
        if (this.lineForms.length == 0 || this.controlPointDomain == null) {
            return true;
        }
        return this.controlPointDomain.isAbstract();
    }

    public PrecisionDecimal getMaxOverlap() {
        return this.maxOverlap;
    }

    public void setMaxOverlap(PrecisionDecimal maxOverlap) throws PropertyVetoException {
        PrecisionDecimal oldValue = this.maxOverlap;
        PrecisionDecimal newValue = maxOverlap;
        if (oldValue == newValue) {
            return;
        }
        if (this.extending != null && newValue != null) {
            throw new IllegalArgumentException(rsrc.getString("err_lineType_overlapInExtension"));
        }
        this.fireVetoableChange("maxOverlap", oldValue, newValue);
        this.maxOverlap = newValue;
        this.firePropertyChange("maxOverlap", oldValue, newValue);
    }

    public LineForm[] getLineForms() {
        return this.lineForms;
    }

    public void setLineForms(LineForm[] lineForms) throws PropertyVetoException {
        LineForm[] oldValue = this.lineForms;
        LineForm[] newValue = lineForms;
        if (oldValue == newValue) {
            return;
        }
        if (newValue == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        if (this.extending != null) {
            throw new IllegalStateException("This order is not implemented; call setExtending() later");
        }
        this.fireVetoableChange("lineForms", oldValue, newValue);
        this.lineForms = newValue;
        this.firePropertyChange("lineForms", oldValue, newValue);
    }

    public Domain getControlPointDomain() {
        return this.controlPointDomain;
    }

    public void setControlPointDomain(Domain controlPointDomain) throws PropertyVetoException {
        Domain oldValue = this.controlPointDomain;
        Domain newValue = controlPointDomain;
        if (oldValue == newValue) {
            return;
        }
        if (this.extending != null) {
            throw new IllegalStateException("This order is not implemented; call setExtending() later");
        }
        Type newValueType = newValue == null ? null : newValue.getType();
        if (newValueType != null) {
            newValueType = newValueType.resolveAliases();
        }
        if (newValueType != null && !(newValueType instanceof CoordType)) {
            throw new IllegalArgumentException(LineType.formatMessage("err_lineType_vertexNotCoordType", newValue.toString()));
        }
        this.fireVetoableChange("controlPointDomain", oldValue, newValue);
        this.controlPointDomain = newValue;
        this.firePropertyChange("controlPointDomain", oldValue, newValue);
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        LineType general = (LineType)wantToExtend;
        if (general.lineForms.length > 0) {
            for (int i = 0; i < this.lineForms.length; ++i) {
                boolean found = false;
                for (int j = 0; j < general.lineForms.length; ++j) {
                    if (this.lineForms[i] != general.lineForms[j]) continue;
                    found = true;
                }
                if (found) continue;
                throw new IllegalArgumentException(LineType.formatMessage("err_lineType_addedlineFormToInherited", this.lineForms[i].toString()));
            }
        }
        if (this.controlPointDomain != null && general.controlPointDomain != null && !this.controlPointDomain.isExtendingIndirectly(general.controlPointDomain)) {
            throw new IllegalArgumentException(LineType.formatMessage("err_lineType_controlPtDomainNotExtending", this.controlPointDomain.toString(), general.controlPointDomain.toString()));
        }
    }

    @Override
    public LineType clone() {
        return (LineType)super.clone();
    }
}

