/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;

public class SubStateSymbolFacet
extends KeyValueFacet {
    public static final SubStateSymbolFacet INSTANCE = new SubStateSymbolFacet();
    private static final int DIST_RIGHT = 15;
    private static final int DIST_BOTTOM = 5;

    private SubStateSymbolFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("symbol", new KeyValueFacet.ValueInfo((Object)SubStateSymbolEnum.SUBSTATE, "draw a substate symbol in the lower right corner"));
    }

    @Override
    public void handleValue(String value, PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        drawer.setLayer(DrawHandler.Layer.Foreground);
        ColorOwn prevBackgroundColor = drawer.getBackgroundColor();
        drawer.setBackgroundColor(ColorOwn.TRANSPARENT);
        SubStateSymbolEnum symbol = SubStateSymbolEnum.valueOf(value.toUpperCase());
        double w = state.getGridElementSize().getWidth();
        double h = state.getGridElementSize().getHeight();
        if (symbol == SubStateSymbolEnum.SUBSTATE) {
            double cW = drawer.getFontSize() * 1.6;
            double cH = cW * 0.4;
            double cR = cW * 0.15;
            double connectorW = cH;
            drawer.drawRectangleRound(w - 15.0 - cW, h - 5.0 - cH, cW, cH, cR);
            drawer.drawRectangleRound(w - 15.0 - cW - cW - connectorW, h - 5.0 - cH, cW, cH, cR);
            drawer.drawLine(w - 15.0 - cW - connectorW, h - 5.0 - cH / 2.0, w - 15.0 - cW, h - 5.0 - cH / 2.0);
            drawer.setLayer(DrawHandler.Layer.Background);
            drawer.setBackgroundColor(prevBackgroundColor);
        }
    }

    private static enum SubStateSymbolEnum {
        SUBSTATE;

    }
}

