/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.Main;
import com.baselet.gui.CurrentGui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComboBox;

public class PaletteComboBoxListener
implements ActionListener,
MouseWheelListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            String paletteName = ((JComboBox)e.getSource()).getSelectedItem().toString();
            CurrentGui.getInstance().getGui().showPalette(paletteName);
            this.setZoom();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int newIndex;
        JComboBox comboBox;
        if (e.getSource() instanceof JComboBox && (comboBox = (JComboBox)e.getSource()).getItemAt(newIndex = comboBox.getSelectedIndex() + e.getWheelRotation()) != null) {
            String newSelectedItem = comboBox.getItemAt(newIndex).toString();
            CurrentGui.getInstance().getGui().showPalette(newSelectedItem);
            comboBox.setSelectedIndex(newIndex);
            this.setZoom();
        }
    }

    private void setZoom() {
        if (Main.getInstance().getPalette() != null) {
            int factor = Main.getInstance().getPalette().getGridSize();
            CurrentGui.getInstance().getGui().setValueOfZoomDisplay(factor);
        }
    }
}

