/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPDownloadClient;
import net.schmizz.sshj.xfer.scp.SCPEngine;
import net.schmizz.sshj.xfer.scp.SCPUploadClient;

public class SCPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private final SessionFactory sessionFactory;

    public SCPFileTransfer(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SCPDownloadClient newSCPDownloadClient() {
        return new SCPDownloadClient(this.newSCPEngine());
    }

    public SCPUploadClient newSCPUploadClient() {
        return new SCPUploadClient(this.newSCPEngine());
    }

    private SCPEngine newSCPEngine() {
        return new SCPEngine(this.sessionFactory, this.getTransferListener());
    }

    @Override
    public void upload(String localPath, String remotePath) throws IOException {
        this.newSCPUploadClient().copy(new FileSystemFile(localPath), remotePath);
    }

    @Override
    public void download(String remotePath, String localPath) throws IOException {
        this.download(remotePath, new FileSystemFile(localPath));
    }

    @Override
    public void download(String remotePath, LocalDestFile localFile) throws IOException {
        this.newSCPDownloadClient().copy(remotePath, localFile);
    }

    @Override
    public void upload(LocalSourceFile localFile, String remotePath) throws IOException {
        this.newSCPUploadClient().copy(localFile, remotePath);
    }
}

