/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextCache {
    private final Object monitor = new Object();
    private final Map<MergedContextConfiguration, ApplicationContext> contextMap = new ConcurrentHashMap<MergedContextConfiguration, ApplicationContext>(64);
    private final Map<MergedContextConfiguration, Set<MergedContextConfiguration>> hierarchyMap = new ConcurrentHashMap<MergedContextConfiguration, Set<MergedContextConfiguration>>(64);
    private int hitCount;
    private int missCount;

    ContextCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.contextMap.clear();
            this.hierarchyMap.clear();
        }
    }

    void clearStatistics() {
        this.hitCount = 0;
        this.missCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Object object = this.monitor;
        synchronized (object) {
            return this.contextMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationContext get(MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Object object = this.monitor;
        synchronized (object) {
            ApplicationContext context = this.contextMap.get(key);
            if (context == null) {
                this.incrementMissCount();
            } else {
                this.incrementHitCount();
            }
            return context;
        }
    }

    private void incrementHitCount() {
        ++this.hitCount;
    }

    private void incrementMissCount() {
        ++this.missCount;
    }

    int getHitCount() {
        return this.hitCount;
    }

    int getMissCount() {
        return this.missCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(MergedContextConfiguration key, ApplicationContext context) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        Object object = this.monitor;
        synchronized (object) {
            this.contextMap.put(key, context);
            MergedContextConfiguration child = key;
            MergedContextConfiguration parent = child.getParent();
            while (parent != null) {
                Set<MergedContextConfiguration> list = this.hierarchyMap.get(parent);
                if (list == null) {
                    list = new HashSet<MergedContextConfiguration>();
                    this.hierarchyMap.put(parent, list);
                }
                list.add(child);
                child = parent;
                parent = child.getParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(MergedContextConfiguration key, DirtiesContext.HierarchyMode hierarchyMode) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        MergedContextConfiguration startKey = key;
        if (hierarchyMode == DirtiesContext.HierarchyMode.EXHAUSTIVE) {
            while (startKey.getParent() != null) {
                startKey = startKey.getParent();
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            ArrayList<MergedContextConfiguration> removedContexts = new ArrayList<MergedContextConfiguration>();
            this.remove(removedContexts, startKey);
            for (MergedContextConfiguration currentKey : removedContexts) {
                for (Set<MergedContextConfiguration> children : this.hierarchyMap.values()) {
                    children.remove(currentKey);
                }
            }
            for (MergedContextConfiguration currentKey : this.hierarchyMap.keySet()) {
                if (!this.hierarchyMap.get(currentKey).isEmpty()) continue;
                this.hierarchyMap.remove(currentKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(List<MergedContextConfiguration> removedContexts, MergedContextConfiguration key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Object object = this.monitor;
        synchronized (object) {
            ApplicationContext context;
            Set<MergedContextConfiguration> children = this.hierarchyMap.get(key);
            if (children != null) {
                for (MergedContextConfiguration child : children) {
                    this.remove(removedContexts, child);
                }
                this.hierarchyMap.remove(key);
            }
            if ((context = this.contextMap.remove(key)) instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)context).close();
            }
            removedContexts.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.monitor;
        synchronized (object) {
            return this.contextMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParentContextCount() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hierarchyMap.size();
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("size", this.size()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).append("parentContextCount", this.getParentContextCount()).toString();
    }
}

