/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoaderUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext
extends AttributeAccessorSupport {
    private static final long serialVersionUID = -5827157174866681233L;
    private static final Log logger = LogFactory.getLog(TestContext.class);
    private final ContextCache contextCache;
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    private final MergedContextConfiguration mergedContextConfiguration;
    private final Class<?> testClass;
    private Object testInstance;
    private Method testMethod;
    private Throwable testException;

    TestContext(Class<?> testClass, ContextCache contextCache) {
        this(testClass, contextCache, null);
    }

    TestContext(Class<?> testClass, ContextCache contextCache, String defaultContextLoaderClassName) {
        MergedContextConfiguration mergedContextConfiguration;
        Assert.notNull(testClass, (String)"Test class must not be null");
        Assert.notNull((Object)contextCache, (String)"ContextCache must not be null");
        this.testClass = testClass;
        this.contextCache = contextCache;
        this.cacheAwareContextLoaderDelegate = new CacheAwareContextLoaderDelegate(contextCache);
        if (testClass.isAnnotationPresent(ContextConfiguration.class) || testClass.isAnnotationPresent(ContextHierarchy.class)) {
            mergedContextConfiguration = ContextLoaderUtils.buildMergedContextConfiguration(testClass, defaultContextLoaderClassName, this.cacheAwareContextLoaderDelegate);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s]", testClass.getName()));
            }
            mergedContextConfiguration = new MergedContextConfiguration(testClass, null, null, null, null);
        }
        this.mergedContextConfiguration = mergedContextConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.cacheAwareContextLoaderDelegate.loadContext(this.mergedContextConfiguration);
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public Throwable getTestException() {
        return this.testException;
    }

    @Deprecated
    public void markApplicationContextDirty() {
        this.markApplicationContextDirty(null);
    }

    public void markApplicationContextDirty(DirtiesContext.HierarchyMode hierarchyMode) {
        this.contextCache.remove(this.mergedContextConfiguration, hierarchyMode);
    }

    void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).append("mergedContextConfiguration", (Object)this.mergedContextConfiguration).toString();
    }
}

