/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.testng;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;

@TestExecutionListeners(value={TransactionalTestExecutionListener.class})
@Transactional
public abstract class AbstractTransactionalTestNGSpringContextTests
extends AbstractTestNGSpringContextTests {
    @Deprecated
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected JdbcTemplate jdbcTemplate;
    private String sqlScriptEncoding;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    protected int countRowsInTable(String tableName) {
        return JdbcTestUtils.countRowsInTable(this.jdbcTemplate, tableName);
    }

    protected int countRowsInTableWhere(String tableName, String whereClause) {
        return JdbcTestUtils.countRowsInTableWhere(this.jdbcTemplate, tableName, whereClause);
    }

    protected int deleteFromTables(String ... names) {
        return JdbcTestUtils.deleteFromTables(this.jdbcTemplate, names);
    }

    protected void dropTables(String ... names) {
        JdbcTestUtils.dropTables(this.jdbcTemplate, names);
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        Resource resource = this.applicationContext.getResource(sqlResourcePath);
        JdbcTestUtils.executeSqlScript(this.jdbcTemplate, new EncodedResource(resource, this.sqlScriptEncoding), continueOnError);
    }
}

