/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.contrib.ssl.HttpHostFactory;
import org.apache.commons.httpclient.protocol.Protocol;

class HostConfigurationWithHostFactory
extends HostConfiguration {
    private final HttpHostFactory factory;
    private static final String DEFAULT_SCHEME = new String(HttpURL.DEFAULT_SCHEME);

    public HostConfigurationWithHostFactory(HttpHostFactory factory) {
        this.factory = factory;
    }

    private HostConfigurationWithHostFactory(HostConfigurationWithHostFactory that) {
        super((HostConfiguration)that);
        this.factory = that.factory;
    }

    public Object clone() {
        return new HostConfigurationWithHostFactory(this);
    }

    public void setHost(String host) {
        this.setHost(host, Protocol.getProtocol((String)DEFAULT_SCHEME).getDefaultPort());
    }

    public void setHost(String host, int port) {
        this.setHost(host, port, DEFAULT_SCHEME);
    }

    public synchronized void setHost(String host, int port, String scheme) {
        this.setHost(this.factory.getHost(this, scheme, host, port));
    }
}

