/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.regex.Pattern;

public final class RegexMetricFilter
implements MetricFilter {
    private final String tagKey;
    private final Pattern pattern;
    private final boolean matchIfMissingTag;
    private final boolean invert;

    public RegexMetricFilter(String tagKey, Pattern pattern, boolean matchIfMissingTag, boolean invert) {
        this.tagKey = tagKey;
        this.pattern = pattern;
        this.matchIfMissingTag = matchIfMissingTag;
        this.invert = invert;
    }

    @Override
    public boolean matches(MonitorConfig config) {
        Tag t;
        String name = config.getName();
        TagList tags = config.getTags();
        String value = this.tagKey == null ? name : ((t = tags.getTag(this.tagKey)) == null ? null : t.getValue());
        boolean match = this.matchIfMissingTag;
        if (value != null) {
            match = this.pattern.matcher(value).matches();
        }
        return match ^ this.invert;
    }
}

