/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Method;
import org.apache.catalina.Executor;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class ConnectorCreateRule
extends Rule {
    private static final Log log = LogFactory.getLog(ConnectorCreateRule.class);

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Service svc = (Service)this.digester.peek();
        Executor ex = null;
        if (attributes.getValue("executor") != null) {
            ex = svc.getExecutor(attributes.getValue("executor"));
        }
        Connector con = new Connector(attributes.getValue("protocol"));
        if (ex != null) {
            this._setExecutor(con, ex);
        }
        this.digester.push(con);
    }

    public void _setExecutor(Connector con, Executor ex) throws Exception {
        Method m = IntrospectionUtils.findMethod(con.getProtocolHandler().getClass(), "setExecutor", new Class[]{java.util.concurrent.Executor.class});
        if (m != null) {
            m.invoke((Object)con.getProtocolHandler(), ex);
        } else {
            log.warn((Object)("Connector [" + con + "] does not support external executors. Method setExecutor(java.util.concurrent.Executor) not found."));
        }
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        this.digester.pop();
    }
}

