/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.xml.XMLParser;
import org.apache.commons.jxpath.xml.XMLParser2;

public class DocumentContainer
extends XMLParser2
implements Container {
    public static final String MODEL_DOM = "DOM";
    public static final String MODEL_JDOM = "JDOM";
    private static final long serialVersionUID = -8713290334113427066L;
    private static HashMap parserClasses = new HashMap();
    private static HashMap parsers;
    private Object document;
    private URL xmlURL;
    private String model;

    public static void registerXMLParser(String model, XMLParser parser) {
        parsers.put(model, parser);
    }

    public static void registerXMLParser(String model, String parserClassName) {
        parserClasses.put(model, parserClassName);
    }

    public DocumentContainer(URL xmlURL) {
        this(xmlURL, MODEL_DOM);
    }

    public DocumentContainer(URL xmlURL, String model) {
        this.xmlURL = xmlURL;
        if (xmlURL == null) {
            throw new JXPathException("XML URL is null");
        }
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (this.document == null) {
            try {
                InputStream stream = null;
                try {
                    if (this.xmlURL != null) {
                        stream = this.xmlURL.openStream();
                    }
                    this.document = this.parseXML(stream);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new JXPathException("Cannot read XML from: " + this.xmlURL.toString(), ex);
            }
        }
        return this.document;
    }

    public Object parseXML(InputStream stream) {
        XMLParser parser = DocumentContainer.getParser(this.model);
        if (parser instanceof XMLParser2) {
            XMLParser2 parser2 = (XMLParser2)parser;
            parser2.setValidating(this.isValidating());
            parser2.setNamespaceAware(this.isNamespaceAware());
            parser2.setIgnoringElementContentWhitespace(this.isIgnoringElementContentWhitespace());
            parser2.setExpandEntityReferences(this.isExpandEntityReferences());
            parser2.setIgnoringComments(this.isIgnoringComments());
            parser2.setCoalescing(this.isCoalescing());
        }
        return parser.parseXML(stream);
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private static XMLParser getParser(String model) {
        XMLParser parser = (XMLParser)parsers.get(model);
        if (parser == null) {
            String className = (String)parserClasses.get(model);
            if (className == null) {
                throw new JXPathException("Unsupported XML model: " + model);
            }
            try {
                Class<?> clazz = Class.forName(className);
                parser = (XMLParser)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot allocate XMLParser: " + className, ex);
            }
            parsers.put(model, parser);
        }
        return parser;
    }

    static {
        parserClasses.put(MODEL_DOM, "org.apache.commons.jxpath.xml.DOMParser");
        parserClasses.put(MODEL_JDOM, "org.apache.commons.jxpath.xml.JDOMParser");
        parsers = new HashMap();
    }
}

