/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportMessage
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(PopupMenuExportMessage.class);
    private static final String CRLF = "\r\n";
    private ExtensionHistory extension = null;

    public PopupMenuExportMessage() {
        this.initialize();
    }

    public PopupMenuExportMessage(String string) {
        super(string);
    }

    private void initialize() {
        this.setText(Constant.messages.getString("history.export.messages.popup"));
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<HistoryReference> list = PopupMenuExportMessage.this.extension.getSelectedHistoryReferences();
                if (list.size() == 0) {
                    PopupMenuExportMessage.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.messages.select.warning"));
                    return;
                }
                File file = PopupMenuExportMessage.this.getOutputFile();
                if (file == null) {
                    return;
                }
                boolean bl = true;
                if (file.exists()) {
                    int n = PopupMenuExportMessage.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (n == 2) {
                        return;
                    }
                    if (n == 0) {
                        bl = false;
                    }
                }
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file, bl));
                    for (HistoryReference historyReference : list) {
                        PopupMenuExportMessage.this.exportHistory(historyReference, bufferedWriter);
                    }
                }
                catch (Exception exception) {
                    PopupMenuExportMessage.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath() + ".");
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (Exception exception) {
                        log.warn((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        });
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void exportHistory(HistoryReference historyReference, Writer writer) {
        if (historyReference == null) {
            return;
        }
        String string = null;
        try {
            HttpMessage httpMessage = historyReference.getHttpMessage();
            writer.write("==== " + historyReference.getHistoryId() + " ==========" + CRLF);
            string = httpMessage.getRequestHeader().toString();
            writer.write(string);
            string = httpMessage.getRequestBody().toString();
            writer.write(string);
            if (!string.endsWith(CRLF)) {
                writer.write(CRLF);
            }
            if (!httpMessage.getResponseHeader().isEmpty()) {
                string = httpMessage.getResponseHeader().toString();
                writer.write(string);
                string = httpMessage.getResponseBody().toString();
                writer.write(string);
                if (!string.endsWith(CRLF)) {
                    writer.write(CRLF);
                }
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private File getOutputFile() {
        JFileChooser jFileChooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.ascii");
            }
        });
        File file = null;
        int n = jFileChooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = file.getAbsolutePath();
            if (!string.endsWith(".txt")) {
                string = string + ".txt";
                file = new File(string);
            }
            return file;
        }
        return file;
    }
}

