/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpMethodHelper;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.ZapHttpConnectionManager;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.network.ZapNTLMScheme;
import org.zaproxy.zap.users.User;

public class HttpSender {
    public static final int PROXY_INITIATOR = 1;
    public static final int ACTIVE_SCANNER_INITIATOR = 2;
    public static final int SPIDER_INITIATOR = 3;
    public static final int FUZZER_INITIATOR = 4;
    public static final int AUTHENTICATION_INITIATOR = 5;
    public static final int MANUAL_REQUEST_INITIATOR = 6;
    public static final int CHECK_FOR_UPDATES_INITIATOR = 7;
    public static final int BEAN_SHELL_INITIATOR = 8;
    public static final int ACCESS_CONTROL_SCANNER_INITIATOR = 9;
    private static Logger log = Logger.getLogger(HttpSender.class);
    private static ProtocolSocketFactory sslFactory = null;
    private static Protocol protocol = null;
    private static List<HttpSenderListener> listeners = new ArrayList<HttpSenderListener>();
    private static Comparator<HttpSenderListener> listenersComparator = null;
    private User user = null;
    private static HttpMethodHelper helper;
    private static String userAgent;
    private static final ThreadLocal<Boolean> IN_LISTENER;
    private HttpClient client = null;
    private HttpClient clientViaProxy = null;
    private ConnectionParam param = null;
    private MultiThreadedHttpConnectionManager httpConnManager = null;
    private MultiThreadedHttpConnectionManager httpConnManagerProxy = null;
    private boolean followRedirect = false;
    private int initiator = -1;

    public HttpSender(ConnectionParam connectionParam, boolean bl, int n) {
        this.param = connectionParam;
        this.initiator = n;
        this.client = this.createHttpClient();
        this.clientViaProxy = this.createHttpClientViaProxy();
        this.setAllowCircularRedirects(true);
        boolean bl2 = this.param.isSingleCookieRequestHeader();
        this.client.getParams().setBooleanParameter("http.protocol.single-cookie-header", bl2);
        this.clientViaProxy.getParams().setBooleanParameter("http.protocol.single-cookie-header", bl2);
        if (bl) {
            this.checkState();
        }
    }

    public static SSLConnector getSSLConnector() {
        return (SSLConnector)protocol.getSocketFactory();
    }

    private void checkState() {
        if (this.param.isHttpStateEnabled()) {
            this.client.setState(this.param.getHttpState());
            this.clientViaProxy.setState(this.param.getHttpState());
            this.client.getParams().setCookiePolicy("compatibility");
            this.clientViaProxy.getParams().setCookiePolicy("compatibility");
        } else {
            this.client.getParams().setCookiePolicy("ignoreCookies");
            this.clientViaProxy.getParams().setCookiePolicy("ignoreCookies");
        }
    }

    private HttpClient createHttpClient() {
        this.httpConnManager = new MultiThreadedHttpConnectionManager();
        this.setCommonManagerParams(this.httpConnManager);
        return new HttpClient((HttpConnectionManager)this.httpConnManager);
    }

    private HttpClient createHttpClientViaProxy() {
        if (!this.param.isUseProxyChain()) {
            return this.createHttpClient();
        }
        this.httpConnManagerProxy = new MultiThreadedHttpConnectionManager();
        this.setCommonManagerParams(this.httpConnManagerProxy);
        HttpClient httpClient = new HttpClient((HttpConnectionManager)this.httpConnManagerProxy);
        httpClient.getHostConfiguration().setProxy(this.param.getProxyChainName(), this.param.getProxyChainPort());
        if (this.param.isUseProxyChainAuth()) {
            httpClient.getState().setProxyCredentials(this.getAuthScope(this.param), (Credentials)this.getNTCredentials(this.param));
        }
        return httpClient;
    }

    private NTCredentials getNTCredentials(ConnectionParam connectionParam) {
        return new NTCredentials(connectionParam.getProxyChainUserName(), connectionParam.getProxyChainPassword(), "", connectionParam.getProxyChainRealm().equals("") ? "" : connectionParam.getProxyChainRealm());
    }

    private AuthScope getAuthScope(ConnectionParam connectionParam) {
        return new AuthScope(connectionParam.getProxyChainName(), connectionParam.getProxyChainPort(), connectionParam.getProxyChainRealm().equals("") ? AuthScope.ANY_REALM : connectionParam.getProxyChainRealm());
    }

    public int executeMethod(HttpMethod httpMethod, HttpState httpState) throws IOException {
        HttpClient httpClient;
        int n = -1;
        String string = httpMethod.getURI().getHost();
        httpMethod.setDoAuthentication(true);
        HostConfiguration hostConfiguration = null;
        if (HttpSender.isConnectionUpgrade(httpMethod)) {
            httpClient = new HttpClient((HttpConnectionManager)new ZapHttpConnectionManager());
            if (this.param.isUseProxy(string)) {
                httpClient.getHostConfiguration().setProxy(this.param.getProxyChainName(), this.param.getProxyChainPort());
                if (this.param.isUseProxyChainAuth()) {
                    httpClient.getState().setProxyCredentials(this.getAuthScope(this.param), (Credentials)this.getNTCredentials(this.param));
                }
            }
        } else {
            httpClient = this.param.isUseProxy(string) ? this.clientViaProxy : this.client;
        }
        if (this.initiator == 7) {
            hostConfiguration = new HostConfiguration(){

                public synchronized void setHost(URI uRI) {
                    try {
                        this.setHost(new HttpHost(uRI.getHost(), uRI.getPort(), this.getProtocol()));
                    }
                    catch (URIException uRIException) {
                        throw new IllegalArgumentException(uRIException.toString());
                    }
                }
            };
            hostConfiguration.setHost(string, httpMethod.getURI().getPort(), new Protocol("https", (ProtocolSocketFactory)new SSLConnector(false), 443));
            if (this.param.isUseProxy(string)) {
                hostConfiguration.setProxyHost(new ProxyHost(this.param.getProxyChainName(), this.param.getProxyChainPort()));
                if (this.param.isUseProxyChainAuth()) {
                    httpClient.getState().setProxyCredentials(this.getAuthScope(this.param), (Credentials)this.getNTCredentials(this.param));
                }
            }
        }
        if (httpState != null) {
            httpMethod.getParams().setCookiePolicy("compatibility");
        }
        n = httpClient.executeMethod(hostConfiguration, httpMethod, httpState);
        return n;
    }

    private static boolean isConnectionUpgrade(HttpMethod httpMethod) {
        Header header = httpMethod.getRequestHeader("connection");
        if (header == null) {
            return false;
        }
        return header.getValue().toLowerCase().contains("upgrade");
    }

    public void shutdown() {
        if (this.httpConnManager != null) {
            this.httpConnManager.shutdown();
        }
        if (this.httpConnManagerProxy != null) {
            this.httpConnManagerProxy.shutdown();
        }
    }

    public void sendAndReceive(HttpMessage httpMessage) throws IOException {
        this.sendAndReceive(httpMessage, this.followRedirect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndReceive(HttpMessage httpMessage, boolean bl) throws IOException {
        log.debug((Object)("sendAndReceive " + httpMessage.getRequestHeader().getMethod() + " " + httpMessage.getRequestHeader().getURI() + " start"));
        httpMessage.setTimeSentMillis(System.currentTimeMillis());
        try {
            this.notifyRequestListeners(httpMessage);
            if (!bl || !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST") && !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("PUT")) {
                this.sendAuthenticated(httpMessage, bl);
                return;
            }
            this.sendAuthenticated(httpMessage, false);
            HttpMessage httpMessage2 = httpMessage.cloneAll();
            for (int i = 0; i < 1 && HttpStatusCode.isRedirection(httpMessage2.getResponseHeader().getStatusCode()) && httpMessage2.getResponseHeader().getStatusCode() != 304; ++i) {
                String string = httpMessage2.getResponseHeader().getHeader("Location");
                URI uRI = httpMessage2.getRequestHeader().getURI();
                URI uRI2 = new URI(uRI, string, false);
                httpMessage2.getRequestHeader().setURI(uRI2);
                httpMessage2.getRequestHeader().setMethod("GET");
                httpMessage2.getRequestHeader().setHeader("Content-Length", null);
                this.sendAuthenticated(httpMessage2, true);
            }
            httpMessage.setResponseHeader(httpMessage2.getResponseHeader());
            httpMessage.setResponseBody(httpMessage2.getResponseBody());
        }
        finally {
            httpMessage.setTimeElapsedMillis((int)(System.currentTimeMillis() - httpMessage.getTimeSentMillis()));
            log.debug((Object)("sendAndReceive " + httpMessage.getRequestHeader().getMethod() + " " + httpMessage.getRequestHeader().getURI() + " took " + httpMessage.getTimeElapsedMillis()));
            this.notifyResponseListeners(httpMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRequestListeners(HttpMessage httpMessage) {
        if (IN_LISTENER.get() != null) {
            return;
        }
        try {
            IN_LISTENER.set(true);
            for (HttpSenderListener httpSenderListener : listeners) {
                try {
                    httpSenderListener.onHttpRequestSend(httpMessage, this.initiator, this);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        finally {
            IN_LISTENER.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResponseListeners(HttpMessage httpMessage) {
        if (IN_LISTENER.get() != null) {
            return;
        }
        try {
            IN_LISTENER.set(true);
            for (HttpSenderListener httpSenderListener : listeners) {
                try {
                    httpSenderListener.onHttpResponseReceive(httpMessage, this.initiator, this);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        finally {
            IN_LISTENER.set(null);
        }
    }

    public User getUser(HttpMessage httpMessage) {
        if (this.user != null) {
            return this.user;
        }
        return httpMessage.getRequestingUser();
    }

    private void sendAuthenticated(HttpMessage httpMessage, boolean bl) throws IOException {
        User user = this.getUser(httpMessage);
        if (this.initiator != 5 && user != null) {
            user.processMessageToMatchUser(httpMessage);
        }
        log.debug((Object)("Sending message to: " + httpMessage.getRequestHeader().getURI().toString()));
        this.send(httpMessage, bl);
        if (this.initiator != 5 && user != null && !httpMessage.getRequestHeader().isImage() && !user.isAuthenticated(httpMessage)) {
            log.debug((Object)("First try to send authenticated message failed for " + httpMessage.getRequestHeader().getURI() + ". Authenticating and trying again..."));
            user.queueAuthentication(httpMessage);
            user.processMessageToMatchUser(httpMessage);
            this.send(httpMessage, bl);
        } else {
            log.debug((Object)"SUCCESSFUL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpMessage httpMessage, boolean bl) throws IOException {
        HttpMethod httpMethod = null;
        HttpResponseHeader httpResponseHeader = null;
        try {
            httpMethod = this.runMethod(httpMessage, bl);
            httpResponseHeader = HttpMethodHelper.getHttpResponseHeader(httpMethod);
            httpResponseHeader.setHeader("Transfer-Encoding", null);
            httpMessage.setResponseHeader(httpResponseHeader);
            httpMessage.getResponseBody().setCharset(httpResponseHeader.getCharset());
            httpMessage.getResponseBody().setLength(0);
            if (!httpMessage.isEventStream()) {
                httpMessage.getResponseBody().append(httpMethod.getResponseBody());
            }
            httpMessage.setResponseFromTargetHost(true);
            if (httpMethod instanceof ZapGetMethod) {
                httpMessage.setUserObject(httpMethod);
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    private HttpMethod runMethod(HttpMessage httpMessage, boolean bl) throws IOException {
        User user;
        HttpMethod httpMethod = null;
        this.modifyUserAgent(httpMessage);
        httpMethod = helper.createRequestMethod(httpMessage.getRequestHeader(), httpMessage.getRequestBody());
        if (!(httpMethod instanceof EntityEnclosingMethod)) {
            httpMethod.setFollowRedirects(bl);
        }
        if ((user = this.getUser(httpMessage)) != null) {
            this.executeMethod(httpMethod, user.getCorrespondingHttpState());
        } else {
            this.executeMethod(httpMethod, null);
        }
        HttpMethodHelper.updateHttpRequestHeaderSent(httpMessage.getRequestHeader(), httpMethod);
        return httpMethod;
    }

    public void setFollowRedirect(boolean bl) {
        this.followRedirect = bl;
    }

    private void modifyUserAgent(HttpMessage httpMessage) {
        try {
            if (userAgent.equals("") || httpMessage.getRequestHeader().isEmpty()) {
                return;
            }
            String string = httpMessage.getRequestHeader().getHeader("User-Agent");
            if (string == null) {
                string = "";
            }
            if (string.indexOf(userAgent) >= 0) {
                return;
            }
            String string2 = "";
            if (!string.equals("") && !string.endsWith(" ")) {
                string2 = " ";
            }
            string = string + string2 + userAgent;
            httpMessage.getRequestHeader().setHeader("User-Agent", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String string) {
        userAgent = string;
    }

    private void setCommonManagerParams(MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager) {
        multiThreadedHttpConnectionManager.getParams().setSoTimeout(this.param.getTimeoutInSecs() * 1000);
        multiThreadedHttpConnectionManager.getParams().setStaleCheckingEnabled(true);
        multiThreadedHttpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(10000);
        multiThreadedHttpConnectionManager.getParams().setMaxTotalConnections(200000);
    }

    public static void addListener(HttpSenderListener httpSenderListener) {
        listeners.add(httpSenderListener);
        Collections.sort(listeners, HttpSender.getListenersComparator());
    }

    private static Comparator<HttpSenderListener> getListenersComparator() {
        if (listenersComparator == null) {
            HttpSender.createListenersComparator();
        }
        return listenersComparator;
    }

    private static synchronized void createListenersComparator() {
        if (listenersComparator == null) {
            listenersComparator = new Comparator<HttpSenderListener>(){

                @Override
                public int compare(HttpSenderListener httpSenderListener, HttpSenderListener httpSenderListener2) {
                    int n;
                    int n2 = httpSenderListener.getListenerOrder();
                    if (n2 < (n = httpSenderListener2.getListenerOrder())) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
    }

    public void setUser(User user) {
        this.user = user;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setRemoveUserDefinedAuthHeaders(boolean bl) {
        this.client.getParams().setBooleanParameter("remove.user.defined.auth.headers", bl);
        this.clientViaProxy.getParams().setBooleanParameter("remove.user.defined.auth.headers", bl);
    }

    public void setMaxRetriesOnIOError(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter retries must be greater or equal to zero.");
        }
        DefaultHttpMethodRetryHandler defaultHttpMethodRetryHandler = new DefaultHttpMethodRetryHandler(n, false);
        this.client.getParams().setParameter("http.method.retry-handler", (Object)defaultHttpMethodRetryHandler);
        this.clientViaProxy.getParams().setParameter("http.method.retry-handler", (Object)defaultHttpMethodRetryHandler);
    }

    public void setMaxRedirects(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter maxRedirects must be greater or equal to zero.");
        }
        this.client.getParams().setIntParameter("http.protocol.max-redirects", n);
        this.clientViaProxy.getParams().setIntParameter("http.protocol.max-redirects", n);
    }

    public void setAllowCircularRedirects(boolean bl) {
        this.client.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", bl);
        this.clientViaProxy.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", bl);
    }

    static {
        try {
            protocol = Protocol.getProtocol((String)"https");
            sslFactory = protocol.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sslFactory == null || !(sslFactory instanceof SSLConnector)) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SSLConnector(true), 443));
        }
        AuthPolicy.registerAuthScheme((String)"NTLM", ZapNTLMScheme.class);
        helper = new HttpMethodHelper();
        userAgent = "";
        IN_LISTENER = new ThreadLocal();
    }
}

