/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class WikiAPIGenerator {
    private static final String WIKI_FILE_EXTENSION = ".md";
    private String base = "ApiGen_";
    private String title = "# ZAP " + Constant.PROGRAM_VERSION + " API\n";
    private File dir;
    private int methods = 0;
    private boolean optional = false;
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));

    public WikiAPIGenerator() {
        this.dir = new File("../zaproxy-wiki");
    }

    public WikiAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    private void generateWikiIndex() throws IOException {
        File file = new File(this.dir, this.base + "Index" + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.title);
        fileWriter.write("## Components\n");
        for (ApiImplementor apiImplementor : ApiGeneratorUtils.getAllImplementors()) {
            fileWriter.write("  * [" + this.base + apiImplementor.getPrefix() + " " + apiImplementor.getPrefix() + "]\n");
        }
        fileWriter.write("\n\n[" + this.base + "Full" + " Full list.]\n\n");
        fileWriter.close();
    }

    private void generateWikiFull() throws IOException {
        File file = new File(this.dir, this.base + "Full" + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.title);
        fileWriter.write("## Full List\n");
        fileWriter.write("| _Component_ | _Name_ | _Type_ | _Parameters_ | _Description_ |\n");
        fileWriter.write("|:------------|:-------|:-------|:-------------|:--------------|\n");
        for (ApiImplementor apiImplementor : ApiGeneratorUtils.getAllImplementors()) {
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter, true);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter, true);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter, true);
            }
        }
        fileWriter.write("\n");
        fileWriter.write("Starred parameters are mandatory.\n\n");
        if (this.optional) {
            fileWriter.write("This component is optional and therefore the API will only work if it is installed.\n\n");
        }
        fileWriter.write("Back to [index](" + this.base + "Index)\n\n");
        fileWriter.close();
    }

    public void generateWikiFiles(List<ApiImplementor> list) throws IOException {
        this.generateWikiIndex();
        for (ApiImplementor apiImplementor : list) {
            this.generateWikiComponent(apiImplementor);
        }
        this.methods = 0;
        this.generateWikiFull();
        System.out.println("Generated a total of " + this.methods + " methods");
    }

    private void generateWikiElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        this.generateWikiElement(apiElement, string, string2, writer, false);
    }

    private void generateWikiElement(ApiElement apiElement, String string, String string2, Writer writer, boolean bl) throws IOException {
        if (bl) {
            writer.write("| " + string);
        }
        writer.write("| " + apiElement.getName() + "| " + string2 + " | ");
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string3 : apiElement.getMandatoryParamNames()) {
                writer.write(string3 + "* ");
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string3 : apiElement.getOptionalParamNames()) {
                writer.write(string3 + " ");
            }
        }
        writer.write(" | ");
        Object object = apiElement.getDescriptionTag();
        if (object == null) {
            object = string + ".api." + string2 + "." + apiElement.getName();
        }
        try {
            writer.write(this.msgs.getString((String)object));
        }
        catch (Exception exception) {
            System.out.println("No i18n for: " + (String)object);
        }
        writer.write(" |\n");
        ++this.methods;
    }

    private void generateWikiComponent(ApiImplementor apiImplementor) throws IOException {
        File file = new File(this.dir, this.base + apiImplementor.getPrefix() + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.title);
        fileWriter.write("## Component: " + apiImplementor.getPrefix() + "\n");
        fileWriter.write("| _Name_ | _Type_ | _Parameters_ | _Description_ |\n");
        fileWriter.write("|:-------|:-------|:-------------|:--------------|\n");
        for (ApiElement apiElement : apiImplementor.getApiViews()) {
            this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiActions()) {
            this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiOthers()) {
            this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter);
        }
        fileWriter.write("\n");
        fileWriter.write("Starred parameters are mandatory\n\n");
        fileWriter.write("Back to [index](" + this.base + "Index)\n\n");
        fileWriter.close();
    }

    public static void main(String[] stringArray) throws Exception {
        WikiAPIGenerator wikiAPIGenerator = new WikiAPIGenerator();
        wikiAPIGenerator.generateWikiFiles(ApiGeneratorUtils.getAllImplementors());
    }
}

