/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuNote
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -5692544221103745600L;
    private static final Logger logger = Logger.getLogger(PopupMenuNote.class);
    private final ExtensionHistory extension;

    public PopupMenuNote(ExtensionHistory extensionHistory) {
        super(Constant.messages.getString("history.note.popup"));
        this.extension = extensionHistory;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    @Override
    public void performAction(HistoryReference historyReference) {
        try {
            this.extension.showNotesAddDialog(historyReference, historyReference.getHttpMessage().getNote());
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

