/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.largerequest;

import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.component.split.request.RequestSplitComponent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.largerequest.LargeRequestStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.largerequest.LargeRequestUtil;
import org.zaproxy.zap.extension.httppanel.view.largerequest.RequestLargeRequestAllView;
import org.zaproxy.zap.extension.httppanel.view.largerequest.RequestLargeRequestSplitView;
import org.zaproxy.zap.view.HttpPanelManager;

public class ExtensionHttpPanelLargeRequestView
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionHttpPanelLargeRequestView";

    public ExtensionHttpPanelLargeRequestView() {
        super(NAME);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            HttpPanelManager httpPanelManager = HttpPanelManager.getInstance();
            httpPanelManager.addRequestViewFactory("RequestSplit", new RequestLargeRequestSplitViewFactory());
            httpPanelManager.addRequestDefaultViewSelectorFactory("RequestSplit", new LargeRequestDefaultSplitViewSelectorFactory());
            httpPanelManager.addRequestViewFactory("RequestAll", new RequestLargeRequestAllViewFactory());
            httpPanelManager.addRequestDefaultViewSelectorFactory("RequestAll", new LargeRequestDefaultAllViewSelectorFactory());
        }
    }

    @Override
    public boolean canUnload() {
        return false;
    }

    @Override
    public void unload() {
        if (this.getView() != null) {
            HttpPanelManager httpPanelManager = HttpPanelManager.getInstance();
            httpPanelManager.removeRequestViewFactory("RequestSplit", "RequestLargeRequestSplitViewFactory");
            httpPanelManager.removeRequestViews("RequestSplit", "RequestLargeRequestSplitView", (Object)RequestSplitComponent.ViewComponent.BODY);
            httpPanelManager.removeRequestDefaultViewSelectorFactory("RequestSplit", "LargeRequestDefaultSplitViewSelectorFactory");
            httpPanelManager.removeRequestDefaultViewSelectorFactoryAndDefaultViewSelectorsAdded("RequestSplit", "LargeRequestDefaultSplitViewSelector", (Object)RequestSplitComponent.ViewComponent.BODY);
            httpPanelManager.removeRequestViewFactory("RequestAll", "RequestLargeRequestAllViewFactory");
            httpPanelManager.removeRequestViews("RequestAll", "RequestLargeRequestAllView", null);
            httpPanelManager.removeRequestDefaultViewSelectorFactory("RequestAll", "LargeRequestDefaultAllViewSelectorFactory");
            httpPanelManager.removeRequestDefaultViewSelectorFactoryAndDefaultViewSelectorsAdded("RequestAll", "LargeRequestDefaultAllViewSelector", null);
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    private static final class LargeRequestDefaultAllViewSelectorFactory
    implements HttpPanelManager.HttpPanelDefaultViewSelectorFactory {
        private static HttpPanelDefaultViewSelector defaultViewSelector = null;
        public static final String NAME = "LargeRequestDefaultAllViewSelectorFactory";

        private LargeRequestDefaultAllViewSelectorFactory() {
        }

        private HttpPanelDefaultViewSelector getDefaultViewSelector() {
            if (defaultViewSelector == null) {
                this.createViewSelector();
            }
            return defaultViewSelector;
        }

        private synchronized void createViewSelector() {
            if (defaultViewSelector == null) {
                defaultViewSelector = new LargeRequestDefaultAllViewSelector();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelDefaultViewSelector getNewDefaultViewSelector() {
            return this.getDefaultViewSelector();
        }

        @Override
        public Object getOptions() {
            return null;
        }
    }

    private static final class LargeRequestDefaultSplitViewSelectorFactory
    implements HttpPanelManager.HttpPanelDefaultViewSelectorFactory {
        private static HttpPanelDefaultViewSelector defaultViewSelector = null;
        public static final String NAME = "LargeRequestDefaultSplitViewSelectorFactory";

        private LargeRequestDefaultSplitViewSelectorFactory() {
        }

        private HttpPanelDefaultViewSelector getDefaultViewSelector() {
            if (defaultViewSelector == null) {
                this.createViewSelector();
            }
            return defaultViewSelector;
        }

        private synchronized void createViewSelector() {
            if (defaultViewSelector == null) {
                defaultViewSelector = new LargeRequestDefaultSplitViewSelector();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelDefaultViewSelector getNewDefaultViewSelector() {
            return this.getDefaultViewSelector();
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.BODY;
        }
    }

    private static final class LargeRequestDefaultAllViewSelector
    implements HttpPanelDefaultViewSelector {
        public static final String NAME = "LargeRequestDefaultAllViewSelector";

        private LargeRequestDefaultAllViewSelector() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean matchToDefaultView(Message message) {
            return LargeRequestUtil.isLargeRequest(message);
        }

        @Override
        public String getViewName() {
            return "RequestLargeRequestAllView";
        }

        @Override
        public int getOrder() {
            return 50;
        }
    }

    private static final class RequestLargeRequestAllViewFactory
    implements HttpPanelManager.HttpPanelViewFactory {
        public static final String NAME = "RequestLargeRequestAllViewFactory";

        private RequestLargeRequestAllViewFactory() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelView getNewView() {
            return new RequestLargeRequestAllView(new LargeRequestStringHttpPanelViewModel());
        }

        @Override
        public Object getOptions() {
            return null;
        }
    }

    private static final class LargeRequestDefaultSplitViewSelector
    implements HttpPanelDefaultViewSelector {
        public static final String NAME = "LargeRequestDefaultSplitViewSelector";

        private LargeRequestDefaultSplitViewSelector() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean matchToDefaultView(Message message) {
            return LargeRequestUtil.isLargeRequest(message);
        }

        @Override
        public String getViewName() {
            return "RequestLargeRequestSplitView";
        }

        @Override
        public int getOrder() {
            return 50;
        }
    }

    private static final class RequestLargeRequestSplitViewFactory
    implements HttpPanelManager.HttpPanelViewFactory {
        public static final String NAME = "RequestLargeRequestSplitViewFactory";

        private RequestLargeRequestSplitViewFactory() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public HttpPanelView getNewView() {
            return new RequestLargeRequestSplitView();
        }

        @Override
        public Object getOptions() {
            return RequestSplitComponent.ViewComponent.BODY;
        }
    }
}

