/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class CaretVisibilityEnforcerOnFocusGain
implements PropertyChangeListener,
FocusListener {
    private int caretBlinkRate;
    private JTextComponent textComponent;
    private boolean enforceCaretVisibility;

    public CaretVisibilityEnforcerOnFocusGain(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.enforceCaretVisibility = false;
    }

    public void setEnforceVisibilityOnFocusGain(boolean bl) {
        if (this.enforceCaretVisibility == bl) {
            return;
        }
        this.enforceCaretVisibility = bl;
        if (this.enforceCaretVisibility) {
            this.setupWithCaret(this.textComponent.getCaret());
            this.textComponent.addPropertyChangeListener("caret", this);
        } else {
            this.removeListenersWithCaret(this.textComponent.getCaret());
            this.textComponent.removePropertyChangeListener("caret", this);
        }
    }

    private void setupWithCaret(Caret caret) {
        if (caret != null) {
            this.textComponent.addFocusListener(this);
            this.textComponent.addPropertyChangeListener("editable", this);
            this.caretBlinkRate = caret.getBlinkRate();
            if (!this.textComponent.isEditable()) {
                caret.setBlinkRate(0);
            }
        } else {
            this.caretBlinkRate = 0;
        }
    }

    private void removeListenersWithCaret(Caret caret) {
        if (caret != null) {
            this.textComponent.removeFocusListener(this);
            this.textComponent.removePropertyChangeListener("editable", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("caret".equals(string)) {
            this.removeListenersWithCaret((Caret)propertyChangeEvent.getOldValue());
            this.setupWithCaret((Caret)propertyChangeEvent.getNewValue());
        } else if ("editable".equals(string)) {
            if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.textComponent.getCaret().setBlinkRate(this.caretBlinkRate);
            } else {
                this.textComponent.getCaret().setBlinkRate(0);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.textComponent.getCaret().setVisible(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

