/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.extension.spider.SpiderMessagesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

class SpiderMessagesTable
extends HistoryReferencesTable {
    private static final long serialVersionUID = -1910120966638329368L;
    private final ExtensionHistory extensionHistory;

    public SpiderMessagesTable(SpiderMessagesTableModel spiderMessagesTableModel) {
        super(spiderMessagesTableModel);
        this.setName("SpiderMessagesTable");
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.hrefid")).setVisible(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.timestamp.response")).setVisible(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.size.requestheader")).setVisible(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.size.requestbody")).setVisible(false);
        this.setSortOrder(0, SortOrder.ASCENDING);
        this.extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
    }

    @Override
    public void setModel(TableModel tableModel) {
        int n = this.getSortedColumnIndex();
        SortOrder sortOrder = this.getSortOrder(n);
        super.setModel(tableModel);
        if (n != -1) {
            this.setSortOrder(n, sortOrder);
        }
    }

    @Override
    protected HistoryReference getHistoryReferenceAtViewRow(int n) {
        HistoryReference historyReference = super.getHistoryReferenceAtViewRow(n);
        if (historyReference == null) {
            return null;
        }
        if (this.extensionHistory == null || this.extensionHistory.getHistoryReference(historyReference.getHistoryId()) == null) {
            return null;
        }
        return historyReference;
    }
}

