/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.model.VulnerabilitiesLoader;
import org.zaproxy.zap.model.Vulnerability;

public final class Vulnerabilities {
    private static List<Vulnerability> vulnerabilities;
    private static Map<String, Vulnerability> vulnerabilitiesMap;

    private Vulnerabilities() {
    }

    private static synchronized void init() {
        if (vulnerabilities == null) {
            VulnerabilitiesLoader vulnerabilitiesLoader = new VulnerabilitiesLoader(Paths.get(Constant.getZapInstall(), "lang"), "vulnerabilities", ".xml");
            List<Vulnerability> list = vulnerabilitiesLoader.load(Constant.getLocale());
            HashMap<String, Vulnerability> hashMap = new HashMap<String, Vulnerability>();
            for (Vulnerability vulnerability : list) {
                hashMap.put(vulnerability.getId(), vulnerability);
            }
            vulnerabilitiesMap = Collections.unmodifiableMap(hashMap);
            vulnerabilities = list;
        }
    }

    public static List<Vulnerability> getAllVulnerabilities() {
        Vulnerabilities.initializeIfEmpty();
        return vulnerabilities;
    }

    public static Vulnerability getVulnerability(String string) {
        Vulnerabilities.initializeIfEmpty();
        return vulnerabilitiesMap.get(string);
    }

    private static void initializeIfEmpty() {
        if (vulnerabilities == null) {
            Vulnerabilities.init();
        }
    }

    public static String getDescription(Vulnerability vulnerability) {
        if (vulnerability != null) {
            return vulnerability.getDescription();
        }
        return "Failed to load vulnerability description from file";
    }

    public static String getSolution(Vulnerability vulnerability) {
        if (vulnerability != null) {
            return vulnerability.getSolution();
        }
        return "Failed to load vulnerability solution from file";
    }

    public static String getReference(Vulnerability vulnerability) {
        if (vulnerability != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : vulnerability.getReferences()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        return "Failed to load vulnerability reference from file";
    }
}

