/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.zaproxy.zap.utils.BoyerMooreMatcher;

public class ContentMatcher {
    private static final String TAG_PATTERNS = "Patterns";
    private static final String TAG_PATTERN = "Pattern";
    private static final String TAG_PATTERN_TYPE = "type";
    private static final String TAG_PATTERN_TYPE_STRING = "string";
    private static final String TAG_PATTERN_TYPE_REGEX = "regex";
    private List<BoyerMooreMatcher> strings;
    private List<Pattern> patterns;

    public static ContentMatcher getInstance(String string) {
        ContentMatcher contentMatcher = new ContentMatcher();
        try {
            contentMatcher.loadXMLPatternDefinitions(contentMatcher.getClass().getResourceAsStream(string));
        }
        catch (IOException | JDOMException throwable) {
            throw new IllegalArgumentException("Failed to initialize the ContentMatcher object using: " + string, throwable);
        }
        return contentMatcher;
    }

    public static ContentMatcher getInstance(InputStream inputStream) {
        ContentMatcher contentMatcher = new ContentMatcher();
        try {
            contentMatcher.loadXMLPatternDefinitions(inputStream);
        }
        catch (IOException | JDOMException throwable) {
            throw new IllegalArgumentException("Failed to initialize the ContentMatcher object using that stream", throwable);
        }
        return contentMatcher;
    }

    protected void loadXMLPatternDefinitions(InputStream inputStream) throws JDOMException, IOException {
        this.strings = new ArrayList<BoyerMooreMatcher>();
        this.patterns = new ArrayList<Pattern>();
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(inputStream);
        Element element = document.getRootElement();
        for (Object e : element.getChildren(TAG_PATTERN)) {
            element = (Element)e;
            String string = element.getText();
            if (string == null || string.isEmpty()) continue;
            if (element.getAttributeValue(TAG_PATTERN_TYPE).equalsIgnoreCase(TAG_PATTERN_TYPE_REGEX)) {
                this.patterns.add(Pattern.compile(element.getText()));
                continue;
            }
            this.strings.add(new BoyerMooreMatcher(element.getText()));
        }
    }

    public String findInContent(String string) {
        for (BoyerMooreMatcher object : this.strings) {
            if (object.findInContent(string) < 0) continue;
            return object.getPattern();
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.group();
        }
        return null;
    }

    public List<String> findAllInContent(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (BoyerMooreMatcher object : this.strings) {
            if (object.findInContent(string) < 0) continue;
            linkedList.add(object.getPattern());
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            linkedList.add(string);
        }
        return linkedList;
    }
}

