/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.ArrayUtils;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.view.JCheckBoxTree;

public class TechnologyTreePanel
extends JPanel {
    private static final long serialVersionUID = 5514692105773714202L;
    private final JCheckBoxTree techTree;
    private final HashMap<Tech, DefaultMutableTreeNode> techToNodeMap;

    public TechnologyTreePanel(String string) {
        this.setLayout(new BorderLayout());
        this.techToNodeMap = new HashMap();
        this.techTree = new JCheckBoxTree(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void setExpandedState(TreePath treePath, boolean bl) {
                if (bl) {
                    super.setExpandedState(treePath, bl);
                }
            }
        };
        TechSet techSet = new TechSet(Tech.builtInTech);
        Iterator<Tech> iterator = techSet.getIncludeTech().iterator();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        while (iterator.hasNext()) {
            Tech tech = iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = tech.getParent() != null ? this.techToNodeMap.get(tech.getParent()) : null;
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(tech.getUiName());
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            this.techToNodeMap.put(tech, defaultMutableTreeNode3);
        }
        this.techTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.techTree.expandAll();
        this.techTree.setCheckBoxEnabled(new TreePath(defaultMutableTreeNode), false);
        this.reset();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.techTree);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.add((Component)jScrollPane, "Center");
    }

    public void setTechSet(TechSet techSet) {
        TreeSet<Tech> treeSet = techSet.getIncludeTech();
        for (Map.Entry<Tech, DefaultMutableTreeNode> entry : this.techToNodeMap.entrySet()) {
            TreePath treePath = this.getPath(entry.getValue());
            Tech tech = entry.getKey();
            if (ArrayUtils.contains(Tech.builtInTopLevelTech, tech)) {
                this.techTree.check(treePath, TechnologyTreePanel.containsAnyOfTopLevelTech(treeSet, tech));
                continue;
            }
            this.techTree.check(treePath, techSet.includes(tech));
        }
    }

    public TechSet getTechSet() {
        TechSet techSet = new TechSet();
        for (Map.Entry<Tech, DefaultMutableTreeNode> entry : this.techToNodeMap.entrySet()) {
            TreePath treePath = this.getPath(entry.getValue());
            Tech tech = entry.getKey();
            if (this.techTree.isSelectedFully(treePath)) {
                techSet.include(tech);
                continue;
            }
            techSet.exclude(tech);
        }
        return techSet;
    }

    public void reset() {
        this.techTree.checkSubTree(this.techTree.getPathForRow(0), true);
    }

    private TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(arrayList);
        return new TreePath(arrayList.toArray());
    }

    private static boolean containsAnyOfTopLevelTech(Set<Tech> set, Tech tech) {
        for (Tech tech2 : set) {
            if (!tech.equals(tech2.getParent())) continue;
            return true;
        }
        return false;
    }
}

