/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.scan.BaseScannerThread;
import org.zaproxy.zap.scan.BaseScannerThreadManager;
import org.zaproxy.zap.scan.ScanListener;
import org.zaproxy.zap.utils.ThreadUtils;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.panels.AbstractContextSelectToolbarStatusPanel;

public abstract class AbstractScanToolbarStatusPanel
extends AbstractContextSelectToolbarStatusPanel
implements ScanListener {
    private static final long serialVersionUID = -2351280081989616482L;
    private static final Logger log = Logger.getLogger(AbstractScanToolbarStatusPanel.class);
    protected static final short TOOLBAR_LOCATION_AFTER_BUTTONS = 10;
    protected static final short TOOLBAR_LOCATION_AFTER_PROGRESS_BAR = 11;
    private JButton startScanButton;
    private JButton stopScanButton;
    private ZapToggleButton pauseScanButton;
    private JProgressBar progressBar;
    private Control.Mode mode = Control.getSingleton().getMode();
    private BaseScannerThreadManager<?> threadManager;

    public AbstractScanToolbarStatusPanel(String string, ImageIcon imageIcon, BaseScannerThreadManager<?> baseScannerThreadManager) {
        super(string, imageIcon);
        this.threadManager = baseScannerThreadManager;
    }

    @Override
    protected void setupToolbarElements(JToolBar jToolBar) {
        int n = 0;
        Insets insets = new Insets(0, 4, 0, 2);
        n = this.addToolBarElements(jToolBar, (short)0, n);
        jToolBar.add((Component)new JLabel(Constant.messages.getString(this.panelPrefix + ".toolbar.context.label")), LayoutHelper.getGBC(n++, 0, 1, 0.0, insets));
        jToolBar.add((Component)this.getContextSelectComboBox(), LayoutHelper.getGBC(n++, 0, 1, 0.0, insets));
        n = this.addToolBarElements(jToolBar, (short)1, n);
        jToolBar.add((Component)this.getStartScanButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0, insets));
        jToolBar.add((Component)this.getPauseScanButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0, insets));
        jToolBar.add((Component)this.getStopScanButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0, insets));
        n = this.addToolBarElements(jToolBar, (short)10, n);
        jToolBar.add((Component)this.getProgressBar(), LayoutHelper.getGBC(n++, 0, 1, 1.0, insets));
        n = this.addToolBarElements(jToolBar, (short)11, n);
        jToolBar.add((Component)new JLabel(), LayoutHelper.getGBC(n++, 0, 1, 1.0));
        if (this.hasOptions()) {
            jToolBar.add((Component)this.getOptionsButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0, insets));
        }
        this.addToolBarElements(jToolBar, (short)99, n);
    }

    private JButton getStartScanButton() {
        if (this.startScanButton == null) {
            this.startScanButton = new JButton();
            this.startScanButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.start"));
            this.startScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.startScanButton.setEnabled(false);
            this.startScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractScanToolbarStatusPanel.this.startScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                }
            });
        }
        return this.startScanButton;
    }

    private JButton getStopScanButton() {
        if (this.stopScanButton == null) {
            this.stopScanButton = new JButton();
            this.stopScanButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.stop"));
            this.stopScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/142.png")));
            this.stopScanButton.setEnabled(false);
            this.stopScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractScanToolbarStatusPanel.this.stopScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                }
            });
        }
        return this.stopScanButton;
    }

    private JToggleButton getPauseScanButton() {
        if (this.pauseScanButton == null) {
            this.pauseScanButton = new ZapToggleButton();
            this.pauseScanButton.setToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.pause"));
            this.pauseScanButton.setSelectedToolTipText(Constant.messages.getString(this.panelPrefix + ".toolbar.button.unpause"));
            this.pauseScanButton.setIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setRolloverIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png")));
            this.pauseScanButton.setSelectedIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setRolloverSelectedIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png")));
            this.pauseScanButton.setEnabled(false);
            this.pauseScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractScanToolbarStatusPanel.this.isScanPaused(AbstractScanToolbarStatusPanel.this.getSelectedContext())) {
                        AbstractScanToolbarStatusPanel.this.resumeScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                    } else {
                        AbstractScanToolbarStatusPanel.this.pauseScan(AbstractScanToolbarStatusPanel.this.getSelectedContext());
                    }
                }
            });
        }
        return this.pauseScanButton;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setSize(new Dimension(80, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
        }
        return this.progressBar;
    }

    @Override
    protected void contextSelected(Context context) {
        if (context == null) {
            this.resetScanButtonsAndProgressBarStates(false);
            super.contextSelected(context);
            return;
        }
        if (Control.Mode.safe.equals((Object)this.mode)) {
            super.contextSelected(context);
            return;
        }
        if (Control.Mode.protect.equals((Object)this.mode) && !context.isInScope()) {
            this.resetScanButtonsAndProgressBarStates(false);
            super.contextSelected(context);
            return;
        }
        if (this.isScanStarted(context)) {
            this.getStartScanButton().setEnabled(false);
            this.getStopScanButton().setEnabled(true);
            this.getPauseScanButton().setEnabled(true);
            this.getPauseScanButton().setSelected(this.isScanPaused(context));
            this.getProgressBar().setEnabled(true);
        } else {
            this.resetScanButtonsAndProgressBarStates(true);
        }
        this.getProgressBar().setValue(this.getScanProgress(context));
        this.getProgressBar().setMaximum(this.getScanMaximumProgress(context));
        super.contextSelected(context);
    }

    private void resetScanButtonsAndProgressBarStates(boolean bl) {
        this.setScanButtonsAndProgressBarStates(false, false, bl);
        this.getProgressBar().setValue(0);
    }

    private void setScanButtonsAndProgressBarStates(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.getStartScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(true);
            this.getPauseScanButton().setSelected(bl2);
            this.getStopScanButton().setEnabled(true);
            this.getProgressBar().setEnabled(true);
        } else {
            this.getStartScanButton().setEnabled(bl3);
            this.getStopScanButton().setEnabled(false);
            this.getPauseScanButton().setEnabled(false);
            this.getPauseScanButton().setSelected(false);
            this.getProgressBar().setEnabled(false);
        }
    }

    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        switch (mode) {
            case attack: 
            case standard: 
            case protect: {
                this.getContextSelectComboBox().setEnabled(true);
                if (this.getSelectedContext() == null) break;
                this.contextSelected(this.getSelectedContext());
                break;
            }
            case safe: {
                this.resetScanButtonsAndProgressBarStates(false);
                this.getContextSelectComboBox().setEnabled(false);
            }
        }
    }

    protected void pauseScan(Context context) {
        log.debug((Object)("Access Control pause on Context: " + context));
        ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).pauseScan();
    }

    protected void resumeScan(Context context) {
        log.debug((Object)("Access Control resume on Context: " + context));
        ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).resumeScan();
    }

    protected void stopScan(Context context) {
        log.debug((Object)("Access Control stop on Context: " + context));
        ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).stopScan();
    }

    protected boolean isScanStarted(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).isRunning();
    }

    protected boolean isScanPaused(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).isPaused();
    }

    protected int getScanProgress(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).getScanProgress();
    }

    protected int getScanMaximumProgress(Context context) {
        return ((BaseScannerThread)this.threadManager.getScannerThread(context.getIndex())).getScanMaximumProgress();
    }

    @Override
    public void scanStarted(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                log.debug((Object)("ScanStarted " + AbstractScanToolbarStatusPanel.this.panelPrefix + " on context" + n));
                if (AbstractScanToolbarStatusPanel.this.getSelectedContext() != null && n == AbstractScanToolbarStatusPanel.this.getSelectedContext().getIndex()) {
                    AbstractScanToolbarStatusPanel.this.setScanButtonsAndProgressBarStates(true, false, false);
                    AbstractScanToolbarStatusPanel.this.getProgressBar().setValue(0);
                }
            }
        };
        try {
            ThreadUtils.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            log.error((Object)("Error while starting scan: " + exception.getMessage()), (Throwable)exception);
        }
    }

    @Override
    public void scanFinished(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                log.debug((Object)("ScanFinished " + AbstractScanToolbarStatusPanel.this.panelPrefix + " on context" + n));
                if (AbstractScanToolbarStatusPanel.this.getSelectedContext() != null && n == AbstractScanToolbarStatusPanel.this.getSelectedContext().getIndex()) {
                    AbstractScanToolbarStatusPanel.this.setScanButtonsAndProgressBarStates(false, false, true);
                }
            }
        };
        try {
            ThreadUtils.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            log.error((Object)("Error while finishing scan: " + exception.getMessage()), (Throwable)exception);
        }
    }

    @Override
    public void scanProgress(final int n, final int n2, final int n3) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                log.debug((Object)("scanProgress " + AbstractScanToolbarStatusPanel.this.panelPrefix + " on context " + n + " " + n2));
                if (AbstractScanToolbarStatusPanel.this.getSelectedContext() != null && n == AbstractScanToolbarStatusPanel.this.getSelectedContext().getIndex()) {
                    AbstractScanToolbarStatusPanel.this.getProgressBar().setValue(n2);
                    AbstractScanToolbarStatusPanel.this.getProgressBar().setMaximum(n3);
                }
            }
        };
        try {
            ThreadUtils.invokeAndWait(runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            log.error((Object)("Error while updating progress: " + exception.getMessage()), (Throwable)exception);
        }
    }

    protected abstract void startScan(Context var1);
}

