/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.bmp;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.bmp.BMPDescriptor;
import com.sun.javafx.iio.bmp.BitmapInfoHeader;
import com.sun.javafx.iio.bmp.LEInputStream;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class BMPImageLoader
extends ImageLoaderImpl {
    static final short BM = 19778;
    static final int BFH_SIZE = 14;
    final LEInputStream data;
    short bfType;
    int bfSize;
    int bfOffBits;
    int[] bgra_palette;
    BitmapInfoHeader bih;

    BMPImageLoader(InputStream inputStream) throws IOException {
        super(BMPDescriptor.theInstance);
        this.data = new LEInputStream(inputStream);
        this.bfType = this.data.readShort();
        if (this.isValid()) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        this.bfSize = this.data.readInt();
        this.data.skipBytes(4);
        this.bfOffBits = this.data.readInt();
        this.bih = new BitmapInfoHeader(this.data);
        if (this.bih.biSize + 14 != this.bfOffBits) {
            this.data.skipBytes(this.bfOffBits - this.bih.biSize - 14);
        }
    }

    private boolean isValid() {
        return this.bfType == 19778;
    }

    @Override
    public void dispose() {
    }

    static void GBRtoRGB(byte[] byArray, int n, int n2) {
        for (int i = n2 / 3; i != 0; --i) {
            byte by = byArray[n];
            byte by2 = byArray[n + 2];
            byArray[n + 2] = by;
            byArray[n] = by2;
            n += 3;
        }
    }

    @Override
    public ImageFrame load(int n, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        if (0 != n) {
            return null;
        }
        if (n2 > 0 && n2 != this.bih.biWidth || n3 > 0 && n3 != this.bih.biHeight) {
            throw new RuntimeException("scaling for BMP is not supported");
        }
        ImageMetadata imageMetadata = new ImageMetadata(null, Boolean.TRUE, null, null, null, null, this.bih.biWidth, this.bih.biHeight, null, null, null);
        this.updateImageMetadata(imageMetadata);
        int n4 = this.bih.biBitCount * this.bih.biWidth / 8 + 3 & 0xFFFFFFFC;
        int n5 = this.bih.biBitCount / 8 * this.bih.biWidth;
        int n6 = Math.abs(this.bih.biHeight);
        byte[] byArray = new byte[n5 * n6];
        for (int i = 0; i != n6; ++i) {
            int n7 = this.bih.biHeight < 0 ? i : n6 - i - 1;
            int n8 = this.data.in.read(byArray, n7 * n5, n5);
            BMPImageLoader.GBRtoRGB(byArray, n7 * n5, n8);
            if (n8 != n5) break;
            if (n8 >= n4) continue;
            this.data.skipBytes(n4 - n8);
        }
        return new ImageFrame(ImageStorage.ImageType.RGB, ByteBuffer.wrap(byArray), this.bih.biWidth, n6, n5, null, null);
    }
}

