/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import javafx.geometry.Insets;

public abstract class Border {
    private final double leftWidth;
    private final double topWidth;
    private final double rightWidth;
    private final double bottomWidth;
    private final boolean proportionalWidth;
    private final Insets offsets;

    public double getLeftWidth() {
        return this.leftWidth;
    }

    public double getTopWidth() {
        return this.topWidth;
    }

    public double getRightWidth() {
        return this.rightWidth;
    }

    public double getBottomWidth() {
        return this.bottomWidth;
    }

    public boolean isProportionalWidth() {
        return this.proportionalWidth;
    }

    public Insets getOffsets() {
        return this.offsets;
    }

    protected Border(double d, double d2, double d3, double d4, boolean bl, Insets insets) {
        this.topWidth = d;
        this.rightWidth = d2;
        this.bottomWidth = d3;
        this.leftWidth = d4;
        this.proportionalWidth = bl;
        this.offsets = insets;
    }

    protected static class Builder {
        protected double leftWidth = 1.0;
        protected double topWidth = 1.0;
        protected double rightWidth = 1.0;
        protected double bottomWidth = 1.0;
        protected boolean proportionalWidth = false;
        protected Insets offsets = Insets.EMPTY;

        protected Builder() {
        }

        public Builder setLeftWidth(double d) {
            this.leftWidth = d;
            return this;
        }

        public Builder setTopWidth(double d) {
            this.topWidth = d;
            return this;
        }

        public Builder setRightWidth(double d) {
            this.rightWidth = d;
            return this;
        }

        public Builder setBottomWidth(double d) {
            this.bottomWidth = d;
            return this;
        }

        public Builder setProportionalWidth(boolean bl) {
            this.proportionalWidth = bl;
            return this;
        }

        public Builder setOffsets(Insets insets) {
            this.offsets = insets;
            return this;
        }
    }
}

