/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import java.io.File;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";
    private static String libSuffixAlt = null;

    public static synchronized void loadLibrary(String libname) {
        if (!loaded.contains(libname)) {
            NativeLibLoader.loadLibraryInternal(libname);
            loaded.add(libname);
        }
    }

    private static String[] initializePath(String propname) {
        String ldpath = System.getProperty(propname, "");
        String ps = File.pathSeparator;
        int ldlen = ldpath.length();
        int i = ldpath.indexOf(ps);
        int n = 0;
        while (i >= 0) {
            ++n;
            i = ldpath.indexOf(ps, i + 1);
        }
        String[] paths = new String[n + 1];
        i = 0;
        n = 0;
        int j = ldpath.indexOf(ps);
        while (j >= 0) {
            if (j - i > 0) {
                paths[n++] = ldpath.substring(i, j);
            } else if (j - i == 0) {
                paths[n++] = ".";
            }
            i = j + 1;
            j = ldpath.indexOf(ps, i);
        }
        paths[n] = ldpath.substring(i, ldlen);
        return paths;
    }

    private static void loadLibraryInternal(String libraryName) {
        try {
            NativeLibLoader.loadLibraryFullPath(libraryName);
        }
        catch (UnsatisfiedLinkError ex) {
            String[] libPath = NativeLibLoader.initializePath("java.library.path");
            for (int i = 0; i < libPath.length; ++i) {
                try {
                    String path = libPath[i];
                    if (!path.endsWith(File.separator)) {
                        path = path + File.separator;
                    }
                    String fileName = System.mapLibraryName(libraryName);
                    File libFile = new File(path + fileName);
                    System.load(libFile.getAbsolutePath());
                    if (verbose) {
                        System.err.println("WARNING: " + ex.toString());
                        System.err.println("    using System.loadLibrary(" + libraryName + ") as a fallback");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError ex3) {
                    continue;
                }
            }
            try {
                System.loadLibrary(libraryName);
                if (verbose) {
                    System.err.println("WARNING: " + ex.toString());
                    System.err.println("    using System.loadLibrary(" + libraryName + ") as a fallback");
                }
            }
            catch (UnsatisfiedLinkError ex2) {
                throw ex;
            }
        }
    }

    private static void loadLibraryFullPath(String libraryName) {
        block20: {
            try {
                if (libDir == null) {
                    Class<NativeLibLoader> theClass = NativeLibLoader.class;
                    String theClassFile = "NativeLibLoader.class";
                    String classUrlString = theClass.getResource(theClassFile).toString();
                    if (!classUrlString.startsWith("jar:file:") || classUrlString.indexOf(33) == -1) {
                        throw new UnsatisfiedLinkError("Invalid URL for class: " + classUrlString);
                    }
                    String tmpStr = classUrlString.substring(4, classUrlString.lastIndexOf(33));
                    int lastIndexOfSlash = Math.max(tmpStr.lastIndexOf(47), tmpStr.lastIndexOf(92));
                    String osName = System.getProperty("os.name");
                    boolean is64bit = System.getProperty("sun.arch.data.model", "").startsWith("64");
                    String relativeDir = null;
                    if (osName.startsWith("Windows")) {
                        relativeDir = "../bin";
                    } else if (osName.startsWith("Mac")) {
                        relativeDir = ".";
                    } else if (osName.startsWith("Linux")) {
                        relativeDir = is64bit ? "amd64" : "i386";
                    }
                    String libDirUrlString = tmpStr.substring(0, lastIndexOfSlash) + "/" + relativeDir;
                    libDir = new File(new URI(libDirUrlString).getPath());
                    if (osName.startsWith("Windows")) {
                        File libDir64;
                        if (is64bit && (libDir64 = new File(libDir, "64bit")).isDirectory()) {
                            libDir = libDir64;
                        }
                        libPrefix = "";
                        libSuffix = ".dll";
                    } else if (osName.startsWith("Mac")) {
                        libPrefix = "lib";
                        libSuffix = ".dylib";
                        libSuffixAlt = ".jnilib";
                    } else if (osName.startsWith("Linux")) {
                        libPrefix = "lib";
                        libSuffix = ".so";
                    }
                }
                File libFile = new File(libDir, libPrefix + libraryName + libSuffix);
                String libFileName = libFile.getCanonicalPath();
                try {
                    System.load(libFileName);
                }
                catch (UnsatisfiedLinkError ex) {
                    if (libSuffixAlt != null) {
                        try {
                            libFile = new File(libDir, libPrefix + libraryName + libSuffixAlt);
                            libFileName = libFile.getAbsolutePath();
                            System.load(libFileName);
                            break block20;
                        }
                        catch (UnsatisfiedLinkError ex2) {
                            throw ex;
                        }
                    }
                    throw ex;
                }
            }
            catch (Exception e) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                verbose = Boolean.getBoolean("javafx.verbose");
                return null;
            }
        });
    }
}

