/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

class UAStylesheetLoader {
    private static boolean stylesheetLoaded = false;

    private UAStylesheetLoader() {
    }

    static void doLoad() {
        Holder.stylesheetLoader.loadUAStylesheet();
    }

    private void loadUAStylesheet() {
        if (!stylesheetLoaded) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = SkinBase.class.getResource("caspian/caspian.css");
                    StyleManager.getInstance().setDefaultUserAgentStylesheet(uRL.toExternalForm());
                    if (PlatformUtil.isEmbedded()) {
                        uRL = SkinBase.class.getResource("caspian/embedded.css");
                        StyleManager.getInstance().addUserAgentStylesheet(uRL.toExternalForm());
                        if (Utils.isQVGAScreen()) {
                            uRL = SkinBase.class.getResource("caspian/embedded-qvga.css");
                            StyleManager.getInstance().addUserAgentStylesheet(uRL.toExternalForm());
                        }
                    }
                    stylesheetLoaded = true;
                    return null;
                }
            });
        }
    }

    private static class Holder {
        private static UAStylesheetLoader stylesheetLoader = new UAStylesheetLoader();

        private Holder() {
        }
    }
}

