/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.EdmondsKarpMaximumFlow;

public class MinSourceSinkCut<V, E> {
    EdmondsKarpMaximumFlow<V, E> ekMaxFlow;
    Set<V> minCut = null;
    DirectedGraph<V, E> graph;
    double cutWeight;
    V source = null;
    V sink = null;
    double epsilon = 1.0E-9;

    public MinSourceSinkCut(DirectedGraph<V, E> graph) {
        this.ekMaxFlow = new EdmondsKarpMaximumFlow<V, E>(graph);
        this.graph = graph;
    }

    public MinSourceSinkCut(DirectedGraph<V, E> graph, double epsilon) {
        this.ekMaxFlow = new EdmondsKarpMaximumFlow<V, E>(graph);
        this.graph = graph;
        this.epsilon = epsilon;
    }

    public void computeMinCut(V source, V sink) {
        this.source = source;
        this.sink = sink;
        this.minCut = new HashSet<V>();
        this.ekMaxFlow.calculateMaximumFlow(source, sink);
        this.cutWeight = this.ekMaxFlow.getMaximumFlowValue();
        Map<E, Double> maxFlow = this.ekMaxFlow.getMaximumFlow();
        LinkedList<V> processQueue = new LinkedList<V>();
        processQueue.add(source);
        while (!processQueue.isEmpty()) {
            Object vertex = processQueue.remove();
            if (this.minCut.contains(vertex)) continue;
            this.minCut.add(vertex);
            HashSet<E> outEdges = new HashSet<E>(this.graph.outgoingEdgesOf(vertex));
            Iterator it = outEdges.iterator();
            while (it.hasNext()) {
                double flowValue;
                Object edge = it.next();
                double edgeCapacity = this.graph.getEdgeWeight(edge);
                if (!(Math.abs(edgeCapacity - (flowValue = maxFlow.get(edge).doubleValue())) <= this.epsilon)) continue;
                it.remove();
            }
            for (Object edge : outEdges) {
                processQueue.add(Graphs.getOppositeVertex(this.graph, edge, vertex));
            }
            HashSet<E> inEdges = new HashSet<E>(this.graph.incomingEdgesOf(vertex));
            Iterator it2 = inEdges.iterator();
            while (it2.hasNext()) {
                Object edge = it2.next();
                double flowValue = maxFlow.get(edge);
                if (!(flowValue <= this.epsilon)) continue;
                it2.remove();
            }
            for (Object edge : inEdges) {
                processQueue.add(Graphs.getOppositeVertex(this.graph, edge, vertex));
            }
        }
    }

    public Set<V> getSourcePartition() {
        return Collections.unmodifiableSet(this.minCut);
    }

    public Set<V> getSinkPartition() {
        if (this.minCut == null) {
            return null;
        }
        HashSet set = new HashSet(this.graph.vertexSet());
        set.removeAll(this.minCut);
        return Collections.unmodifiableSet(set);
    }

    public double getCutWeight() {
        return this.cutWeight;
    }

    public Set<E> getCutEdges() {
        if (this.minCut == null) {
            return null;
        }
        HashSet<E> cutEdges = new HashSet<E>();
        for (V vertex : this.minCut) {
            for (E edge : this.graph.outgoingEdgesOf(vertex)) {
                if (this.minCut.contains(Graphs.getOppositeVertex(this.graph, edge, vertex))) continue;
                cutEdges.add(edge);
            }
        }
        return Collections.unmodifiableSet(cutEdges);
    }

    public V getCurrentSource() {
        return this.source;
    }

    public V getCurrentSink() {
        return this.sink;
    }
}

