/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;

public abstract class AbstractNameValueComment {
    private String name;
    private String value;
    private String comment;

    public AbstractNameValueComment(String name, String value, String comment) {
        this.name = name;
        this.value = value;
        this.comment = comment;
    }

    public AbstractNameValueComment(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public AbstractNameValueComment(JsonParser jp) throws JsonParseException, IOException {
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeStringField("name", this.name);
        g.writeStringField("value", this.value);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        g.writeEndObject();
    }

    public void writeJDBC(HarDatabaseConfig config, long id, PreparedStatement ps, long logId) throws SQLException {
        ps.setString(1, this.name);
        ps.setString(2, this.value);
        if (this.comment == null) {
            ps.setNull(3, -1);
        } else {
            ps.setString(3, this.comment);
        }
        ps.setLong(4, id);
        ps.executeUpdate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return "{ \"name\": \"" + this.name + "\", \"value\": \"" + this.value + "\", \"comment\": \"" + this.comment + "\" }";
    }
}

