/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.XRenderPictureAttributes;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        long l = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        this.init(drawable, gCData, l);
        this.init();
    }

    static void addCairoString(long l, String string, float f, float f2, Font font) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l2 = OS.pango_cairo_create_layout(l);
        if (l2 == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_text(l2, byArray, -1);
        OS.pango_layout_set_font_description(l2, font.handle);
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Cairo.cairo_get_current_point(l, dArray, dArray2);
        if (dArray[0] != (double)f || dArray2[0] != (double)f2) {
            Cairo.cairo_move_to(l, f, f2);
        }
        OS.pango_cairo_layout_path(l, l2);
        OS.g_object_unref(l2);
    }

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    public static GC gtk_new(long l, GCData gCData) {
        GC gC = new GC();
        gC.device = gCData.device;
        gC.init(null, gCData, l);
        return gC;
    }

    public static GC gtk_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        long l = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, l);
        return gC;
    }

    void checkGC(int n) {
        Object object;
        int n2 = this.data.state;
        if ((n2 & n) == n) {
            return;
        }
        n2 = (n2 ^ n) & n;
        this.data.state |= n;
        long l = this.data.cairo;
        if (l != 0L) {
            Object object2;
            Object object3;
            if ((n2 & 3) != 0) {
                if ((n2 & 1) != 0) {
                    object3 = this.data.foreground;
                    object2 = this.data.foregroundPattern;
                    this.data.state &= 0xFFFFFFFD;
                } else {
                    object3 = this.data.background;
                    object2 = this.data.backgroundPattern;
                    this.data.state &= 0xFFFFFFFE;
                }
                if (object2 != null) {
                    if ((this.data.style & 0x8000000) != 0 && ((Pattern)object2).surface != 0L) {
                        long l2 = Cairo.cairo_pattern_create_for_surface(((Pattern)object2).surface);
                        if (l2 == 0L) {
                            SWT.error(2);
                        }
                        Cairo.cairo_pattern_set_extend(l2, 1);
                        double[] dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                        Cairo.cairo_pattern_set_matrix(l2, dArray);
                        Cairo.cairo_set_source(l, l2);
                        Cairo.cairo_pattern_destroy(l2);
                    } else {
                        Cairo.cairo_set_source(l, ((Pattern)object2).handle);
                    }
                } else {
                    Cairo.cairo_set_source_rgba(l, (float)(((GdkColor)object3).red & 0xFFFF) / 65535.0f, (float)(((GdkColor)object3).green & 0xFFFF) / 65535.0f, (float)(((GdkColor)object3).blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
                }
            }
            if ((n2 & 4) != 0 && this.data.layout != 0L) {
                object3 = this.data.font;
                OS.pango_layout_set_font_description(this.data.layout, ((Font)object3).handle);
            }
            if ((n2 & 0x10) != 0) {
                int n3 = 0;
                switch (this.data.lineCap) {
                    case 2: {
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        n3 = 0;
                        break;
                    }
                    case 3: {
                        n3 = 2;
                    }
                }
                Cairo.cairo_set_line_cap(l, n3);
            }
            if ((n2 & 0x20) != 0) {
                int n4 = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    case 3: {
                        n4 = 2;
                    }
                }
                Cairo.cairo_set_line_join(l, n4);
            }
            if ((n2 & 0x40) != 0) {
                Cairo.cairo_set_line_width(l, this.data.lineWidth == 0.0f ? 1.0 : (double)this.data.lineWidth);
                switch (this.data.lineStyle) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 |= 8;
                    }
                }
            }
            if ((n2 & 8) != 0) {
                float f = 0.0f;
                object2 = null;
                float f2 = this.data.lineWidth;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        object2 = f2 != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                        break;
                    }
                    case 3: {
                        object2 = f2 != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                        break;
                    }
                    case 4: {
                        object2 = f2 != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        object2 = f2 != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        object2 = this.data.lineDashes;
                    }
                }
                if (object2 != null) {
                    f = this.data.lineDashesOffset;
                    double[] dArray = new double[((Object)object2).length];
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = f2 == 0.0f || this.data.lineStyle == 6 ? (double)object2[i] : (double)(object2[i] * f2);
                    }
                    Cairo.cairo_set_dash(l, dArray, dArray.length, f);
                } else {
                    Cairo.cairo_set_dash(l, null, 0, 0.0);
                }
            }
            if ((n2 & 0x80) != 0) {
                Cairo.cairo_set_miter_limit(l, this.data.lineMiterLimit);
            }
            if ((n2 & 0x200) != 0) {
                double d;
                this.data.cairoYoffset = 0.0;
                this.data.cairoXoffset = 0.0;
                double[] dArray = new double[6];
                Cairo.cairo_get_matrix(l, dArray);
                object2 = new double[]{1.0};
                double[] dArray2 = new double[]{1.0};
                Cairo.cairo_user_to_device_distance(l, (double[])object2, dArray2);
                Object object4 = object2[0];
                if (object4 < 0.0) {
                    object4 = -object4;
                }
                if ((d = (double)this.data.lineWidth * object4) == 0.0 || (int)d % 2 == 1) {
                    this.data.cairoXoffset = 0.5 / object4;
                }
                if ((object4 = (Object)dArray2[0]) < 0.0) {
                    object4 = -object4;
                }
                if ((d = (double)this.data.lineWidth * object4) == 0.0 || (int)d % 2 == 1) {
                    this.data.cairoYoffset = 0.5 / object4;
                }
            }
            return;
        }
        if ((n2 & 3) != 0) {
            if ((n2 & 1) != 0) {
                object = this.data.foreground;
                this.data.state &= 0xFFFFFFFD;
            } else {
                object = this.data.background;
                this.data.state &= 0xFFFFFFFE;
            }
            OS.gdk_gc_set_foreground(this.handle, (GdkColor)object);
        }
        if ((n2 & 0x100) != 0) {
            object = this.data.background;
            OS.gdk_gc_set_background(this.handle, (GdkColor)object);
        }
        if ((n2 & 4) != 0 && this.data.layout != 0L) {
            object = this.data.font;
            OS.pango_layout_set_font_description(this.data.layout, ((Font)object).handle);
        }
        if ((n2 & 0x78) != 0) {
            int n5 = 0;
            int n6 = 0;
            int n7 = (int)this.data.lineWidth;
            int n8 = 0;
            float[] fArray = null;
            switch (this.data.lineCap) {
                case 2: {
                    n5 = 2;
                    break;
                }
                case 1: {
                    n5 = 1;
                    break;
                }
                case 3: {
                    n5 = 3;
                }
            }
            switch (this.data.lineJoin) {
                case 2: {
                    n6 = 1;
                    break;
                }
                case 1: {
                    n6 = 0;
                    break;
                }
                case 3: {
                    n6 = 2;
                }
            }
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    fArray = n7 != 0 ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    fArray = n7 != 0 ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    fArray = n7 != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    fArray = n7 != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    fArray = this.data.lineDashes;
                }
            }
            if (fArray != null) {
                if ((n2 & 8) != 0) {
                    byte[] byArray = new byte[fArray.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)(n7 == 0 || this.data.lineStyle == 6 ? fArray[i] : fArray[i] * (float)n7);
                    }
                    OS.gdk_gc_set_dashes(this.handle, 0, byArray, byArray.length);
                }
                n8 = 1;
            } else {
                n8 = 0;
            }
            OS.gdk_gc_set_line_attributes(this.handle, n7, n8, n5, n6);
        }
    }

    long convertRgn(long l, double[] dArray) {
        long l2 = OS.gdk_region_new();
        if (this.isIdentity(dArray)) {
            OS.gdk_region_union(l2, l);
            return l2;
        }
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        Region.gdk_region_get_rectangles(l, lArray, nArray);
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray2 = new int[8];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        for (int i = 0; i < nArray[0]; ++i) {
            OS.memmove(gdkRectangle, lArray[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            dArray2[0] = gdkRectangle.x;
            dArray3[0] = gdkRectangle.y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[0] = (int)dArray2[0];
            nArray2[1] = (int)dArray3[0];
            dArray2[0] = gdkRectangle.x + gdkRectangle.width;
            dArray3[0] = gdkRectangle.y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[2] = (int)Math.round(dArray2[0]);
            nArray2[3] = (int)dArray3[0];
            dArray2[0] = gdkRectangle.x + gdkRectangle.width;
            dArray3[0] = gdkRectangle.y + gdkRectangle.height;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[4] = (int)Math.round(dArray2[0]);
            nArray2[5] = (int)Math.round(dArray3[0]);
            dArray2[0] = gdkRectangle.x;
            dArray3[0] = gdkRectangle.y + gdkRectangle.height;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[6] = (int)dArray2[0];
            nArray2[7] = (int)Math.round(dArray3[0]);
            long l3 = Region.gdk_region_polygon(nArray2, nArray2.length / 2, 0);
            OS.gdk_region_union(l2, l3);
            OS.gdk_region_destroy(l3);
        }
        if (lArray[0] != 0L) {
            OS.g_free(lArray[0]);
        }
        return l2;
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (OS.USE_CAIRO) {
            long l = Cairo.cairo_create(image.surface);
            if (l == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_translate(l, -n, -n2);
            Cairo.cairo_push_group(l);
            if (this.data.image != null) {
                Cairo.cairo_set_source_surface(l, this.data.image.surface, 0.0, 0.0);
            } else if (this.data.drawable != 0L) {
                if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                    OS.gdk_cairo_set_source_window(l, this.data.drawable, 0, 0);
                } else {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gdk_drawable_get_size(this.data.drawable, nArray, nArray2);
                    int n3 = nArray[0];
                    int n4 = nArray2[0];
                    long l2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                    long l3 = OS.gdk_x11_drawable_get_xid(this.data.drawable);
                    long l4 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
                    long l5 = Cairo.cairo_xlib_surface_create(l2, l3, l4, n3, n4);
                    Cairo.cairo_set_source_surface(l, l5, 0.0, 0.0);
                }
            } else {
                Cairo.cairo_destroy(l);
                return;
            }
            Cairo.cairo_set_operator(l, 1);
            Cairo.cairo_paint(l);
            Cairo.cairo_pop_group_to_source(l);
            Cairo.cairo_paint(l);
            Cairo.cairo_destroy(l);
            return;
        }
        Rectangle rectangle = image.getBounds();
        long l = OS.gdk_gc_new(image.pixmap);
        if (l == 0L) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow(l, 1L);
        OS.gdk_draw_drawable(image.pixmap, l, this.data.drawable, n, n2, 0, 0, rectangle.width, rectangle.height);
        OS.g_object_unref(l);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea(n, n2, n3, n4, n5, n6, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        long l = this.data.drawable;
        if (OS.USE_CAIRO) {
            if (this.data.image != null) {
                Cairo.cairo_set_source_surface(this.handle, this.data.image.surface, n7, n8);
                Cairo.cairo_rectangle(this.handle, n5, n6, n3, n4);
                Cairo.cairo_set_operator(this.handle, 1);
                Cairo.cairo_fill(this.handle);
            } else if (l != 0L) {
                Cairo.cairo_save(this.handle);
                Cairo.cairo_rectangle(this.handle, n5, n6, n3, n4);
                Cairo.cairo_clip(this.handle);
                Cairo.cairo_translate(this.handle, n7, n8);
                Cairo.cairo_set_operator(this.handle, 1);
                Cairo.cairo_push_group(this.handle);
                OS.gdk_cairo_set_source_window(this.handle, l, 0, 0);
                Cairo.cairo_paint(this.handle);
                Cairo.cairo_pop_group_to_source(this.handle);
                Cairo.cairo_rectangle(this.handle, n5 - n7, n6 - n8, n3, n4);
                Cairo.cairo_clip(this.handle);
                Cairo.cairo_paint(this.handle);
                Cairo.cairo_restore(this.handle);
                if (bl) {
                    long l2 = OS.GTK3 ? OS.gdk_window_get_visible_region(l) : OS.gdk_drawable_get_visible_region(l);
                    GdkRectangle gdkRectangle = new GdkRectangle();
                    gdkRectangle.x = n;
                    gdkRectangle.y = n2;
                    gdkRectangle.width = n3;
                    gdkRectangle.height = n4;
                    long l3 = OS.gdk_region_rectangle(gdkRectangle);
                    OS.gdk_region_intersect(l3, l2);
                    long l4 = OS.gdk_region_rectangle(gdkRectangle);
                    OS.gdk_region_subtract(l4, l2);
                    OS.gdk_region_offset(l4, n7, n8);
                    OS.gdk_window_invalidate_region(l, l4, false);
                    OS.gdk_region_destroy(l2);
                    OS.gdk_region_destroy(l3);
                    OS.gdk_region_destroy(l4);
                }
            }
        } else {
            if (this.data.image == null && bl) {
                OS.gdk_gc_set_exposures(this.handle, true);
            }
            OS.gdk_draw_drawable(l, this.handle, l, n, n2, n5, n6, n3, n4);
        }
        if (this.data.image == null & bl) {
            if (!OS.USE_CAIRO) {
                OS.gdk_gc_set_exposures(this.handle, false);
            }
            boolean bl2 = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6;
            GdkRectangle gdkRectangle = new GdkRectangle();
            if (bl2) {
                gdkRectangle.x = n;
                gdkRectangle.y = n2;
                gdkRectangle.width = Math.max(0, n3);
                gdkRectangle.height = Math.max(0, n4);
                OS.gdk_window_invalidate_rect(l, gdkRectangle, false);
            } else {
                if (n7 != 0) {
                    int n9 = n5 - n7;
                    if (n7 < 0) {
                        n9 = n5 + n3;
                    }
                    gdkRectangle.x = n9;
                    gdkRectangle.y = n2;
                    gdkRectangle.width = Math.abs(n7);
                    gdkRectangle.height = Math.max(0, n4);
                    OS.gdk_window_invalidate_rect(l, gdkRectangle, false);
                }
                if (n8 != 0) {
                    int n10 = n6 - n8;
                    if (n8 < 0) {
                        n10 = n6 + n4;
                    }
                    gdkRectangle.x = n;
                    gdkRectangle.y = n10;
                    gdkRectangle.width = Math.max(0, n3);
                    gdkRectangle.height = Math.abs(n8);
                    OS.gdk_window_invalidate_rect(l, gdkRectangle, false);
                }
            }
        }
    }

    void createLayout() {
        long l = OS.gdk_pango_context_get();
        if (l == 0L) {
            SWT.error(2);
        }
        this.data.context = l;
        long l2 = OS.pango_layout_new(l);
        if (l2 == 0L) {
            SWT.error(2);
        }
        this.data.layout = l2;
        OS.pango_context_set_language(l, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(l, (this.data.style & 0x8000000) != 0 ? 1 : 0);
        OS.pango_layout_set_auto_dir(l2, false);
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0L) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0L) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0L;
        this.data.layout = 0L;
    }

    @Override
    void destroy() {
        Image image;
        long l;
        if (this.data.disposeCairo && (l = this.data.cairo) != 0L) {
            Cairo.cairo_destroy(l);
        }
        this.data.cairo = 0L;
        l = this.data.clipRgn;
        if (l != 0L) {
            OS.gdk_region_destroy(l);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.clipRgn = 0L;
        this.data.drawable = 0L;
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        long l = this.data.cairo;
        if (l != 0L) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n3 == n4) {
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
            } else {
                Cairo.cairo_save(l);
                Cairo.cairo_translate(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
                Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_stroke(l);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, n, n2, n3, n4, n5 * 64, n6 * 64);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((l = this.data.cairo) != 0L) {
            this.checkGC(1);
            if (OS.GTK3) {
                long l2 = OS.gtk_widget_get_style_context(this.data.device.shellHandle);
                OS.gtk_render_focus(l2, l, n, n2, n3, n4);
            } else {
                double d;
                int[] nArray = new int[1];
                OS.gtk_widget_style_get(this.data.device.shellHandle, OS.focus_line_width, nArray, 0L);
                Cairo.cairo_save(l);
                Cairo.cairo_set_line_width(l, nArray[0]);
                double[] dArray = new double[]{1.0, 1.0};
                for (d = (double)((float)(-nArray[0]) / 2.0f); d < 0.0; d += 2.0) {
                }
                Cairo.cairo_set_dash(l, dArray, dArray.length, d);
                Cairo.cairo_rectangle(l, (float)n + (float)nArray[0] / 2.0f, (float)n2 + (float)nArray[0] / 2.0f, n3, n4);
                Cairo.cairo_stroke(l);
                Cairo.cairo_restore(l);
            }
            return;
        }
        long l3 = OS.gtk_widget_get_style(this.data.device.shellHandle);
        OS.gtk_paint_focus(l3, this.data.drawable, 0, null, this.data.device.shellHandle, new byte[1], n, n2, n3, n4);
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        image.refreshImageForZoom();
        if (OS.USE_CAIRO) {
            n10 = image.width;
            n9 = image.height;
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                OS.gdk_pixmap_get_size(image.pixmap, nArray, nArray2);
            } else {
                OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
            }
            n10 = nArray[0];
            n9 = nArray2[0];
        }
        if (bl) {
            n3 = n7 = n10;
            n4 = n8 = n9;
        } else {
            boolean bl2 = bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n10 && n4 == n8 && n8 == n9;
            if (n + n3 > n10 || n2 + n4 > n9) {
                SWT.error(5);
            }
        }
        long l = this.data.cairo;
        if (l != 0L) {
            if (this.data.alpha != 0) {
                image.createSurface();
                Cairo.cairo_save(l);
                if ((this.data.style & 0x8000000) != 0) {
                    Cairo.cairo_scale(l, -1.0, 1.0);
                    Cairo.cairo_translate(l, -2 * n5 - n7, 0.0);
                }
                Cairo.cairo_rectangle(l, n5, n6, n7, n8);
                Cairo.cairo_clip(l);
                if (n3 != n7 || n4 != n8) {
                    float f = (float)n7 / (float)n3;
                    float f2 = (float)n8 / (float)n4;
                    Cairo.cairo_translate(l, n5 - (int)((float)n * f), n6 - (int)((float)n2 * f2));
                    Cairo.cairo_scale(l, f, f2);
                } else {
                    Cairo.cairo_translate(l, n5 - n, n6 - n2);
                }
                int n11 = 1;
                switch (this.data.interpolation) {
                    case -1: {
                        n11 = 1;
                        break;
                    }
                    case 0: {
                        n11 = 3;
                        break;
                    }
                    case 1: {
                        n11 = 0;
                        break;
                    }
                    case 2: {
                        n11 = 2;
                    }
                }
                long l2 = Cairo.cairo_pattern_create_for_surface(image.surface);
                if (l2 == 0L) {
                    SWT.error(2);
                }
                if (n3 != n7 || n4 != n8) {
                    int n12 = Cairo.cairo_version();
                    if (n12 >= Cairo.CAIRO_VERSION_ENCODE(1, 4, 0) && n12 < Cairo.CAIRO_VERSION_ENCODE(1, 8, 0)) {
                        long l3 = Cairo.cairo_image_surface_create(0, n10 * 3, n9 * 3);
                        long l4 = Cairo.cairo_create(l3);
                        Cairo.cairo_set_source_surface(l4, image.surface, n10, n9);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_scale(l4, -1.0, -1.0);
                        Cairo.cairo_set_source_surface(l4, image.surface, -n10, -n9);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_set_source_surface(l4, image.surface, -n10 * 3, -n9);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_set_source_surface(l4, image.surface, -n10, -n9 * 3);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_set_source_surface(l4, image.surface, -n10 * 3, -n9 * 3);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_scale(l4, 1.0, -1.0);
                        Cairo.cairo_set_source_surface(l4, image.surface, -n10, n9);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_set_source_surface(l4, image.surface, -n10 * 3, n9);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_scale(l4, -1.0, -1.0);
                        Cairo.cairo_set_source_surface(l4, image.surface, n10, -n9);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_set_source_surface(l4, image.surface, n10, -n9 * 3);
                        Cairo.cairo_paint(l4);
                        Cairo.cairo_destroy(l4);
                        long l5 = Cairo.cairo_pattern_create_for_surface(l3);
                        Cairo.cairo_surface_destroy(l3);
                        if (l5 == 0L) {
                            SWT.error(2);
                        }
                        Cairo.cairo_pattern_destroy(l2);
                        l2 = l5;
                        Cairo.cairo_pattern_set_extend(l2, 3);
                        double[] dArray = new double[6];
                        Cairo.cairo_matrix_init_translate(dArray, n10, n9);
                        Cairo.cairo_pattern_set_matrix(l2, dArray);
                    } else if (n12 >= Cairo.CAIRO_VERSION_ENCODE(1, 8, 0)) {
                        Cairo.cairo_pattern_set_extend(l2, 3);
                    }
                }
                Cairo.cairo_pattern_set_filter(l2, n11);
                Cairo.cairo_set_source(l, l2);
                if (this.data.alpha != 255) {
                    Cairo.cairo_paint_with_alpha(l, (float)this.data.alpha / 255.0f);
                } else {
                    Cairo.cairo_paint(l);
                }
                Cairo.cairo_restore(l);
                Cairo.cairo_pattern_destroy(l2);
            }
            return;
        }
        if (image.alpha != -1 || image.alphaData != null) {
            this.drawImageAlpha(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n10, n9);
        } else if (image.transparentPixel != -1 || image.mask != 0L) {
            this.drawImageMask(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n10, n9);
        } else {
            this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n10, n9);
        }
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        image.refreshImageForZoom();
        if (n3 == n7 && n4 == n8) {
            OS.gdk_draw_drawable(this.data.drawable, this.handle, image.pixmap, n, n2, n5, n6, n7, n8);
        } else {
            if (this.device.useXRender) {
                this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, 0L, -1);
                return;
            }
            long l = this.scale(image.pixmap, n, n2, n3, n4, n7, n8);
            if (l != 0L) {
                OS.gdk_pixbuf_render_to_drawable(l, this.data.drawable, this.handle, 0, 0, n5, n6, n7, n8, 1, 0, 0);
                OS.g_object_unref(l);
            }
        }
    }

    void drawImageAlpha(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        if (image.alpha == 0) {
            return;
        }
        if (image.alpha == 255) {
            this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, image.mask, 2);
            return;
        }
        long l = OS.gdk_pixbuf_new(0, true, 8, n3, n4);
        if (l == 0L) {
            return;
        }
        long l2 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(l, image.pixmap, l2, n, n2, 0, 0, n3, n4);
        int n11 = OS.gdk_pixbuf_get_rowstride(l);
        long l3 = OS.gdk_pixbuf_get_pixels(l);
        byte[] byArray = new byte[n11];
        byte by = (byte)image.alpha;
        byte[] byArray2 = image.alphaData;
        for (int i = 0; i < n4; ++i) {
            int n12 = (i + n2) * n9 + n;
            OS.memmove(byArray, l3 + (long)(i * n11), (long)n11);
            for (int j = 3; j < n11; j += 4) {
                byArray[j] = byArray2 == null ? by : byArray2[n12++];
            }
            OS.memmove(l3 + (long)(i * n11), byArray, (long)n11);
        }
        if (n3 != n7 || n4 != n8) {
            long l4 = OS.gdk_pixbuf_scale_simple(l, n7, n8, 2);
            OS.g_object_unref(l);
            if (l4 == 0L) {
                return;
            }
            l = l4;
        }
        OS.gdk_draw_pixbuf(this.data.drawable, this.handle, l, 0, 0, n5, n6, n7, n8, 1, 0, 0);
        OS.g_object_unref(l);
    }

    void drawImageMask(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        long l = this.data.drawable;
        long l2 = image.pixmap;
        if (image.transparentPixel != -1) {
            image.createMask();
        }
        long l3 = image.mask;
        if (this.device.useXRender) {
            this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, l3, 4);
        } else {
            int n11;
            int n12;
            int n13;
            byte[] byArray;
            long l4;
            if (n3 != n7 || n4 != n8) {
                long l5 = OS.gdk_pixbuf_new(0, true, 8, n3, n4);
                if (l5 != 0L) {
                    long l6 = OS.gdk_colormap_get_system();
                    OS.gdk_pixbuf_get_from_drawable(l5, l2, l6, n, n2, 0, 0, n3, n4);
                    l4 = OS.gdk_pixbuf_new(0, false, 8, n3, n4);
                    if (l4 != 0L) {
                        OS.gdk_pixbuf_get_from_drawable(l4, l3, 0L, n, n2, 0, 0, n3, n4);
                        int n14 = OS.gdk_pixbuf_get_rowstride(l5);
                        long l7 = OS.gdk_pixbuf_get_pixels(l5);
                        byte[] byArray2 = new byte[n14];
                        int n15 = OS.gdk_pixbuf_get_rowstride(l4);
                        long l8 = OS.gdk_pixbuf_get_pixels(l4);
                        byte[] byArray3 = new byte[n15];
                        for (int i = 0; i < n4; ++i) {
                            long l9 = l7 + (long)(i * n14);
                            OS.memmove(byArray2, l9, (long)n14);
                            long l10 = l8 + (long)(i * n15);
                            OS.memmove(byArray3, l10, (long)n15);
                            for (int j = 0; j < n3; ++j) {
                                if (byArray3[j * 3] != 0) continue;
                                byArray2[j * 4 + 3] = 0;
                            }
                            OS.memmove(l9, byArray2, (long)n14);
                        }
                        OS.g_object_unref(l4);
                        long l11 = OS.gdk_pixbuf_scale_simple(l5, n7, n8, 2);
                        if (l11 != 0L) {
                            long[] lArray = new long[1];
                            long[] lArray2 = new long[1];
                            OS.gdk_pixbuf_render_pixmap_and_mask(l11, lArray, lArray2, 128);
                            l2 = lArray[0];
                            l3 = lArray2[0];
                            OS.g_object_unref(l11);
                        }
                    }
                    OS.g_object_unref(l5);
                }
                n = 0;
                n2 = 0;
                n3 = n7;
                n4 = n8;
            }
            if (this.data.clipRgn != 0L && (l4 = OS.gdk_bitmap_create_from_data(0L, byArray = new byte[(n13 = ((n12 = n + n3) + 7) / 8) * (n11 = n2 + n4)], n12, n11)) != 0L) {
                long l12 = OS.gdk_gc_new(l4);
                OS.gdk_region_offset(this.data.clipRgn, -n5 + n, -n6 + n2);
                OS.gdk_gc_set_clip_region(l12, this.data.clipRgn);
                OS.gdk_region_offset(this.data.clipRgn, n5 - n, n6 - n2);
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = 1;
                OS.gdk_gc_set_foreground(l12, gdkColor);
                OS.gdk_draw_rectangle(l4, l12, 1, 0, 0, n12, n11);
                OS.gdk_gc_set_function(l12, 4L);
                OS.gdk_draw_drawable(l4, l12, l3, 0, 0, 0, 0, n12, n11);
                OS.g_object_unref(l12);
                if (l3 != 0L && image.mask != l3) {
                    OS.g_object_unref(l3);
                }
                l3 = l4;
            }
            GdkGCValues gdkGCValues = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, gdkGCValues);
            OS.gdk_gc_set_clip_mask(this.handle, l3);
            OS.gdk_gc_set_clip_origin(this.handle, n5 - n, n6 - n2);
            OS.gdk_draw_drawable(l, this.handle, l2, n, n2, n5, n6, n3, n4);
            OS.gdk_gc_set_values(this.handle, gdkGCValues, 6272);
            if (this.data.clipRgn != 0L) {
                OS.gdk_gc_set_clip_region(this.handle, this.data.clipRgn);
            }
        }
        if (l2 != 0L && image.pixmap != l2) {
            OS.g_object_unref(l2);
        }
        if (l3 != 0L && image.mask != l3) {
            OS.g_object_unref(l3);
        }
        if (image.transparentPixel != -1 && image.memGC != null) {
            image.destroyMask();
        }
    }

    void drawImageXRender(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10, long l, int n11) {
        long l2;
        int n12 = 0;
        int n13 = 0;
        long l3 = this.data.drawable;
        if (this.data.image == null && !this.data.realDrawable) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long[] lArray = new long[1];
            OS.gdk_window_get_internal_paint_info(l3, lArray, nArray, nArray2);
            l3 = lArray[0];
            n12 = -nArray[0];
            n13 = -nArray2[0];
        }
        long l4 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        long l5 = 0L;
        if (l != 0L) {
            int n14 = 0;
            XRenderPictureAttributes xRenderPictureAttributes = null;
            if (image.alpha != -1) {
                n14 = 1;
                xRenderPictureAttributes = new XRenderPictureAttributes();
                xRenderPictureAttributes.repeat = true;
            }
            if ((l5 = OS.XRenderCreatePicture(l4, OS.gdk_x11_drawable_get_xid(l), OS.XRenderFindStandardFormat(l4, n11), n14, xRenderPictureAttributes)) == 0L) {
                SWT.error(2);
            }
        }
        long l6 = OS.XRenderFindVisualFormat(l4, OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()));
        long l7 = OS.XRenderCreatePicture(l4, OS.gdk_x11_drawable_get_xid(l3), l6, 0L, null);
        if (l7 == 0L) {
            SWT.error(2);
        }
        if ((l2 = OS.XRenderCreatePicture(l4, OS.gdk_x11_drawable_get_xid(image.pixmap), l6, 0L, null)) == 0L) {
            SWT.error(2);
        }
        if (n3 != n7 || n4 != n8) {
            int[] nArray = new int[]{(int)((float)n3 / (float)n7 * 65536.0f), 0, 0, 0, (int)((float)n4 / (float)n8 * 65536.0f), 0, 0, 0, 65536};
            OS.XRenderSetPictureTransform(l4, l2, nArray);
            if (l5 != 0L) {
                OS.XRenderSetPictureTransform(l4, l5, nArray);
            }
            n = (int)((float)n * ((float)n7 / (float)n3));
            n2 = (int)((float)n2 * ((float)n8 / (float)n4));
        }
        long l8 = this.data.clipRgn;
        if (this.data.damageRgn != 0L) {
            if (l8 == 0L) {
                l8 = this.data.damageRgn;
            } else {
                l8 = OS.gdk_region_new();
                OS.gdk_region_union(l8, this.data.clipRgn);
                OS.gdk_region_intersect(l8, this.data.damageRgn);
            }
        }
        if (l8 != 0L) {
            int[] nArray = new int[1];
            long[] lArray = new long[1];
            OS.gdk_region_get_rectangles(l8, lArray, nArray);
            GdkRectangle gdkRectangle = new GdkRectangle();
            short[] sArray = new short[nArray[0] * 4];
            int n15 = 0;
            int n16 = 0;
            while (n15 < nArray[0]) {
                OS.memmove(gdkRectangle, lArray[0] + (long)(n15 * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
                sArray[n16] = (short)(n12 + gdkRectangle.x);
                sArray[n16 + 1] = (short)(n13 + gdkRectangle.y);
                sArray[n16 + 2] = (short)gdkRectangle.width;
                sArray[n16 + 3] = (short)gdkRectangle.height;
                ++n15;
                n16 += 4;
            }
            OS.XRenderSetPictureClipRectangles(l4, l7, 0, 0, sArray, nArray[0]);
            if (l8 != this.data.clipRgn && l8 != this.data.damageRgn) {
                OS.gdk_region_destroy(l8);
            }
            if (lArray[0] != 0L) {
                OS.g_free(lArray[0]);
            }
        }
        OS.XRenderComposite(l4, l5 != 0L ? 3 : 1, l2, l5, l7, n, n2, n, n2, n5 + n12, n6 + n13, n7, n8);
        OS.XRenderFreePicture(l4, l7);
        OS.XRenderFreePicture(l4, l2);
        if (l5 != 0L) {
            OS.XRenderFreePicture(l4, l5);
        }
    }

    long scale(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        long l2 = OS.gdk_pixbuf_new(0, false, 8, n3, n4);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(l2, l, l3, n, n2, 0, 0, n3, n4);
        long l4 = OS.gdk_pixbuf_scale_simple(l2, n5, n6, 2);
        OS.g_object_unref(l2);
        return l4;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(761);
        long l = this.data.cairo;
        if (l != 0L) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            Cairo.cairo_move_to(l, (double)n + d, (double)n2 + d2);
            Cairo.cairo_line_to(l, (double)n3 + d, (double)n4 + d2);
            Cairo.cairo_stroke(l);
            return;
        }
        OS.gdk_draw_line(this.data.drawable, this.handle, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((l = this.data.cairo) != 0L) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n3 == n4) {
                Cairo.cairo_arc_negative(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, 0.0, -2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(l);
                Cairo.cairo_translate(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
                Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
                Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, 0.0, -2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_stroke(l);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, n, n2, n3, n4, 0, 23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(761);
        long l = this.data.cairo;
        Cairo.cairo_save(l);
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_translate(l, d, d2);
        long l2 = Cairo.cairo_copy_path(path.handle);
        if (l2 == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(l, l2);
        Cairo.cairo_path_destroy(l2);
        Cairo.cairo_stroke(l);
        Cairo.cairo_restore(l);
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(761);
        long l = this.data.cairo;
        if (l != 0L) {
            Cairo.cairo_rectangle(l, n, n2, 1.0, 1.0);
            Cairo.cairo_fill(l);
            return;
        }
        OS.gdk_draw_point(this.data.drawable, this.handle, n, n2);
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        long l = this.data.cairo;
        if (l != 0L) {
            this.drawPolyline(l, nArray, true);
            Cairo.cairo_stroke(l);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 0, nArray, nArray.length / 2);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        long l = this.data.cairo;
        if (l != 0L) {
            this.drawPolyline(l, nArray, false);
            Cairo.cairo_stroke(l);
            return;
        }
        OS.gdk_draw_lines(this.data.drawable, this.handle, nArray, nArray.length / 2);
    }

    void drawPolyline(long l, int[] nArray, boolean bl) {
        int n = nArray.length / 2;
        if (n == 0) {
            return;
        }
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_move_to(l, (double)nArray[0] + d, (double)nArray[1] + d2);
        int n2 = 1;
        int n3 = 2;
        while (n2 < n) {
            Cairo.cairo_line_to(l, (double)nArray[n3] + d, (double)nArray[n3 + 1] + d2);
            ++n2;
            n3 += 2;
        }
        if (bl) {
            Cairo.cairo_close_path(l);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((l = this.data.cairo) != 0L) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            Cairo.cairo_rectangle(l, (double)n + d, (double)n2 + d2, n3, n4);
            Cairo.cairo_stroke(l);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 0, n, n2, n3, n4);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(761);
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        if (n9 < 0) {
            n9 = 0 - n9;
            n7 -= n9;
        }
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if ((l = this.data.cairo) != 0L) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n11 == 0 || n12 == 0) {
                Cairo.cairo_rectangle(l, (double)n + d, (double)n2 + d2, n3, n4);
            } else {
                float f = (float)n11 / 2.0f;
                float f2 = (float)n12 / 2.0f;
                float f3 = (float)n9 / f;
                float f4 = (float)n10 / f2;
                Cairo.cairo_save(l);
                Cairo.cairo_translate(l, (double)n7 + d, (double)n8 + d2);
                Cairo.cairo_scale(l, f, f2);
                Cairo.cairo_move_to(l, f3 - 1.0f, 0.0);
                Cairo.cairo_arc(l, f3 - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(l, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(l, 1.0, f4 - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(l, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(l);
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_stroke(l);
            return;
        }
        int n13 = n11 / 2;
        int n14 = n12 / 2;
        long l2 = this.data.drawable;
        if (n9 > n11) {
            if (n10 > n12) {
                OS.gdk_draw_arc(l2, this.handle, 0, n7, n8, n11, n12, 5760, 5760);
                OS.gdk_draw_line(l2, this.handle, n7 + n13, n8, n7 + n9 - n13, n8);
                OS.gdk_draw_arc(l2, this.handle, 0, n7 + n9 - n11, n8, n11, n12, 0, 5760);
                OS.gdk_draw_line(l2, this.handle, n7 + n9, n8 + n14, n7 + n9, n8 + n10 - n14);
                OS.gdk_draw_arc(l2, this.handle, 0, n7 + n9 - n11, n8 + n10 - n12, n11, n12, 17280, 5760);
                OS.gdk_draw_line(l2, this.handle, n7 + n13, n8 + n10, n7 + n9 - n13, n8 + n10);
                OS.gdk_draw_arc(l2, this.handle, 0, n7, n8 + n10 - n12, n11, n12, 11520, 5760);
                OS.gdk_draw_line(l2, this.handle, n7, n8 + n14, n7, n8 + n10 - n14);
            } else {
                OS.gdk_draw_arc(l2, this.handle, 0, n7, n8, n11, n10, 5760, 11520);
                OS.gdk_draw_line(l2, this.handle, n7 + n13, n8, n7 + n9 - n13, n8);
                OS.gdk_draw_arc(l2, this.handle, 0, n7 + n9 - n11, n8, n11, n10, 17280, 11520);
                OS.gdk_draw_line(l2, this.handle, n7 + n13, n8 + n10, n7 + n9 - n13, n8 + n10);
            }
        } else if (n10 > n12) {
            OS.gdk_draw_arc(l2, this.handle, 0, n7, n8, n9, n12, 0, 11520);
            OS.gdk_draw_line(l2, this.handle, n7 + n9, n8 + n14, n7 + n9, n8 + n10 - n14);
            OS.gdk_draw_arc(l2, this.handle, 0, n7, n8 + n10 - n12, n9, n12, 11520, 11520);
            OS.gdk_draw_line(l2, this.handle, n7, n8 + n14, n7, n8 + n10 - n14);
        } else {
            OS.gdk_draw_arc(l2, this.handle, 0, n7, n8, n9, n10, 0, 23040);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        this.drawText(string, n, n2, bl ? 1 : 0);
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawText(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        long l = this.data.cairo;
        this.setString(string, n3);
        if (l != 0L) {
            this.checkGC(4);
            if ((n3 & 1) == 0) {
                this.checkGC(2);
                if (this.data.stringWidth == -1) {
                    this.computeStringSize();
                }
                Cairo.cairo_rectangle(l, n, n2, this.data.stringWidth, this.data.stringHeight);
                Cairo.cairo_fill(l);
            }
            this.checkGC(1);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_save(l);
                if (this.data.stringWidth == -1) {
                    this.computeStringSize();
                }
                Cairo.cairo_scale(l, -1.0, 1.0);
                Cairo.cairo_translate(l, -2 * n - this.data.stringWidth, 0.0);
            }
            Cairo.cairo_move_to(l, n, n2);
            OS.pango_cairo_show_layout(l, this.data.layout);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_new_path(l);
            return;
        }
        this.checkGC(261);
        GdkColor gdkColor = null;
        if ((n3 & 1) == 0) {
            gdkColor = this.data.background;
        }
        if (!this.data.xorMode) {
            OS.gdk_draw_layout_with_colors(this.data.drawable, this.handle, n, n2, this.data.layout, null, gdkColor);
        } else {
            long l2;
            long l3;
            long l4 = this.data.layout;
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            if ((l3 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), this.data.stringWidth, this.data.stringHeight, -1)) == 0L) {
                SWT.error(2);
            }
            if ((l2 = OS.gdk_gc_new(l3)) == 0L) {
                SWT.error(2);
            }
            GdkColor gdkColor2 = new GdkColor();
            OS.gdk_gc_set_foreground(l2, gdkColor2);
            OS.gdk_draw_rectangle(l3, l2, 1, 0, 0, this.data.stringWidth, this.data.stringHeight);
            OS.gdk_gc_set_foreground(l2, this.data.foreground);
            OS.gdk_draw_layout_with_colors(l3, l2, 0, 0, l4, null, gdkColor);
            OS.g_object_unref(l2);
            OS.gdk_draw_drawable(this.data.drawable, this.handle, l3, 0, 0, n, n2, this.data.stringWidth, this.data.stringHeight);
            OS.g_object_unref(l3);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        long l = this.data.cairo;
        if (l != 0L) {
            if (n3 == n4) {
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
            } else {
                Cairo.cairo_save(l);
                Cairo.cairo_translate(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
                Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(l, 0.0, 0.0);
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_fill(l);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, n, n2, n3, n4, n5 * 64, n6 * 64);
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        RGB rGB;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangle(n, n2, n3, n4);
            return;
        }
        long l = this.data.cairo;
        if (l != 0L) {
            long l2 = bl ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
            Cairo.cairo_pattern_add_color_stop_rgba(l2, 0.0, (float)rGB3.red / 255.0f, (float)rGB3.green / 255.0f, (float)rGB3.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_pattern_add_color_stop_rgba(l2, 1.0, (float)rGB4.red / 255.0f, (float)rGB4.green / 255.0f, (float)rGB4.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, n, n2);
            Cairo.cairo_scale(l, n3, n4);
            Cairo.cairo_rectangle(l, 0.0, 0.0, 1.0, 1.0);
            Cairo.cairo_set_source(l, l2);
            Cairo.cairo_fill(l);
            Cairo.cairo_restore(l);
            Cairo.cairo_pattern_destroy(l2);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, n, n2, n3, n4, bl, rGB3, rGB4, 8, 8, 8);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((l = this.data.cairo) != 0L) {
            if (n3 == n4) {
                Cairo.cairo_arc_negative(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, 0.0, 2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(l);
                Cairo.cairo_translate(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
                Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
                Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, 0.0, 2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_fill(l);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, n, n2, n3, n4, 0, 23040);
    }

    public void fillPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        long l = this.data.cairo;
        long l2 = Cairo.cairo_copy_path(path.handle);
        if (l2 == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(l, l2);
        Cairo.cairo_path_destroy(l2);
        Cairo.cairo_fill(l);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        long l = this.data.cairo;
        if (l != 0L) {
            this.drawPolyline(l, nArray, true);
            Cairo.cairo_fill(l);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 1, nArray, nArray.length / 2);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((l = this.data.cairo) != 0L) {
            Cairo.cairo_rectangle(l, n, n2, n3, n4);
            Cairo.cairo_fill(l);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 1, n, n2, n3, n4);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(2);
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        if (n9 < 0) {
            n9 = 0 - n9;
            n7 -= n9;
        }
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if ((l = this.data.cairo) != 0L) {
            if (n11 == 0 || n12 == 0) {
                Cairo.cairo_rectangle(l, n, n2, n3, n4);
            } else {
                float f = (float)n11 / 2.0f;
                float f2 = (float)n12 / 2.0f;
                float f3 = (float)n9 / f;
                float f4 = (float)n10 / f2;
                Cairo.cairo_save(l);
                Cairo.cairo_translate(l, n7, n8);
                Cairo.cairo_scale(l, f, f2);
                Cairo.cairo_move_to(l, f3 - 1.0f, 0.0);
                Cairo.cairo_arc(l, f3 - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(l, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(l, 1.0, f4 - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(l, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(l);
                Cairo.cairo_restore(l);
            }
            Cairo.cairo_fill(l);
            return;
        }
        int n13 = n11 / 2;
        int n14 = n12 / 2;
        long l2 = this.data.drawable;
        if (n9 > n11) {
            if (n10 > n12) {
                OS.gdk_draw_arc(l2, this.handle, 1, n7, n8, n11, n12, 5760, 5760);
                OS.gdk_draw_rectangle(l2, this.handle, 1, n7 + n13, n8, n9 - n13 * 2, n10);
                OS.gdk_draw_arc(l2, this.handle, 1, n7 + n9 - n11, n8, n11, n12, 0, 5760);
                OS.gdk_draw_rectangle(l2, this.handle, 1, n7, n8 + n14, n13, n10 - n14 * 2);
                OS.gdk_draw_arc(l2, this.handle, 1, n7 + n9 - n11, n8 + n10 - n12, n11, n12, 17280, 5760);
                OS.gdk_draw_rectangle(l2, this.handle, 1, n7 + n9 - n13, n8 + n14, n13, n10 - n14 * 2);
                OS.gdk_draw_arc(l2, this.handle, 1, n7, n8 + n10 - n12, n11, n12, 11520, 5760);
            } else {
                OS.gdk_draw_arc(l2, this.handle, 1, n7, n8, n11, n10, 5760, 11520);
                OS.gdk_draw_rectangle(l2, this.handle, 1, n7 + n13, n8, n9 - n13 * 2, n10);
                OS.gdk_draw_arc(l2, this.handle, 1, n7 + n9 - n11, n8, n11, n10, 17280, 11520);
            }
        } else if (n10 > n12) {
            OS.gdk_draw_arc(l2, this.handle, 1, n7, n8, n9, n12, 0, 11520);
            OS.gdk_draw_rectangle(l2, this.handle, 1, n7, n8 + n14, n9, n10 - n14 * 2);
            OS.gdk_draw_arc(l2, this.handle, 1, n7, n8 + n10 - n12, n9, n12, 11520, 11520);
        } else {
            OS.gdk_draw_arc(l2, this.handle, 1, n7, n8, n9, n10, 0, 23040);
        }
    }

    int fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            if (n3 == -1) {
                n3 = n2;
            }
            --n2;
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return n3;
    }

    public int getAdvanceWidth(char c) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.cairo != 0L;
    }

    public int getAlpha() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int n = Cairo.cairo_get_antialias(this.data.cairo);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return Color.gtk_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char c) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.getSize(nArray, nArray2);
        n3 = nArray[0];
        n4 = nArray2[0];
        long l = this.data.cairo;
        long l2 = this.data.clipRgn;
        long l3 = this.data.damageRgn;
        if (l2 != 0L || l3 != 0L || l != 0L) {
            long l4 = OS.gdk_region_new();
            GdkRectangle gdkRectangle = new GdkRectangle();
            gdkRectangle.width = n3;
            gdkRectangle.height = n4;
            OS.gdk_region_union_with_rect(l4, gdkRectangle);
            if (l3 != 0L) {
                OS.gdk_region_intersect(l4, l3);
            }
            if (l2 != 0L) {
                if (this.data.clippingTransform != null) {
                    l2 = this.convertRgn(l2, this.data.clippingTransform);
                    OS.gdk_region_intersect(l4, l2);
                    OS.gdk_region_destroy(l2);
                } else {
                    OS.gdk_region_intersect(l4, l2);
                }
            }
            if (l != 0L) {
                double[] dArray = new double[6];
                Cairo.cairo_get_matrix(l, dArray);
                Cairo.cairo_matrix_invert(dArray);
                l2 = this.convertRgn(l4, dArray);
                OS.gdk_region_destroy(l4);
                l4 = l2;
            }
            OS.gdk_region_get_clipbox(l4, gdkRectangle);
            OS.gdk_region_destroy(l4);
            n = gdkRectangle.x;
            n2 = gdkRectangle.y;
            n3 = gdkRectangle.width;
            n4 = gdkRectangle.height;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void getClipping(Region region) {
        Object object;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        long l = region.handle;
        OS.gdk_region_subtract(l, l);
        long l2 = this.data.cairo;
        long l3 = this.data.clipRgn;
        if (l3 == 0L) {
            object = new GdkRectangle();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            ((GdkRectangle)object).width = nArray[0];
            ((GdkRectangle)object).height = nArray2[0];
            OS.gdk_region_union_with_rect(l, (GdkRectangle)object);
        } else if (this.data.clippingTransform != null) {
            long l4 = this.convertRgn(l3, this.data.clippingTransform);
            OS.gdk_region_union(l, l4);
            OS.gdk_region_destroy(l4);
        } else {
            OS.gdk_region_union(l, l3);
        }
        if (this.data.damageRgn != 0L) {
            OS.gdk_region_intersect(l, this.data.damageRgn);
        }
        if (l2 != 0L) {
            object = new double[6];
            Cairo.cairo_get_matrix(l2, (double[])object);
            Cairo.cairo_matrix_invert((double[])object);
            long l5 = this.convertRgn(l, (double[])object);
            OS.gdk_region_subtract(l, l);
            OS.gdk_region_union(l, l5);
            OS.gdk_region_destroy(l5);
        }
    }

    public int getFillRule() {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((l = this.data.cairo) == 0L) {
            return 1;
        }
        return Cairo.cairo_get_fill_rule(l) == 0 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.context == 0L) {
            this.createLayout();
        }
        this.checkGC(4);
        Font font = this.data.font;
        long l = this.data.context;
        long l2 = OS.pango_context_get_language(l);
        long l3 = OS.pango_context_get_metrics(l, font.handle, l2);
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(l3));
        fontMetrics.descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(l3));
        fontMetrics.averageCharWidth = OS.PANGO_PIXELS(OS.pango_font_metrics_get_approximate_char_width(l3));
        fontMetrics.height = fontMetrics.ascent + fontMetrics.descent;
        OS.pango_font_metrics_unref(l3);
        return fontMetrics;
    }

    public Color getForeground() {
        if (this.handle == 0L) {
            SWT.error(24);
        }
        return Color.gtk_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)this.data.lineDashes[i];
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.style;
    }

    void getSize(int[] nArray, int[] nArray2) {
        if (this.data.width != -1 && this.data.height != -1) {
            nArray[0] = this.data.width;
            nArray2[0] = this.data.height;
            return;
        }
        if (this.data.drawable != 0L) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                nArray[0] = OS.gdk_window_get_width(this.data.drawable);
                nArray2[0] = OS.gdk_window_get_height(this.data.drawable);
            } else {
                OS.gdk_drawable_get_size(this.data.drawable, nArray, nArray2);
            }
            return;
        }
        if (OS.USE_CAIRO) {
            long l = Cairo.cairo_get_target(this.handle);
            switch (Cairo.cairo_surface_get_type(l)) {
                case 0: {
                    nArray[0] = Cairo.cairo_image_surface_get_width(l);
                    nArray2[0] = Cairo.cairo_image_surface_get_height(l);
                    break;
                }
                case 3: {
                    nArray[0] = Cairo.cairo_xlib_surface_get_width(l);
                    nArray2[0] = Cairo.cairo_xlib_surface_get_height(l);
                }
            }
        }
    }

    public int getTextAntialias() {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int n = 0;
        if (this.data.context != 0L && (l = OS.pango_cairo_context_get_font_options(this.data.context)) != 0L) {
            n = Cairo.cairo_font_options_get_antialias(l);
        }
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((l = this.data.cairo) != 0L) {
            Cairo.cairo_get_matrix(l, transform.handle);
            double[] dArray = this.identity();
            Cairo.cairo_matrix_invert(dArray);
            Cairo.cairo_matrix_multiply(transform.handle, transform.handle, dArray);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    double[] identity() {
        double[] dArray = new double[6];
        if ((this.data.style & 0x8000000) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            Cairo.cairo_matrix_init(dArray, -1.0, 0.0, 0.0, 1.0, nArray[0], 0.0);
        } else {
            Cairo.cairo_matrix_init_identity(dArray);
        }
        if (this.data.identity != null) {
            Cairo.cairo_matrix_multiply(dArray, this.data.identity, dArray);
        }
        return dArray;
    }

    void init(Drawable drawable, GCData gCData, long l) {
        long l2;
        Image image;
        if (gCData.foreground != null) {
            gCData.state &= 0xFFFFFFFE;
        }
        if (gCData.background != null) {
            gCData.state &= 0xFFFFFEFD;
        }
        if (gCData.font != null) {
            gCData.state &= 0xFFFFFFFB;
        }
        if ((image = gCData.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = l;
        if (OS.USE_CAIRO) {
            l2 = gCData.cairo = this.handle;
            Cairo.cairo_set_fill_rule(l2, 1);
            gCData.state &= 0xFFFFFD80;
        } else if (OS.INIT_CAIRO) {
            this.initCairo();
        }
        this.setClipping(gCData.clipRgn);
        if ((gCData.style & 0x8000000) != 0) {
            this.initCairo();
            l2 = gCData.cairo;
            Cairo.cairo_set_matrix(l2, this.identity());
        }
    }

    void initCairo() {
        this.data.device.checkCairo();
        long l = this.data.cairo;
        if (l != 0L) {
            return;
        }
        this.data.cairo = l = OS.gdk_cairo_create(this.data.drawable);
        if (l == 0L) {
            SWT.error(2);
        }
        this.data.disposeCairo = true;
        Cairo.cairo_set_fill_rule(l, 1);
        this.data.state &= 0xFFFFFD80;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    void computeStringSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_pixel_size(this.data.layout, nArray, nArray2);
        this.data.stringHeight = nArray2[0];
        this.data.stringWidth = nArray[0];
    }

    public boolean isClipped() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0L;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    boolean isIdentity(double[] dArray) {
        if (dArray == null) {
            return true;
        }
        return dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0 && dArray[4] == 0.0 && dArray[5] == 0.0;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((this.data.style & 0x8000000) != 0 || OS.USE_CAIRO || OS.INIT_CAIRO) {
            if (!bl) {
                this.setAlpha(255);
                this.setAntialias(-1);
                this.setBackgroundPattern(null);
                this.setClipping(0L);
                this.setForegroundPattern(null);
                this.setInterpolation(-1);
                this.setTextAntialias(-1);
                this.setTransform(null);
            }
            return;
        }
        if (bl && this.data.cairo != 0L) {
            return;
        }
        if (bl) {
            try {
                this.initCairo();
            }
            catch (SWTException sWTException) {}
        } else {
            if (!this.data.disposeCairo) {
                return;
            }
            long l = this.data.cairo;
            if (l != 0L) {
                Cairo.cairo_destroy(l);
            }
            this.data.cairo = 0L;
            this.data.interpolation = -1;
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0L);
        }
    }

    public void setAlpha(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && (n & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = n & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long l = this.data.cairo;
        Cairo.cairo_set_antialias(l, n2);
    }

    public void setBackground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(long l, Font font) {
        if (font == null || font.isDisposed()) {
            return;
        }
        GC.setCairoFont(l, font.handle);
    }

    static void setCairoFont(long l, long l2) {
        long l3 = OS.pango_font_description_get_family(l2);
        int n = OS.strlen(l3);
        byte[] byArray = new byte[n + 1];
        OS.memmove(byArray, l3, (long)n);
        double d = OS.PANGO_PIXELS(OS.pango_font_description_get_size(l2)) * 96 / 72;
        int n2 = OS.pango_font_description_get_style(l2);
        int n3 = OS.pango_font_description_get_weight(l2);
        int n4 = 0;
        if (n2 == 2) {
            n4 = 1;
        }
        if (n2 == 1) {
            n4 = 2;
        }
        int n5 = 0;
        if (n3 == 700) {
            n5 = 1;
        }
        Cairo.cairo_select_font_face(l, byArray, n4, n5);
        Cairo.cairo_set_font_size(l, d);
    }

    static void setCairoRegion(long l, long l2) {
        OS.gdk_cairo_region(l, l2);
    }

    static void setCairoPatternColor(long l, int n, Color color, int n2) {
        GdkColor gdkColor = color.handle;
        double d = (double)(n2 & 0xFF) / 255.0;
        double d2 = (double)(gdkColor.red & 0xFFFF) / 65535.0;
        double d3 = (double)(gdkColor.green & 0xFFFF) / 65535.0;
        double d4 = (double)(gdkColor.blue & 0xFFFF) / 65535.0;
        Cairo.cairo_pattern_add_color_stop_rgba(l, n, d2, d3, d4, d);
    }

    void setCairoClip(long l, long l2) {
        long l3 = this.data.cairo;
        if (this.data.drawable != 0L && !OS.GTK3) {
            OS.gdk_cairo_reset_clip(l3, this.data.drawable);
        } else {
            Cairo.cairo_reset_clip(l3);
        }
        if (l != 0L) {
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(l3, dArray);
            double[] dArray2 = new double[6];
            Cairo.cairo_matrix_init_identity(dArray2);
            Cairo.cairo_set_matrix(l3, dArray2);
            GC.setCairoRegion(l3, l);
            Cairo.cairo_clip(l3);
            Cairo.cairo_set_matrix(l3, dArray);
        }
        if (l2 != 0L) {
            GC.setCairoRegion(l3, l2);
            Cairo.cairo_clip(l3);
        }
    }

    void setClipping(long l) {
        long l2 = this.data.cairo;
        if (l == 0L) {
            if (this.data.clipRgn != 0L) {
                OS.gdk_region_destroy(this.data.clipRgn);
                this.data.clipRgn = 0L;
            }
            if (l2 != 0L) {
                this.data.clippingTransform = null;
                this.setCairoClip(this.data.damageRgn, 0L);
            } else {
                long l3 = this.data.damageRgn != 0L ? this.data.damageRgn : 0L;
                OS.gdk_gc_set_clip_region(this.handle, l3);
            }
        } else {
            if (this.data.clipRgn == 0L) {
                this.data.clipRgn = OS.gdk_region_new();
            }
            OS.gdk_region_subtract(this.data.clipRgn, this.data.clipRgn);
            OS.gdk_region_union(this.data.clipRgn, l);
            if (l2 != 0L) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new double[6];
                }
                Cairo.cairo_get_matrix(l2, this.data.clippingTransform);
                this.setCairoClip(this.data.damageRgn, l);
            } else {
                long l4 = l;
                if (this.data.damageRgn != 0L) {
                    l4 = OS.gdk_region_new();
                    OS.gdk_region_union(l4, l);
                    OS.gdk_region_intersect(l4, this.data.damageRgn);
                }
                OS.gdk_gc_set_clip_region(this.handle, l4);
                if (l4 != l) {
                    OS.gdk_region_destroy(l4);
                }
            }
        }
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        long l = OS.gdk_region_new();
        OS.gdk_region_union_with_rect(l, gdkRectangle);
        this.setClipping(l);
        OS.gdk_region_destroy(l);
    }

    public void setClipping(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0L);
        if (path != null) {
            this.initCairo();
            long l = this.data.cairo;
            long l2 = Cairo.cairo_copy_path(path.handle);
            if (l2 == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(l, l2);
            Cairo.cairo_path_destroy(l2);
            Cairo.cairo_clip(l);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (OS.GTK_VERSION >= OS.VERSION(3, 9, 0)) {
            return;
        }
        if (rectangle == null) {
            this.setClipping(0L);
        } else {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0L);
    }

    public void setFont(Font font) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long l = this.data.cairo;
        if (l != 0L) {
            Cairo.cairo_set_fill_rule(l, n2);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && n == -1) {
            return;
        }
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = n;
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        float f;
        int n;
        int n2;
        int n3;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (lineAttributes == null) {
            SWT.error(4);
        }
        int n4 = 0;
        float f2 = lineAttributes.width;
        if (f2 != this.data.lineWidth) {
            n4 |= 0x240;
        }
        if ((n3 = lineAttributes.style) != this.data.lineStyle) {
            n4 |= 8;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n3 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.join) != this.data.lineJoin) {
            n4 |= 0x20;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n = lineAttributes.cap) != this.data.lineCap) {
            n4 |= 0x10;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl = fArray2 == null || fArray2.length != fArray.length;
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = fArray[i];
                if (f3 <= 0.0f) {
                    SWT.error(5);
                }
                if (bl || fArray2[i] == f3) continue;
                bl = true;
            }
            if (bl) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n4 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n4 |= 8;
        } else {
            fArray = fArray2;
        }
        float f4 = lineAttributes.dashOffset;
        if (f4 != this.data.lineDashesOffset) {
            n4 |= 8;
        }
        if ((f = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n4 |= 0x80;
        }
        this.initCairo();
        if (n4 == 0) {
            return;
        }
        this.data.lineWidth = f2;
        this.data.lineStyle = n3;
        this.data.lineCap = n;
        this.data.lineJoin = n2;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f4;
        this.data.lineMiterLimit = f;
        this.data.state &= ~n4;
    }

    public void setLineCap(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineCap == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            int n;
            boolean bl = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n];
                if (n2 <= 0) {
                    SWT.error(5);
                }
                if (bl || fArray[n] == (float)n2) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                this.data.lineDashes[n] = nArray[n];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.state &= 0xFFFFFDBF;
    }

    void setString(String string, int n) {
        byte[] byArray;
        int n2;
        if (this.data.layout == 0L) {
            this.createLayout();
        }
        if (string == this.data.string && (n & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int n3 = string.length();
        long l = this.data.layout;
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        if ((n & 8) != 0 && (n2 = this.fixMnemonic(cArray)) != -1) {
            char[] cArray2 = new char[n2 - 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            byte[] byArray2 = Converter.wcsToMbcs(null, cArray2, false);
            char[] cArray3 = new char[cArray.length - n2];
            System.arraycopy(cArray, n2 - 1, cArray3, 0, cArray3.length);
            byte[] byArray3 = Converter.wcsToMbcs(null, cArray3, false);
            byArray = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
            long l2 = OS.pango_attr_list_new();
            long l3 = OS.pango_attr_underline_new(3);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, l3, (long)PangoAttribute.sizeof);
            pangoAttribute.start_index = byArray2.length;
            pangoAttribute.end_index = byArray2.length + 1;
            OS.memmove(l3, pangoAttribute, (long)PangoAttribute.sizeof);
            OS.pango_attr_list_insert(l2, l3);
            OS.pango_layout_set_attributes(l, l2);
            OS.pango_attr_list_unref(l2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray, false);
            OS.pango_layout_set_attributes(l, 0L);
        }
        OS.pango_layout_set_text(l, byArray, byArray.length);
        OS.pango_layout_set_single_paragraph_mode(l, (n & 2) == 0);
        OS.pango_layout_set_tabs(l, (n & 4) != 0 ? 0L : this.data.device.emptyTab);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = n;
    }

    public void setTextAntialias(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long l = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(l, n2);
        if (this.data.context == 0L) {
            this.createLayout();
        }
        OS.pango_cairo_context_set_font_options(this.data.context, l);
        Cairo.cairo_font_options_destroy(l);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && transform == null) {
            return;
        }
        this.initCairo();
        long l = this.data.cairo;
        double[] dArray = this.identity();
        if (transform != null) {
            Cairo.cairo_matrix_multiply(dArray, transform.handle, dArray);
        }
        Cairo.cairo_set_matrix(l, dArray);
        this.data.state &= 0xFFFFFDFF;
    }

    @Deprecated
    public void setXORMode(boolean bl) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((l = this.data.cairo) != 0L && Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 10, 0)) {
            Cairo.cairo_set_operator(this.handle, bl ? 23 : 2);
        }
        if (!OS.USE_CAIRO) {
            OS.gdk_gc_set_function(this.handle, bl ? 2L : 0L);
        }
        this.data.xorMode = bl;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.setString(string, n);
        this.checkGC(4);
        if (this.data.stringWidth == -1) {
            this.computeStringSize();
        }
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

