/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.datasupport;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataChangeSupport<X> {
    private ChangeSupport<X> changeSupport = new ChangeSupport();

    public void addChangeListener(final DataChangeListener<X> listener) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                DataChangeSupport.this.changeSupport.addChangeListener(listener);
            }
        });
    }

    public void removeChangeListener(final DataChangeListener<X> listener) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                DataChangeSupport.this.changeSupport.removeChangeListener(listener);
            }
        });
    }

    public void fireChange(final Set<X> current, final Set<X> added, final Set<X> removed) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            public void run() {
                DataChangeSupport.this.changeSupport.fireChange(current, added, removed);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeSupport<X> {
        private Set<DataChangeListener<X>> listeners = new HashSet<DataChangeListener<X>>();
        private Set<X> currentSet;

        private ChangeSupport() {
        }

        private void addChangeListener(DataChangeListener<X> listener) {
            if (!this.listeners.add(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " already registed");
            }
            if (this.currentSet != null) {
                DataChangeEvent<X> event = new DataChangeEvent<X>(this.currentSet, this.currentSet, null);
                listener.dataChanged(event);
            }
        }

        private void removeChangeListener(DataChangeListener<X> listener) {
            if (!this.listeners.remove(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " not registered");
            }
        }

        private void fireChange(Set<X> current, Set<X> added, Set<X> removed) {
            this.currentSet = current;
            if (this.listeners.isEmpty()) {
                return;
            }
            DataChangeEvent<X> event = new DataChangeEvent<X>(current, added, removed);
            Iterator<DataChangeListener<X>> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().dataChanged(event);
            }
        }
    }
}

