/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    private static native void initIDs();

    public SampleModel(int n, int n2, int n3, int n4) {
        long l = (long)n2 * (long)n3;
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Width (" + n2 + ") and height (" + n3 + ") must be > 0");
        }
        if (l >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Dimensions (width=" + n2 + " height=" + n3 + ") are too large");
        }
        if (n < 0 || n > 5 && n != 32) {
            throw new IllegalArgumentException("Unsupported dataType: " + n);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("Number of bands must be > 0");
        }
        this.dataType = n;
        this.width = n2;
        this.height = n3;
        this.numBands = n4;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public abstract int getNumDataElements();

    public final int getDataType() {
        return this.dataType;
    }

    public int getTransferType() {
        return this.dataType;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            nArray2[i] = this.getSample(n, n2, i, dataBuffer);
        }
        return nArray2;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = this.getTransferType();
        int n6 = this.getNumDataElements();
        int n7 = 0;
        Object object2 = null;
        int n8 = n + n3;
        int n9 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n8 < 0 || n8 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n9 < 0 || n9 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        switch (n5) {
            case 0: {
                byte[] byArray = object == null ? new byte[n6 * n3 * n4] : (byte[])object;
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        for (int k = 0; k < n6; ++k) {
                            byArray[n7++] = byArray2[k];
                        }
                    }
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n6 * n3 * n4] : (short[])object;
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        for (int k = 0; k < n6; ++k) {
                            sArray[n7++] = sArray2[k];
                        }
                    }
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n6 * n3 * n4] : (int[])object;
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        for (int k = 0; k < n6; ++k) {
                            nArray[n7++] = nArray2[k];
                        }
                    }
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n6 * n3 * n4] : (float[])object;
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        for (int k = 0; k < n6; ++k) {
                            fArray[n7++] = fArray2[k];
                        }
                    }
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n6 * n3 * n4] : (double[])object;
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        object2 = this.getDataElements(j, i, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        for (int k = 0; k < n6; ++k) {
                            dArray[n7++] = dArray2[k];
                        }
                    }
                }
                object = dArray;
            }
        }
        return object;
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = 0;
        Object var8_8 = null;
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        int n8 = n + n3;
        int n9 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n8 < 0 || n8 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n9 < 0 || n9 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        switch (n6) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n7];
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            byArray2[k] = byArray[n5++];
                        }
                        this.setDataElements(j, i, byArray2, dataBuffer);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n7];
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            sArray2[k] = sArray[n5++];
                        }
                        this.setDataElements(j, i, sArray2, dataBuffer);
                    }
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n7];
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            nArray2[k] = nArray[n5++];
                        }
                        this.setDataElements(j, i, nArray2, dataBuffer);
                    }
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n7];
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            fArray2[k] = fArray[n5++];
                        }
                        this.setDataElements(j, i, fArray2, dataBuffer);
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n7];
                for (int i = n2; i < n9; ++i) {
                    for (int j = n; j < n8; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            dArray2[k] = dArray[n5++];
                        }
                        this.setDataElements(j, i, dArray2, dataBuffer);
                    }
                }
                break;
            }
        }
    }

    public float[] getPixel(int n, int n2, float[] fArray, DataBuffer dataBuffer) {
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            fArray2[i] = this.getSampleFloat(n, n2, i, dataBuffer);
        }
        return fArray2;
    }

    public double[] getPixel(int n, int n2, double[] dArray, DataBuffer dataBuffer) {
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            dArray2[i] = this.getSampleDouble(n, n2, i, dataBuffer);
        }
        return dArray2;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n6 < 0 || n6 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n7 < 0 || n7 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands * n3 * n4];
        for (int i = n2; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    nArray2[n5++] = this.getSample(j, i, k, dataBuffer);
                }
            }
        }
        return nArray2;
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n6 < 0 || n6 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n7 < 0 || n7 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands * n3 * n4];
        for (int i = n2; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    fArray2[n5++] = this.getSampleFloat(j, i, k, dataBuffer);
                }
            }
        }
        return fArray2;
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n6 < 0 || n6 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n7 < 0 || n7 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n3 * n4];
        for (int i = n2; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    dArray2[n5++] = this.getSampleDouble(j, i, k, dataBuffer);
                }
            }
        }
        return dArray2;
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        float f = this.getSample(n, n2, n3, dataBuffer);
        return f;
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        double d = this.getSample(n, n2, n3, dataBuffer);
        return d;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < 0 || n7 < n || n7 > this.width || n2 < 0 || n8 < n2 || n8 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                nArray2[n6++] = this.getSample(j, i, n5, dataBuffer);
            }
        }
        return nArray2;
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < 0 || n7 < n || n7 > this.width || n2 < 0 || n8 < n2 || n8 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates");
        }
        float[] fArray2 = fArray != null ? fArray : new float[n3 * n4];
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                fArray2[n6++] = this.getSampleFloat(j, i, n5, dataBuffer);
            }
        }
        return fArray2;
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < 0 || n7 < n || n7 > this.width || n2 < 0 || n8 < n2 || n8 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates");
        }
        double[] dArray2 = dArray != null ? dArray : new double[n3 * n4];
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                dArray2[n6++] = this.getSampleDouble(j, i, n5, dataBuffer);
            }
        }
        return dArray2;
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(n, n2, i, nArray[i], dataBuffer);
        }
    }

    public void setPixel(int n, int n2, float[] fArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(n, n2, i, fArray[i], dataBuffer);
        }
    }

    public void setPixel(int n, int n2, double[] dArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(n, n2, i, dArray[i], dataBuffer);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n6 < 0 || n6 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n7 < 0 || n7 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        for (int i = n2; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    this.setSample(j, i, k, nArray[n5++], dataBuffer);
                }
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n6 < 0 || n6 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n7 < 0 || n7 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        for (int i = n2; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    this.setSample(j, i, k, fArray[n5++], dataBuffer);
                }
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n + n3;
        int n7 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n6 < 0 || n6 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n7 < 0 || n7 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        for (int i = n2; i < n7; ++i) {
            for (int j = n; j < n6; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    this.setSample(j, i, k, dArray[n5++], dataBuffer);
                }
            }
        }
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        int n4 = (int)f;
        this.setSample(n, n2, n3, n4, dataBuffer);
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        int n4 = (int)d;
        this.setSample(n, n2, n3, n4, dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n7 < 0 || n7 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n8 < 0 || n8 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                this.setSample(j, i, n5, nArray[n6++], dataBuffer);
            }
        }
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n7 < 0 || n7 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n8 < 0 || n8 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                this.setSample(j, i, n5, fArray[n6++], dataBuffer);
            }
        }
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n7 < 0 || n7 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n8 < 0 || n8 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Invalid coordinates.");
        }
        for (int i = n2; i < n8; ++i) {
            for (int j = n; j < n7; ++j) {
                this.setSample(j, i, n5, dArray[n6++], dataBuffer);
            }
        }
    }

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public abstract DataBuffer createDataBuffer();

    public abstract int[] getSampleSize();

    public abstract int getSampleSize(int var1);

    static {
        ColorModel.loadLibraries();
        SampleModel.initIDs();
    }
}

