/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import sun.security.util.Debug;

class PKIXMasterCertPathValidator {
    private static final Debug debug = Debug.getInstance("certpath");

    PKIXMasterCertPathValidator() {
    }

    static void validate(CertPath certPath, List<X509Certificate> list, List<PKIXCertPathChecker> list2) throws CertPathValidatorException {
        int n = list.size();
        if (debug != null) {
            debug.println("--------------------------------------------------------------");
            debug.println("Executing PKIX certification path validation algorithm.");
        }
        for (int i = 0; i < n; ++i) {
            Set<String> set;
            X509Certificate x509Certificate = list.get(i);
            if (debug != null) {
                debug.println("Checking cert" + (i + 1) + " - Subject: " + x509Certificate.getSubjectX500Principal());
            }
            if ((set = x509Certificate.getCriticalExtensionOIDs()) == null) {
                set = Collections.emptySet();
            }
            if (debug != null && !set.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
                for (String string : set) {
                    stringJoiner.add(string);
                }
                debug.println("Set of critical extensions: " + stringJoiner.toString());
            }
            for (int j = 0; j < list2.size(); ++j) {
                PKIXCertPathChecker pKIXCertPathChecker = list2.get(j);
                if (debug != null) {
                    debug.println("-Using checker" + (j + 1) + " ... [" + pKIXCertPathChecker.getClass().getName() + "]");
                }
                if (i == 0) {
                    pKIXCertPathChecker.init(false);
                }
                try {
                    pKIXCertPathChecker.check(x509Certificate, set);
                    if (debug == null) continue;
                    debug.println("-checker" + (j + 1) + " validation succeeded");
                    continue;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n - (i + 1), certPathValidatorException.getReason());
                }
            }
            if (!set.isEmpty()) {
                throw new CertPathValidatorException("unrecognized critical extension(s)", null, certPath, n - (i + 1), PKIXReason.UNRECOGNIZED_CRIT_EXT);
            }
            if (debug == null) continue;
            debug.println("\ncert" + (i + 1) + " validation succeeded.\n");
        }
        if (debug != null) {
            debug.println("Cert path validation succeeded. (PKIX validation algorithm)");
            debug.println("--------------------------------------------------------------");
        }
    }
}

