/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.midi;

import dguitar.adaptors.guitarPro.GPAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.codecs.CodecFormatException;
import dguitar.codecs.CodecOutputStream;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.midi.MidiFormatException;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.midi.MidiFiler;
import dguitar.players.sound.midi.PerformanceFile;
import dguitar.players.sound.midi.PerformanceLive;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiOutputStream
implements CodecOutputStream {
    OutputStream out;

    public MidiOutputStream(OutputStream out) {
        this.out = out;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public int write(Object obj) throws IOException, CodecFormatException {
        if (obj instanceof GPSong) {
            this.writeGPSong((GPSong)obj);
        } else if (obj instanceof Song) {
            this.writeSong((Song)obj);
        } else if (obj instanceof PerformanceFile) {
            this.writePerformanceFile((PerformanceFile)obj);
        } else if (obj instanceof PerformanceLive) {
            this.writePerformanceLive((PerformanceLive)obj);
        }
        return 0;
    }

    private void writePerformanceLive(PerformanceLive live) throws IOException {
        PerformanceLive sequence = live;
        Track[] allTracks = sequence.getTracks();
        Track lastTrack = allTracks[allTracks.length - 1];
        int trackSize = lastTrack.size();
        LinkedList<MidiEvent> eventBuffer = new LinkedList<MidiEvent>();
        int i = 0;
        while (i < trackSize) {
            eventBuffer.add(lastTrack.get(i));
            ++i;
        }
        sequence.deleteTrack(lastTrack);
        this.writeSequence(sequence);
        Track newTrack = sequence.createTrack();
        Iterator it = eventBuffer.iterator();
        while (it.hasNext()) {
            MidiEvent event = (MidiEvent)it.next();
            newTrack.add(event);
        }
    }

    private void writePerformanceFile(PerformanceFile file) throws IOException {
        PerformanceFile sequence = file;
        this.writeSequence(sequence);
    }

    private void writeSequence(Sequence sequence) throws IOException {
        MidiSystem.write(sequence, 1, this.out);
    }

    private void writeSong(Song song) throws IOException {
        MasterPlayer player = new MasterPlayer();
        player.setSoundPlayer(new MidiFiler());
        PerformanceFile pf = (PerformanceFile)player.arrange(song, null);
        this.writePerformanceFile(pf);
    }

    private void writeGPSong(GPSong gpsong) throws MidiFormatException, IOException {
        Song song = null;
        try {
            song = GPAdaptor.makeSong(gpsong);
        }
        catch (GPFormatException e) {
            throw new MidiFormatException("Could not convert GPSong to Song format", e);
        }
        this.writeSong(song);
    }

    public boolean supportedExtension(String extension) {
        return extension.toUpperCase().equals(".MID");
    }
}

