/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.profile.ProfileShardResult;

public final class InternalProfileShardResults
implements Writeable<InternalProfileShardResults>,
ToXContent {
    private Map<String, List<ProfileShardResult>> shardResults;

    public InternalProfileShardResults(Map<String, List<ProfileShardResult>> shardResults) {
        for (Map.Entry<String, List<ProfileShardResult>> entry : shardResults.entrySet()) {
            List<ProfileShardResult> value = entry.getValue();
            if (value == null) continue;
            entry.setValue(Collections.unmodifiableList(value));
        }
        this.shardResults = Collections.unmodifiableMap(shardResults);
    }

    public InternalProfileShardResults(StreamInput in) throws IOException {
        int size = in.readInt();
        this.shardResults = new HashMap<String, List<ProfileShardResult>>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int shardResultsSize = in.readInt();
            ArrayList<ProfileShardResult> shardResult = new ArrayList<ProfileShardResult>(shardResultsSize);
            for (int j = 0; j < shardResultsSize; ++j) {
                ProfileShardResult result = new ProfileShardResult(in);
                shardResult.add(result);
            }
            this.shardResults.put(key, Collections.unmodifiableList(shardResult));
        }
        this.shardResults = Collections.unmodifiableMap(this.shardResults);
    }

    public Map<String, List<ProfileShardResult>> getShardResults() {
        return this.shardResults;
    }

    @Override
    public InternalProfileShardResults readFrom(StreamInput in) throws IOException {
        return new InternalProfileShardResults(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.shardResults.size());
        for (Map.Entry<String, List<ProfileShardResult>> entry : this.shardResults.entrySet()) {
            out.writeString(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (ProfileShardResult result : entry.getValue()) {
                result.writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("profile").startArray("shards");
        for (Map.Entry<String, List<ProfileShardResult>> entry : this.shardResults.entrySet()) {
            builder.startObject().field("id", entry.getKey()).startArray("searches");
            for (ProfileShardResult result : entry.getValue()) {
                builder.startObject();
                result.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray().endObject();
        }
        builder.endArray().endObject();
        return builder;
    }
}

