/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;

public class ReindexResponse
extends BulkIndexByScrollResponse {
    public ReindexResponse() {
    }

    public ReindexResponse(TimeValue took, BulkByScrollTask.Status status, List<BulkItemResponse.Failure> indexingFailures, List<ShardSearchFailure> searchFailures, boolean timedOut) {
        super(took, status, indexingFailures, searchFailures, timedOut);
    }

    public long getCreated() {
        return this.getStatus().getCreated();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("took", this.getTook().millis());
        builder.field("timed_out", this.isTimedOut());
        this.getStatus().innerXContent(builder, params, true, false);
        builder.startArray("failures");
        for (BulkItemResponse.Failure failure : this.getIndexingFailures()) {
            builder.startObject();
            failure.toXContent(builder, params);
            builder.endObject();
        }
        for (ShardSearchFailure shardSearchFailure : this.getSearchFailures()) {
            builder.startObject();
            shardSearchFailure.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReindexResponse[");
        builder.append("took=").append(this.getTook()).append(',');
        this.getStatus().innerToString(builder, true, false);
        builder.append(",indexing_failures=").append(this.getIndexingFailures().subList(0, Math.min(3, this.getIndexingFailures().size())));
        builder.append(",search_failures=").append(this.getSearchFailures().subList(0, Math.min(3, this.getSearchFailures().size())));
        return builder.append(']').toString();
    }
}

