/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import javax.json.JsonString;
import javax.json.JsonValue;

final class JsonStringImpl
implements JsonString {
    private final String value;

    JsonStringImpl(String string) {
        this.value = string;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public CharSequence getChars() {
        return this.value;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.STRING;
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JsonString)) {
            return false;
        }
        JsonString jsonString = (JsonString)object;
        return this.getString().equals(jsonString.getString());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        block8: for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c >= ' ' && c <= '\u10ffff' && c != '\"' && c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block8;
                }
                case '\b': {
                    stringBuilder.append('\\');
                    stringBuilder.append('b');
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append('\\');
                    stringBuilder.append('f');
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append('\\');
                    stringBuilder.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append('\\');
                    stringBuilder.append('r');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append('\\');
                    stringBuilder.append('t');
                    continue block8;
                }
                default: {
                    String string = "000" + Integer.toHexString(c);
                    stringBuilder.append("\\u").append(string.substring(string.length() - 4));
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

