/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MainPanel;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MainFrame
extends JFrame {
    private final transient OsmDataLayer.LayerStateChangeListener updateTitleOnLayerStateChange = new OsmDataLayer.LayerStateChangeListener(){

        @Override
        public void uploadDiscouragedChanged(OsmDataLayer osmDataLayer, boolean bl) {
            MainFrame.this.onLayerChange(osmDataLayer);
        }
    };
    private final transient PropertyChangeListener updateTitleOnSaveChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)propertyChangeEvent.getSource();
                MainFrame.this.onLayerChange(osmDataLayer);
            }
        }
    };
    protected transient WindowGeometry geometry;
    protected int windowState = 0;
    private MainMenu menu;

    public MainFrame() {
        this(new JPanel(), new MainPanel(Main.getLayerManager()), new WindowGeometry(new Rectangle(10, 10, 500, 500)));
    }

    public MainFrame(Container container, MainPanel mainPanel, WindowGeometry windowGeometry) {
        this.geometry = windowGeometry;
        this.setContentPane(container);
    }

    public void initialize() {
        this.menu = new MainMenu();
        this.addComponentListener(new WindowPositionSizeListener());
        this.addWindowStateListener(new WindowPositionSizeListener());
        this.setJMenuBar(this.menu);
        this.geometry.applySafe(this);
        LinkedList<Image> linkedList = new LinkedList<Image>();
        linkedList.add(ImageProvider.get("logo_16x16x32").getImage());
        linkedList.add(ImageProvider.get("logo_16x16x8").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x32").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x8").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x32").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x8").getImage());
        linkedList.add(ImageProvider.get("logo").getImage());
        this.setIconImages(linkedList);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main.exitJosm(true, 0);
            }
        });
        this.setDefaultCloseOperation(0);
        Main.getLayerManager().addActiveLayerChangeListener(new MainLayerManager.ActiveLayerChangeListener(){

            @Override
            public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
                MainFrame.this.refreshTitle();
            }
        });
        Main.getLayerManager().addLayerChangeListener(new ManageLayerListeners(), true);
        this.refreshTitle();
        this.getContentPane().add((Component)Main.panel, "Center");
        this.menu.initialize();
    }

    public void storeState() {
        if (this.geometry != null) {
            this.geometry.remember("gui.geometry");
        }
        Main.pref.put("gui.maximized", (this.windowState & 6) != 0);
    }

    public MainMenu getMenu() {
        if (this.menu == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return this.menu;
    }

    public void setMaximized(boolean bl) {
        if (bl) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                this.windowState = 6;
                this.setExtendedState(this.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        } else {
            throw new UnsupportedOperationException("Unimplemented.");
        }
    }

    public void refreshTitle() {
        OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
        boolean bl = osmDataLayer != null && (osmDataLayer.requiresSaveToFile() || osmDataLayer.requiresUploadToServer() && !osmDataLayer.isUploadDiscouraged());
        this.setTitle((bl ? "* " : "") + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        this.getRootPane().putClientProperty("Window.documentModified", bl);
    }

    private void onLayerChange(OsmDataLayer osmDataLayer) {
        if (osmDataLayer == Main.getLayerManager().getEditLayer()) {
            this.refreshTitle();
        }
    }

    private class WindowPositionSizeListener
    extends WindowAdapter
    implements ComponentListener {
        private WindowPositionSizeListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            MainFrame.this.windowState = windowEvent.getNewState();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        private void handleComponentEvent(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component instanceof JFrame && component.isVisible()) {
                if (MainFrame.this.windowState == 0) {
                    MainFrame.this.geometry = new WindowGeometry((JFrame)component);
                } else {
                    MainFrame.this.geometry.fixScreen((JFrame)component);
                }
            }
        }
    }

    private final class ManageLayerListeners
    implements LayerManager.LayerChangeListener {
        private ManageLayerListeners() {
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
            if (layerAddEvent.getAddedLayer() instanceof OsmDataLayer) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)layerAddEvent.getAddedLayer();
                osmDataLayer.addLayerStateChangeListener(MainFrame.this.updateTitleOnLayerStateChange);
            }
            layerAddEvent.getAddedLayer().addPropertyChangeListener(MainFrame.this.updateTitleOnSaveChange);
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
            if (layerRemoveEvent.getRemovedLayer() instanceof OsmDataLayer) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)layerRemoveEvent.getRemovedLayer();
                osmDataLayer.removeLayerStateChangeListener(MainFrame.this.updateTitleOnLayerStateChange);
            }
            layerRemoveEvent.getRemovedLayer().removePropertyChangeListener(MainFrame.this.updateTitleOnSaveChange);
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
        }
    }
}

