/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.math;

public class MathUtils {
    public static final double log(double base, double value) {
        if (base > 0.0 && base != 1.0 && value > 0.0) {
            return MathUtils.ln(value) / MathUtils.ln(base);
        }
        throw new IllegalArgumentException("base [" + base + "] or value [" + value + "] invalid");
    }

    public static final double lg(double value) {
        return MathUtils.log(10.0, value);
    }

    public static final double ld(double value) {
        return MathUtils.log(2.0, value);
    }

    public static final double ln(double value) {
        return Math.log(value);
    }

    public static final Double negate(Double value) {
        if (value == null) {
            return null;
        }
        if (value == 0.0) {
            return value;
        }
        return new Double(value * -1.0);
    }

    public static final Double abs(Double value) {
        if (value == null) {
            return null;
        }
        return new Double(Math.abs(value));
    }

    public static final double fix(double value, int accuracy) {
        if (accuracy < 0) {
            throw new IllegalArgumentException("accuracy must be >=0");
        }
        if (accuracy == 0) {
            return (long)value;
        }
        double factor = Math.pow(10.0, accuracy);
        return (double)((long)(value * factor)) / factor;
    }

    public static final double round(double value, int accuracy) {
        int i;
        if (accuracy < 0) {
            throw new IllegalArgumentException("accuracy must be >=0");
        }
        if (accuracy == 0) {
            return Math.round(value);
        }
        double val = value;
        for (i = 0; i < accuracy; ++i) {
            val *= 10.0;
        }
        val = (long)Math.floor(val + 0.5);
        for (i = 0; i < accuracy; ++i) {
            val /= 10.0;
        }
        return MathUtils.fix(val, accuracy);
    }

    public static final int compare(double value1, double value2) {
        if (Math.abs(value1 - value2) < 1.0E-7) {
            return 0;
        }
        if (value1 < value2) {
            return -1;
        }
        return 1;
    }

    public static final Double sum(Double value1, Double value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new Double(value1 + value2);
    }
}

