/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Map;

public class ScaleMapSizeDialog
extends FreeColDialog<Dimension> {
    private static final int COLUMNS = 5;
    final Map oldMap;
    final JTextField inputWidth;
    final JTextField inputHeight;

    public ScaleMapSizeDialog(FreeColClient freeColClient, JFrame frame) {
        super(freeColClient, frame);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, center"));
        JPanel widthPanel = new JPanel(new FlowLayout());
        JPanel heightPanel = new JPanel(new FlowLayout());
        this.oldMap = freeColClient.getGame().getMap();
        String str = Integer.toString(this.oldMap.getWidth());
        this.inputWidth = new JTextField(str, 5);
        str = Integer.toString(this.oldMap.getHeight());
        this.inputHeight = new JTextField(str, 5);
        JLabel widthLabel = Utility.localizedLabel("width");
        widthLabel.setLabelFor(this.inputWidth);
        JLabel heightLabel = Utility.localizedLabel("height");
        heightLabel.setLabelFor(this.inputHeight);
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(this.inputWidth);
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(this.inputHeight);
        panel.add(widthPanel);
        panel.add(heightPanel);
        panel.setSize(panel.getPreferredSize());
        ActionListener al = ae -> this.checkFields();
        this.inputWidth.addActionListener(al);
        this.inputHeight.addActionListener(al);
        Object fake = null;
        List c = ScaleMapSizeDialog.choices();
        c.add(new ChoiceItem<Object>(Messages.message("ok"), fake).okOption());
        c.add(new ChoiceItem<Object>(Messages.message("cancel"), fake).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, null, c);
    }

    private void checkFields() {
        try {
            int w = Integer.parseInt(this.inputWidth.getText());
            if (w <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.inputWidth.setText(Integer.toString(this.oldMap.getWidth()));
        }
        try {
            int h = Integer.parseInt(this.inputHeight.getText());
            if (h <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.inputHeight.setText(Integer.toString(this.oldMap.getHeight()));
        }
    }

    @Override
    public Dimension getResponse() {
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            this.checkFields();
            return new Dimension(Integer.parseInt(this.inputHeight.getText()), Integer.parseInt(this.inputWidth.getText()));
        }
        return null;
    }

    @Override
    public void requestFocus() {
        this.inputWidth.requestFocus();
    }
}

