/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Cargo;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.Mission;

public class TransportMission
extends Mission {
    private static final Logger logger = Logger.getLogger(TransportMission.class.getName());
    private static final String tag = "AI transport";
    private static final int DESTINATION_UPPER_BOUND = 4;
    private static final int MINIMUM_GOLD_TO_STAY_IN_EUROPE = 600;
    private final List<Cargo> cargoes = new ArrayList<Cargo>();
    private Location target;
    private static final String TARGET_TAG = "target";
    private static final String OLD_TRANSPORTABLE_TAG = "transportable";

    public TransportMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit, aiUnit.getTrivialTarget());
    }

    public TransportMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    @Override
    public void dispose() {
        logger.finest("AI transport disposing (" + this.clearCargoes() + "): " + this);
        super.dispose();
    }

    private boolean isCarrying(TransportableAIObject t) {
        return t != null && t.getLocation() == this.getUnit();
    }

    public boolean isTransporting(TransportableAIObject t) {
        return this.tFind(t) != null;
    }

    private boolean shouldAttack(Unit other) {
        if (TransportMission.invalidAttackReason(this.getAIUnit(), other.getOwner()) != null) {
            return false;
        }
        Unit carrier = this.getUnit();
        CombatModel cm = this.getGame().getCombatModel();
        double offence = cm.getOffencePower(carrier, other) * (carrier.hasCargo() ? 0.3 : 0.8);
        return offence > cm.getOffencePower(other, carrier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cargo> tCopy() {
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            return new ArrayList<Cargo>(this.cargoes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cargo> tClear() {
        ArrayList<Cargo> old = new ArrayList<Cargo>();
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            old.addAll(this.cargoes);
            this.cargoes.clear();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cargo> tSet(List<Cargo> nxt, boolean setSpace) {
        List<Cargo> old = this.tCopy();
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            this.cargoes.clear();
            for (Cargo c : nxt) {
                if (!c.isValid()) continue;
                this.cargoes.add(c);
            }
            if (setSpace) {
                this.tSpace();
            }
        }
        this.tRetarget();
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tSize() {
        int size;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            size = this.cargoes.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cargo tFind(TransportableAIObject t) {
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            return CollectionUtils.find(this.cargoes, c -> c.getTransportable() == t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cargo tFirst() {
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            return CollectionUtils.find(this.cargoes, Cargo::isValid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tAdd(Cargo cargo, int index) {
        if (!cargo.isValid()) {
            return false;
        }
        if (this.tFind(cargo.getTransportable()) != null) {
            return true;
        }
        boolean change = false;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            boolean bl = change = this.cargoes.isEmpty() || index == 0;
            if (index >= 0) {
                this.cargoes.add(index, cargo);
            } else {
                this.cargoes.add(cargo);
            }
            this.tSpace();
        }
        if (change) {
            this.tRetarget();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tRemove(Cargo cargo) {
        boolean result = false;
        boolean change = false;
        TransportableAIObject t = cargo.getTransportable();
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            for (int i = 0; i < this.cargoes.size(); ++i) {
                if (this.cargoes.get(i).getTransportable() != t) continue;
                this.cargoes.remove(i);
                this.tSpace();
                change = i == 0;
                result = true;
                break;
            }
        }
        if (change) {
            this.tRetarget();
        }
        return result;
    }

    private void tSpace() {
        Unit carrier = this.getUnit();
        int maxHolds = carrier.getCargoCapacity();
        int holds = carrier.getCargoSpaceTaken();
        for (Cargo cargo : this.cargoes) {
            if (!cargo.isValid()) continue;
            cargo.setSpaceLeft(maxHolds - (holds += cargo.getNewSpace()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tRetarget() {
        Cargo c;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            c = CollectionUtils.find(this.cargoes, Cargo::isValid);
        }
        this.setTarget(Location.upLoc(c == null ? this.getAIUnit().getTrivialTarget() : c.getCarrierTarget()));
    }

    private int destinationCount() {
        Location now = null;
        int ret = 0;
        for (Cargo cargo : this.tCopy()) {
            if (Map.isSameLocation(now, cargo.getCarrierTarget())) continue;
            ++ret;
            now = cargo.getCarrierTarget();
        }
        return ret;
    }

    public int destinationCapacity() {
        return 4 - this.destinationCount();
    }

    private void dropTransportable(TransportableAIObject t) {
        AIUnit carrier = this.getAIUnit();
        if (t.getTransport() == carrier) {
            t.setTransport(null);
        }
    }

    private void takeTransportable(TransportableAIObject t) {
        AIUnit carrier = this.getAIUnit();
        if (t.getTransport() != carrier) {
            t.setTransport(carrier);
        }
    }

    public Location getTransportTarget(TransportableAIObject t) {
        if (this.isCarrying(t)) {
            return null;
        }
        Cargo cargo = this.tFind(t);
        return cargo == null ? null : cargo.getTransportTarget();
    }

    public int getTransportTurns(TransportableAIObject t) {
        if (this.isCarrying(t)) {
            return Integer.MAX_VALUE;
        }
        Cargo cargo = this.tFind(t);
        return cargo == null ? Integer.MAX_VALUE : cargo.getTurns();
    }

    private List<Cargo> wrapCargoes() {
        List<Cargo> ts = this.tCopy();
        for (int i = 0; i < ts.size() - 1; ++i) {
            Cargo head = ts.get(i);
            while (i + 1 < ts.size() && head.couldWrap(ts.get(i + 1))) {
                head.wrap(ts.remove(i + 1));
            }
        }
        return ts;
    }

    private List<Cargo> unwrapCargoes(List<Cargo> ts) {
        for (int i = 0; i < ts.size(); ++i) {
            Cargo t = ts.get(i);
            if (!t.hasWrapped()) continue;
            List<Cargo> tl = t.unwrap();
            ts.addAll(i + 1, tl);
            i += tl.size();
        }
        return ts;
    }

    private String clearCargoes() {
        String log = "cargoes cleared: ";
        for (Cargo cargo : this.tClear()) {
            this.dropTransportable(cargo.getTransportable());
            log = log + " " + cargo;
        }
        this.tRetarget();
        return log;
    }

    public boolean isEmpty() {
        return this.tSize() == 0;
    }

    public Cargo makeCargo(TransportableAIObject t, LogBuilder lb) {
        String reason;
        Unit carrier = this.getUnit();
        Cargo cargo = null;
        if (t.getTransportDestination() == null) {
            if (!this.isCarrying(t)) {
                reason = "null transport destination";
            } else {
                PathNode path = carrier.getTrivialPath();
                if (path == null) {
                    reason = "null transport destination";
                } else {
                    try {
                        reason = null;
                        cargo = Cargo.newCargo(t, carrier, path.getLastNode().getLocation(), true);
                    }
                    catch (FreeColException fce) {
                        reason = fce.getMessage();
                        cargo = null;
                    }
                }
            }
        } else if (!this.isCarrying(t) && !t.carriableBy(carrier)) {
            reason = "carrier " + carrier.toShortString() + " can not carry";
        } else {
            try {
                reason = null;
                cargo = Cargo.newCargo(t, carrier);
            }
            catch (FreeColException fce) {
                reason = fce.getMessage();
                cargo = null;
            }
        }
        if (reason == null) {
            lb.add(", made ", cargo.toShortString());
            return cargo;
        }
        lb.add(", failed to make cargo for ", t, " (", reason, ")");
        return null;
    }

    private boolean addCargo(Cargo cargo, int index, LogBuilder lb) {
        boolean result = this.tAdd(cargo, index);
        if (result) {
            this.takeTransportable(cargo.getTransportable());
        }
        if (result) {
            lb.add(", added ", cargo.toShortString(), " at ", index < 0 ? "end" : Integer.toString(index));
        } else {
            lb.add(", failed to add ", cargo.toShortString());
        }
        return result;
    }

    private void removeCargo(Cargo cargo) {
        if (!this.tRemove(cargo)) {
            throw new RuntimeException("removeCargo " + cargo.toShortString());
        }
        this.dropTransportable(cargo.getTransportable());
    }

    public boolean spaceAvailable(Cargo cargo) {
        return this.spaceAvailable(cargo.getTransportable());
    }

    public boolean spaceAvailable(TransportableAIObject t) {
        List<Cargo> ts = this.tCopy();
        int newSpace = t.getSpaceTaken();
        for (int i = ts.size() - 1; i >= 0; --i) {
            if (ts.get(i).getSpaceLeft() >= newSpace) continue;
            return false;
        }
        return true;
    }

    private boolean queueCargo(Cargo cargo, boolean requireMatch, LogBuilder lb) {
        Unit carrier = this.getUnit();
        int maxHolds = carrier.getCargoCapacity();
        List<Cargo> ts = this.tCopy();
        int newSpace = cargo.getNewSpace();
        int candidate = -1;
        if (ts.isEmpty() || Map.isSameLocation(carrier.getLocation(), cargo.getCarrierTarget()) && cargo.canQueueAt(carrier, 0, ts)) {
            candidate = 0;
        }
        if (candidate < 0) {
            for (int i = 0; i < ts.size(); ++i) {
                Cargo tr = ts.get(i);
                if (!Map.isSameLocation(tr.getCarrierTarget(), cargo.getCarrierTarget()) || !cargo.canQueueAt(carrier, i, ts)) continue;
                candidate = i;
                break;
            }
        }
        if (candidate < 0) {
            if (requireMatch) {
                return false;
            }
            candidate = ts.size();
        }
        return this.addCargo(cargo, candidate, lb);
    }

    public boolean dumpCargo(Cargo cargo, LogBuilder lb) {
        TransportableAIObject t = cargo.getTransportable();
        if (this.isCarrying(t)) {
            t.leaveTransport();
        }
        if (!this.isCarrying(t) && this.tFind(t) != null) {
            this.removeCargo(cargo);
        }
        if (this.tFind(t) != null) {
            String reason = cargo.dump();
            if (reason != null) {
                lb.add(", dump failed(", reason, ")");
                return false;
            }
            lb.add(", dumping");
        }
        return true;
    }

    public boolean requeueCargo(Cargo cargo, LogBuilder lb) {
        TransportableAIObject t = cargo.getTransportable();
        boolean ret = false;
        assert (this.tFind(t) == cargo);
        String reason = cargo.update();
        if (reason != null) {
            lb.add(" requeue/update fail(", reason, ") ", cargo.toShortString());
            this.dumpCargo(cargo, lb);
        } else if (!this.tRemove(cargo)) {
            lb.add(" requeue/remove fail ", cargo.toShortString());
        } else if (!this.queueCargo(cargo, false, lb)) {
            lb.add(" requeue/queue fail ", cargo.toShortString());
            this.dropTransportable(t);
        } else {
            lb.add(" requeued(", cargo.getTransportTarget(), ") ", cargo.toShortString());
            this.takeTransportable(t);
            ret = true;
        }
        return ret;
    }

    private void checkCargoes(LogBuilder lb) {
        Unit carrier = this.getUnit();
        if (carrier.isAtSea()) {
            return;
        }
        AIUnit aiCarrier = this.getAIUnit();
        List<Unit> unitsPresent = carrier.getUnitList();
        List<Goods> goodsPresent = carrier.getCompactGoods();
        ArrayList<TransportableAIObject> todo = new ArrayList<TransportableAIObject>();
        ArrayList<TransportableAIObject> drop = new ArrayList<TransportableAIObject>();
        lb.add(" [check");
        block2: for (Cargo cargo : this.tCopy()) {
            Goods goods;
            boolean dump = false;
            TransportableAIObject t = cargo.getTransportable();
            String reason = TransportMission.invalidReason(aiCarrier, cargo.getCarrierTarget());
            if (reason != null || (reason = cargo.check(aiCarrier)) != null) {
                this.removeCargo(cargo);
                lb.add(", INVALID(", reason, ") ", cargo.toShortString());
            } else if (cargo.isDelivered()) {
                this.removeCargo(cargo);
                lb.add(", COMPLETED ", cargo.toShortString());
            } else if (!cargo.hasPath() && !cargo.retry()) {
                reason = " no-path";
                dump = true;
            } else if (carrier.hasTile() && (reason = cargo.update()) != null) {
                if (reason.startsWith("invalid")) {
                    this.removeCargo(cargo);
                    lb.add(", FAIL(", reason, ") ", cargo.toShortString());
                } else if (cargo.retry()) {
                    lb.add(", retry-", cargo.getTries(), "(", reason, ")");
                } else {
                    dump = true;
                }
            } else if (cargo.isCollectable()) {
                lb.add(", collect ", cargo.toShortString());
            } else if (cargo.isDeliverable()) {
                lb.add(", deliver ", cargo.toShortString());
            } else {
                lb.add(", ok ", cargo.toShortString());
                cargo.resetTries();
            }
            if (dump) {
                if (cargo.isCarried()) {
                    this.dumpCargo(cargo, lb);
                } else {
                    this.removeCargo(cargo);
                    lb.add(", dropped(", reason, ") ", cargo.toShortString());
                }
            }
            if (t instanceof AIUnit) {
                unitsPresent.remove(((AIUnit)t).getUnit());
                continue;
            }
            if (!(t instanceof AIGoods) || (goods = ((AIGoods)t).getGoods()) == null) continue;
            Iterator<Goods> gi = goodsPresent.iterator();
            while (gi.hasNext()) {
                Goods g = gi.next();
                if (g.getType() != goods.getType()) continue;
                gi.remove();
                continue block2;
            }
        }
        if (!unitsPresent.isEmpty()) {
            lb.add(", found unexpected units");
            for (Unit u : unitsPresent) {
                AIUnit aiu = this.getAIMain().getAIUnit(u);
                if (aiu == null) {
                    throw new IllegalStateException("Bogus:" + u);
                }
                todo.add(aiu);
            }
        }
        if (!goodsPresent.isEmpty()) {
            lb.add(", found unexpected goods");
            for (Goods g : goodsPresent) {
                AIGoods aig = new AIGoods(this.getAIMain(), carrier, g.getType(), g.getAmount(), null);
                todo.add(aig);
            }
        }
        while (!todo.isEmpty()) {
            TransportableAIObject t = (TransportableAIObject)todo.remove(0);
            if (this.queueTransportable(t, false, lb)) continue;
            drop.add(t);
        }
        if (!drop.isEmpty()) {
            Location end;
            PathNode path = carrier.getTrivialPath();
            Location location = end = path == null ? null : path.getLastNode().getLocation();
            while (!drop.isEmpty()) {
                TransportableAIObject t = (TransportableAIObject)drop.remove(0);
                if (t.leaveTransport()) {
                    lb.add(" ", t, " left");
                    continue;
                }
                if (end != null) {
                    try {
                        Cargo cargo = Cargo.newCargo(t, carrier, end, false);
                        boolean result = this.queueCargo(cargo, false, lb);
                        lb.add(" to drop at ", Location.upLoc(end), "=", result);
                    }
                    catch (FreeColException fce) {
                        lb.add(" ", t, " drop-fail(", fce.getMessage(), ")");
                    }
                    continue;
                }
                lb.add(" ", t, " stuck");
            }
        }
        lb.add("]");
    }

    private CargoResult tryCargo(Cargo cargo, LogBuilder lb) {
        AIColony aiColony;
        Colony colony;
        Unit carrier = this.getUnit();
        Location here = carrier.getLocation();
        TransportableAIObject t = cargo.getTransportable();
        Locatable l = t.getTransportLocatable();
        if (l == null) {
            logger.warning("Null-locatable: " + cargo);
            return CargoResult.TDONE;
        }
        if (!Map.isSameLocation(here, cargo.getCarrierTarget())) {
            lb.add(", ", t, " unready");
            return CargoResult.TCONTINUE;
        }
        Direction d = null;
        Location tloc = here;
        switch (cargo.getMode()) {
            case PICKUP: {
                if (!t.canMove()) {
                    lb.add(", ", t, " out of moves");
                    return CargoResult.TCONTINUE;
                }
                d = cargo.getJoinDirection();
                if (d == null) {
                    logger.warning("Null pickup direction for " + cargo.toShortString() + " at " + t.getLocation().toString() + " to " + carrier);
                    return CargoResult.TFAIL;
                }
                tloc = tloc.getTile().getNeighbourOrNull(d.getReverseDirection());
            }
            case LOAD: {
                String reason;
                if (!Map.isSameLocation(tloc, t.getLocation())) {
                    lb.add(", ", t, " at ", t.getLocation(), " not ", tloc, " # ", cargo.toShortString());
                    return CargoResult.TCONTINUE;
                }
                switch (carrier.getNoAddReason(l)) {
                    case NONE: {
                        if (t.joinTransport(carrier, d)) break;
                        lb.add(", ", t, " NO-JOIN");
                        return CargoResult.TFAIL;
                    }
                    case ALREADY_PRESENT: {
                        break;
                    }
                    case CAPACITY_EXCEEDED: {
                        lb.add(", ", t, " NO-ROOM on ", carrier);
                        return CargoResult.TFAIL;
                    }
                    default: {
                        lb.add(new Object[]{", ", t, " retry-", carrier.getNoAddReason(l)});
                        return CargoResult.TRETRY;
                    }
                }
                if ((reason = cargo.update()) != null) {
                    lb.add(", ", t, " NO-UPDATE(", reason, ")");
                    return CargoResult.TFAIL;
                }
                lb.add(", ", t, " collected");
                return CargoResult.TNEXT;
            }
            case DROPOFF: {
                if (!t.canMove()) {
                    lb.add(", ", t, " about to leave");
                    return CargoResult.TCONTINUE;
                }
                d = cargo.getLeaveDirection();
                if (d == null) {
                    Unit.MoveType mt = ((AIUnit)t).getUnit().getSimpleMoveType(t.getLocation().getTile(), cargo.getTransportTarget().getTile());
                    switch (mt) {
                        case ATTACK_UNIT: 
                        case MOVE_NO_ATTACK_CIVILIAN: {
                            return CargoResult.TRETRY;
                        }
                    }
                    PathNode path = t.getDeliveryPath(carrier, cargo.getTransportTarget());
                    logger.warning("Null direction for " + cargo.toShortString() + " at " + t.getLocation().toShortString() + "/" + carrier.getLocation().toShortString() + " to " + cargo.getTransportTarget() + " mov=" + (Object)((Object)mt) + " path=" + (path == null ? "null" : path.fullPathToString()));
                    return CargoResult.TFAIL;
                }
            }
            case UNLOAD: {
                if (this.isCarrying(t) && !t.leaveTransport(d)) {
                    PathNode pn = t.getDeliveryPath(carrier, t.getTransportDestination());
                    lb.add(", ", t, " NO-LEAVE(", here, "~", cargo.getLeaveDirection(), "~", t.getTransportDestination(), " ", pn == null ? "no-path" : pn.fullPathToString());
                    return CargoResult.TRETRY;
                }
                lb.add(", ", t, " COMPLETED");
                break;
            }
            case DUMP: {
                if (!t.leaveTransport()) {
                    lb.add(", ", t, " STUCK");
                    return CargoResult.TCONTINUE;
                }
                lb.add(", ", t, " DUMPED at ", t.getLocation());
            }
        }
        if ((colony = t.getLocation() == null ? null : t.getLocation().getColony()) != null && (aiColony = this.getAIMain().getAIColony(colony)) != null && aiColony.completeWish(t, lb)) {
            aiColony.requestRearrange();
        }
        return CargoResult.TDONE;
    }

    private void doTransport(LogBuilder lb) {
        Cargo cargo;
        Unit unit = this.getUnit();
        if (this.tSize() > 0) {
            CargoResult result;
            this.lbAt(lb);
            lb.add(", delivering");
            ArrayList<Cargo> cont = new ArrayList<Cargo>();
            ArrayList<Cargo> next = new ArrayList<Cargo>();
            List<Cargo> curr = this.tClear();
            block12: for (Cargo cargo2 : curr) {
                result = cargo2.getMode().isCollection() ? CargoResult.TCONTINUE : this.tryCargo(cargo2, lb);
                switch (result) {
                    case TCONTINUE: {
                        cont.add(cargo2);
                        continue block12;
                    }
                    case TRETRY: {
                        if (cargo2.retry()) {
                            cont.add(cargo2);
                            continue block12;
                        }
                    }
                    case TFAIL: {
                        if (cargo2.isCarried()) {
                            cargo2.dump();
                            continue block12;
                        }
                    }
                    case TDONE: {
                        this.dropTransportable(cargo2.getTransportable());
                        cargo2.clear();
                        continue block12;
                    }
                }
                throw new IllegalStateException("Can not happen");
            }
            curr.clear();
            this.tSet(cont, true);
            lb.add(", collecting");
            cont.clear();
            block13: for (Cargo cargo2 : this.tClear()) {
                result = cargo2.getMode().isCollection() ? this.tryCargo(cargo2, lb) : CargoResult.TCONTINUE;
                switch (result) {
                    case TCONTINUE: {
                        cont.add(cargo2);
                        continue block13;
                    }
                    case TNEXT: {
                        cont.add(cargo2);
                        continue block13;
                    }
                    case TRETRY: {
                        if (cargo2.retry()) {
                            next.add(cargo2);
                            continue block13;
                        }
                    }
                    case TFAIL: 
                    case TDONE: {
                        this.dropTransportable(cargo2.getTransportable());
                        cargo2.clear();
                        continue block13;
                    }
                }
                throw new IllegalStateException("Can not happen");
            }
            this.tSet(cont, true);
            if (!next.isEmpty()) {
                lb.add(", requeue");
                for (Cargo c : next) {
                    this.queueCargo(c, false, lb);
                }
            }
            this.checkCargoes(lb);
            this.optimizeCargoes(lb);
        }
        EuropeanAIPlayer euaip = this.getEuropeanAIPlayer();
        while (this.destinationCapacity() > 0 && this.tSize() < unit.getCargoCapacity() * 3 / 2 && (cargo = this.getBestCargo(unit)) != null && this.queueCargo(cargo, false, lb)) {
            euaip.claimTransportable(cargo.getTransportable());
        }
    }

    private float scoreCargoOrder(Location initialLocation, List<Cargo> order) {
        Unit carrier = this.getUnit();
        int maxHolds = carrier.getCargoCapacity();
        int holds = carrier.getCargoSpaceTaken();
        Location now = initialLocation;
        float totalHoldTurns = 0.0f;
        float totalTurns = 0.0f;
        float favourEarly = 1.0f;
        for (Cargo cargo : order) {
            int turns = carrier.getTurnsToReach(now, cargo.getCarrierTarget());
            totalTurns += (float)turns;
            totalHoldTurns += (float)(holds * turns) * favourEarly;
            if ((holds += cargo.getNewSpace()) < 0 || holds > maxHolds) {
                return -1.0f;
            }
            now = cargo.getCarrierTarget();
            favourEarly += 0.1f;
        }
        return totalTurns + 0.001f * totalHoldTurns;
    }

    private void optimizeCargoes(LogBuilder lb) {
        lb.add(", optimize");
        Location oldTarget = this.getTarget();
        List<Cargo> ts = this.wrapCargoes();
        List<Cargo> best = null;
        if (1 < ts.size() && ts.size() <= 4) {
            Location current = this.getUnit().getLocation();
            float bestValue = 2.1474836E9f;
            for (List<Cargo> tl : CollectionUtils.getPermutations(ts)) {
                float value = this.scoreCargoOrder(current, tl);
                if (!(value > 0.0f) || !(bestValue > value)) continue;
                bestValue = value;
                best = tl;
            }
        }
        if (best != null) {
            this.tSet(this.unwrapCargoes(best), true);
            if (oldTarget != this.getTarget()) {
                lb.add("->", this.getTarget());
            }
        } else {
            this.tSet(this.unwrapCargoes(ts), false);
        }
    }

    private Cargo getBestCargo(Unit carrier) {
        EuropeanAIPlayer euaip = this.getEuropeanAIPlayer();
        Cargo bestDirect = null;
        Cargo bestFallback = null;
        float bestDirectValue = 0.0f;
        float bestFallbackValue = 0.0f;
        for (TransportableAIObject t : euaip.getUrgentTransportables()) {
            Cargo cargo;
            if (t.isDisposed() || !t.carriableBy(carrier)) continue;
            Location loc = t.getTransportSource();
            try {
                cargo = Cargo.newCargo(t, carrier);
            }
            catch (FreeColException fce) {
                cargo = null;
            }
            if (cargo == null) continue;
            float value = (float)t.getTransportPriority() / ((float)cargo.getTurns() + 1.0f);
            if (cargo.isFallback()) {
                if (!(bestFallbackValue < value)) continue;
                bestFallbackValue = value;
                bestFallback = cargo;
                continue;
            }
            if (!(bestDirectValue < value)) continue;
            bestDirectValue = value;
            bestDirect = cargo;
        }
        return bestDirect != null ? bestDirect : (bestFallback != null ? bestFallback : null);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = TransportMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isCarrier() ? "unit-not-a-carrier" : null);
    }

    private static String invalidCargoReason(Cargo cargo) {
        String reason;
        TransportableAIObject t = cargo.getTransportable();
        return t == null ? "null-transportable" : ((reason = t.invalidReason()) != null ? "cargo-" + reason : null);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = TransportMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Tile ? null : (loc instanceof Europe || loc instanceof Colony ? TransportMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner()) : "target-invalid"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return TransportMission.invalidMissionReason(aiUnit);
    }

    public boolean removeTransportable(TransportableAIObject t) {
        Cargo cargo = this.tFind(t);
        return cargo == null ? false : this.tRemove(cargo);
    }

    public boolean requeueTransportable(TransportableAIObject t, LogBuilder lb) {
        Cargo cargo = this.tFind(t);
        return cargo == null ? this.queueTransportable(t, false, lb) : this.requeueCargo(cargo, lb);
    }

    public boolean queueTransportable(TransportableAIObject t, boolean requireMatch, LogBuilder lb) {
        Cargo cargo = this.makeCargo(t, lb);
        return cargo == null ? false : this.queueCargo(cargo, requireMatch, lb);
    }

    public boolean dumpTransportable(TransportableAIObject t, LogBuilder lb) {
        if (t == null) {
            return true;
        }
        Cargo cargo = this.tFind(t);
        if (cargo == null) {
            return true;
        }
        if (!this.isCarrying(t)) {
            this.removeTransportable(t);
            return true;
        }
        return this.dumpCargo(cargo, lb);
    }

    public boolean forceCollection(AIUnit aiu, LogBuilder lb) {
        for (Cargo c : this.tCopy()) {
            if (!c.getMode().isCollection()) continue;
            this.removeCargo(c);
        }
        return this.queueTransportable(aiu, false, lb);
    }

    public void suppressEuropeanTrade(GoodsType type, LogBuilder lb) {
        for (Cargo c : this.tCopy()) {
            if (!c.isEuropeanTrade(type)) continue;
            this.removeCargo(c);
        }
    }

    @Override
    public Tile getTransportDestination() {
        return null;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        this.target = target;
    }

    @Override
    public Location findTarget() {
        return null;
    }

    @Override
    public String invalidReason() {
        Cargo cargo;
        AIUnit aiUnit = this.getAIUnit();
        String reason = TransportMission.invalidReason(aiUnit, this.getTarget());
        return reason != null ? reason : ((cargo = this.tFirst()) == null ? null : TransportMission.invalidCargoReason(cargo));
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        Unit.MoveType mt;
        lb.add(tag);
        this.checkCargoes(lb);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        AIUnit aiCarrier = this.getAIUnit();
        Unit unit = this.getUnit();
        CostDecider fallBackDecider = CostDeciders.avoidSettlementsAndBlockingUnits();
        EuropeanAIPlayer euaip = this.getEuropeanAIPlayer();
        CostDecider costDecider = CostDeciders.defaultCostDeciderFor(unit);
        block7: while (true) {
            mt = this.travelToTarget(this.target, costDecider, lb);
            switch (mt) {
                case MOVE: {
                    Mission m;
                    this.doTransport(lb);
                    if (this.isEmpty() && unit.isOffensiveUnit() && (m = euaip.getPrivateerMission(aiCarrier, null)) != null) {
                        return this.lbDone(lb, false, "going pirate");
                    }
                    reason = this.invalidReason();
                    if (reason != null) {
                        logger.warning("AI transport post-stop failure(" + reason + "): " + this.toFullString());
                        return this.lbFail(lb, false, reason);
                    }
                    if (!unit.isAtLocation(this.target)) continue block7;
                    return this.lbWait(lb, ", waiting at ", this.target);
                }
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_MOVES: 
                case MOVE_NO_REPAIR: 
                case MOVE_ILLEGAL: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_TILE: {
                    this.moveRandomly(tag, null);
                    return this.lbDodge(lb);
                }
                case ATTACK_UNIT: {
                    Location blocker = TransportMission.resolveBlockage(aiCarrier, this.target);
                    if (blocker instanceof Unit && this.shouldAttack((Unit)blocker)) {
                        AIMessage.askAttack(aiCarrier, unit.getTile().getDirection(blocker.getTile()));
                        return this.lbAttack(lb, blocker);
                    }
                }
                case MOVE_NO_ATTACK_CIVILIAN: {
                    if (unit.getTile().isAdjacent(this.target.getTile()) || costDecider == fallBackDecider) {
                        this.moveRandomly(tag, null);
                        return this.lbDodge(lb);
                    }
                    costDecider = fallBackDecider;
                    lb.add(", retry blockage at ", unit.getLocation());
                    continue block7;
                }
            }
            break;
        }
        return this.lbMove(lb, mt);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeLocationAttribute(TARGET_TAG, this.target);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        AIUnit aiCarrier = this.getAIUnit();
        for (Cargo cargo : this.tCopy()) {
            String reason = cargo.check(aiCarrier);
            if (reason != null || cargo.getMode() == Cargo.CargoMode.DUMP) continue;
            cargo.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.tClear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (Cargo.getXMLElementTagName().equals(tag)) {
            this.tAdd(new Cargo(this.getAIMain(), xr), -1);
        } else if (OLD_TRANSPORTABLE_TAG.equals(tag)) {
            xr.closeTag(OLD_TRANSPORTABLE_TAG);
        } else {
            super.readChild(xr);
        }
    }

    public String toFullString() {
        LogBuilder lb = new LogBuilder(64);
        lb.add(this);
        for (Cargo cargo : this.tCopy()) {
            lb.add("\n  ->", cargo);
        }
        return lb.toString();
    }

    @Override
    public String getXMLTagName() {
        return TransportMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "transportMission";
    }

    private static enum CargoResult {
        TCONTINUE,
        TDONE,
        TFAIL,
        TNEXT,
        TRETRY;

    }
}

