/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import java.util.ArrayList;
import jogamp.graph.curve.tess.GraphOutline;
import jogamp.graph.curve.tess.GraphVertex;
import jogamp.graph.curve.tess.Loop;
import jogamp.opengl.Debug;

public class CDTriangulator2D
implements Triangulator {
    protected static final boolean DEBUG = Debug.debug("Triangulation");
    private float sharpness = 0.5f;
    private ArrayList<Loop> loops;
    private ArrayList<Vertex> vertices;
    private ArrayList<Triangle> triangles;
    private int maxTriID = 0;

    public CDTriangulator2D() {
        this.reset();
    }

    @Override
    public void reset() {
        this.maxTriID = 0;
        this.vertices = new ArrayList();
        this.triangles = new ArrayList(3);
        this.loops = new ArrayList();
    }

    @Override
    public void addCurve(Outline outline) {
        Loop loop = null;
        if (!this.loops.isEmpty()) {
            loop = this.getContainerLoop(outline);
        }
        if (loop == null) {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline2 = this.extractBoundaryTriangles(graphOutline, false);
            this.vertices.addAll(outline.getVertices());
            loop = new Loop(graphOutline2, VectorUtil.Winding.CCW);
            this.loops.add(loop);
        } else {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline3 = this.extractBoundaryTriangles(graphOutline, true);
            this.vertices.addAll(graphOutline3.getVertices());
            loop.addConstraintCurve(graphOutline3);
        }
    }

    @Override
    public ArrayList<Triangle> generate() {
        for (int i = 0; i < this.loops.size(); ++i) {
            Triangle triangle;
            Loop loop = this.loops.get(i);
            int n = 0;
            int n2 = loop.computeLoopSize();
            while (!loop.isSimplex()) {
                triangle = null;
                triangle = n > n2 ? loop.cut(false) : loop.cut(true);
                ++n;
                if (triangle != null) {
                    n = 0;
                    --n2;
                    triangle.setId(this.maxTriID++);
                    this.triangles.add(triangle);
                    if (DEBUG) {
                        System.err.println(triangle);
                    }
                }
                if (n <= n2 * 2) continue;
                if (!DEBUG) break;
                System.err.println("Triangulation not complete!");
                break;
            }
            if ((triangle = loop.cut(true)) == null) continue;
            this.triangles.add(triangle);
        }
        return this.triangles;
    }

    private GraphOutline extractBoundaryTriangles(GraphOutline graphOutline, boolean bl) {
        GraphOutline graphOutline2 = new GraphOutline();
        ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            GraphVertex graphVertex = arrayList.get(i);
            GraphVertex graphVertex2 = arrayList.get((i + n - 1) % n);
            GraphVertex graphVertex3 = arrayList.get((i + 1) % n);
            GraphVertex graphVertex4 = graphVertex;
            if (!graphVertex.getPoint().isOnCurve()) {
                Triangle triangle;
                boolean bl2;
                Vertex vertex = graphVertex2.getPoint().clone();
                Vertex vertex2 = graphVertex3.getPoint().clone();
                Vertex vertex3 = graphVertex4.getPoint().clone();
                graphVertex2.setBoundaryContained(true);
                graphVertex4.setBoundaryContained(true);
                graphVertex3.setBoundaryContained(true);
                if (VectorUtil.ccw(vertex, vertex3, vertex2)) {
                    bl2 = false;
                    triangle = new Triangle(vertex, vertex3, vertex2);
                } else {
                    bl2 = true;
                    triangle = new Triangle(vertex2, vertex3, vertex);
                }
                triangle.setId(this.maxTriID++);
                this.triangles.add(triangle);
                if (DEBUG) {
                    System.err.println(triangle);
                }
                if (bl || bl2) {
                    vertex.setTexCoord(0.0f, -0.1f);
                    vertex2.setTexCoord(1.0f, -0.1f);
                    vertex3.setTexCoord(0.5f, -1.0f * this.sharpness - 0.1f);
                    graphOutline2.addVertex(graphVertex);
                    continue;
                }
                vertex.setTexCoord(0.0f, 0.1f);
                vertex2.setTexCoord(1.0f, 0.1f);
                vertex3.setTexCoord(0.5f, this.sharpness + 0.1f);
                continue;
            }
            if (!graphVertex3.getPoint().isOnCurve() || !graphVertex2.getPoint().isOnCurve()) {
                graphVertex.setBoundaryContained(true);
            }
            graphOutline2.addVertex(graphVertex);
        }
        return graphOutline2;
    }

    private Loop getContainerLoop(Outline outline) {
        ArrayList<Vertex> arrayList = outline.getVertices();
        for (int i = 0; i < this.loops.size(); ++i) {
            Loop loop = this.loops.get(i);
            boolean bl = false;
            for (int j = 0; j < arrayList.size(); ++j) {
                Vertex vertex = arrayList.get(j);
                bl |= loop.checkInside(vertex);
            }
            if (!bl) continue;
            return loop;
        }
        return null;
    }
}

