/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeArray
extends IdScriptableObject
implements List {
    static final long serialVersionUID = 7331366857676127338L;
    private static final Object ARRAY_TAG = "Array";
    private static final Integer NEGATIVE_ONE = -1;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int Id_find = 22;
    private static final int Id_findIndex = 23;
    private static final int Id_reduce = 24;
    private static final int Id_reduceRight = 25;
    private static final int MAX_PROTOTYPE_ID = 25;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_unshift = -11;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_some = -21;
    private static final int ConstructorId_find = -22;
    private static final int ConstructorId_findIndex = -23;
    private static final int ConstructorId_reduce = -24;
    private static final int ConstructorId_reduceRight = -25;
    private static final int ConstructorId_isArray = -26;
    private long length;
    private int lengthAttr = 6;
    private Object[] dense;
    private boolean denseOnly;
    private static int maximumInitialCapacity = 10000;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final double GROW_FACTOR = 1.5;
    private static final int MAX_PRE_GROW_SIZE = 0x55555554;

    static void init(Scriptable scriptable, boolean bl) {
        NativeArray nativeArray = new NativeArray(0L);
        nativeArray.exportAsJSClass(25, scriptable, bl);
    }

    static int getMaximumInitialCapacity() {
        return maximumInitialCapacity;
    }

    static void setMaximumInitialCapacity(int n) {
        maximumInitialCapacity = n;
    }

    public NativeArray(long l) {
        boolean bl = this.denseOnly = l <= (long)maximumInitialCapacity;
        if (this.denseOnly) {
            int n = (int)l;
            if (n < 10) {
                n = 10;
            }
            this.dense = new Object[n];
            Arrays.fill(this.dense, Scriptable.NOT_FOUND);
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.denseOnly = true;
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        if (n == 1) {
            this.lengthAttr = n2;
        }
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return NativeArray.instanceIdInfo(this.lengthAttr, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n == 1) {
            this.setLength(object);
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -5, "join", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -6, "reverse", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -7, "sort", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -8, "push", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -9, "pop", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -10, "shift", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -11, "unshift", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -12, "splice", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -13, "concat", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -14, "slice", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -15, "indexOf", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -16, "lastIndexOf", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -17, "every", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -18, "filter", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -19, "forEach", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -20, "map", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -21, "some", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -22, "find", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -23, "findIndex", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -24, "reduce", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -25, "reduceRight", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -26, "isArray", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 5: {
                n2 = 1;
                string = "join";
                break;
            }
            case 6: {
                n2 = 0;
                string = "reverse";
                break;
            }
            case 7: {
                n2 = 1;
                string = "sort";
                break;
            }
            case 8: {
                n2 = 1;
                string = "push";
                break;
            }
            case 9: {
                n2 = 0;
                string = "pop";
                break;
            }
            case 10: {
                n2 = 0;
                string = "shift";
                break;
            }
            case 11: {
                n2 = 1;
                string = "unshift";
                break;
            }
            case 12: {
                n2 = 2;
                string = "splice";
                break;
            }
            case 13: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 14: {
                n2 = 2;
                string = "slice";
                break;
            }
            case 15: {
                n2 = 1;
                string = "indexOf";
                break;
            }
            case 16: {
                n2 = 1;
                string = "lastIndexOf";
                break;
            }
            case 17: {
                n2 = 1;
                string = "every";
                break;
            }
            case 18: {
                n2 = 1;
                string = "filter";
                break;
            }
            case 19: {
                n2 = 1;
                string = "forEach";
                break;
            }
            case 20: {
                n2 = 1;
                string = "map";
                break;
            }
            case 21: {
                n2 = 1;
                string = "some";
                break;
            }
            case 22: {
                n2 = 1;
                string = "find";
                break;
            }
            case 23: {
                n2 = 1;
                string = "findIndex";
                break;
            }
            case 24: {
                n2 = 1;
                string = "reduce";
                break;
            }
            case 25: {
                n2 = 1;
                string = "reduceRight";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ARRAY_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        block22: while (true) {
            switch (n) {
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    if (objectArray.length > 0) {
                        scriptable2 = ScriptRuntime.toObject(context, scriptable, objectArray[0]);
                        Object[] objectArray2 = new Object[objectArray.length - 1];
                        for (int i = 0; i < objectArray2.length; ++i) {
                            objectArray2[i] = objectArray[i + 1];
                        }
                        objectArray = objectArray2;
                    }
                    n = -n;
                    continue block22;
                }
                case -26: {
                    return objectArray.length > 0 && NativeArray.js_isArray(objectArray[0]);
                }
                case 1: {
                    boolean bl;
                    boolean bl2 = bl = scriptable2 == null;
                    if (!bl) {
                        return idFunctionObject.construct(context, scriptable, objectArray);
                    }
                    return NativeArray.jsConstructor(context, scriptable, objectArray);
                }
                case 2: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, context.hasFeature(4), false);
                }
                case 3: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, false, true);
                }
                case 4: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, true, false);
                }
                case 5: {
                    return NativeArray.js_join(context, scriptable2, objectArray);
                }
                case 6: {
                    return NativeArray.js_reverse(context, scriptable2, objectArray);
                }
                case 7: {
                    return NativeArray.js_sort(context, scriptable, scriptable2, objectArray);
                }
                case 8: {
                    return NativeArray.js_push(context, scriptable2, objectArray);
                }
                case 9: {
                    return NativeArray.js_pop(context, scriptable2, objectArray);
                }
                case 10: {
                    return NativeArray.js_shift(context, scriptable2, objectArray);
                }
                case 11: {
                    return NativeArray.js_unshift(context, scriptable2, objectArray);
                }
                case 12: {
                    return NativeArray.js_splice(context, scriptable, scriptable2, objectArray);
                }
                case 13: {
                    return NativeArray.js_concat(context, scriptable, scriptable2, objectArray);
                }
                case 14: {
                    return this.js_slice(context, scriptable2, objectArray);
                }
                case 15: {
                    return NativeArray.js_indexOf(context, scriptable2, objectArray);
                }
                case 16: {
                    return NativeArray.js_lastIndexOf(context, scriptable2, objectArray);
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    return NativeArray.iterativeMethod(context, n, scriptable, scriptable2, objectArray);
                }
                case 24: 
                case 25: {
                    return NativeArray.reduceMethod(context, n, scriptable, scriptable2, objectArray);
                }
            }
            break;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.get(n, scriptable);
        }
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.has(n, scriptable);
        }
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n] != NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static long toArrayIndex(Object object) {
        if (object instanceof String) {
            return NativeArray.toArrayIndex((String)object);
        }
        if (object instanceof Number) {
            return NativeArray.toArrayIndex(((Number)object).doubleValue());
        }
        return -1L;
    }

    private static long toArrayIndex(String string) {
        long l = NativeArray.toArrayIndex(ScriptRuntime.toNumber(string));
        if (Long.toString(l).equals(string)) {
            return l;
        }
        return -1L;
    }

    private static long toArrayIndex(double d) {
        long l;
        if (d == d && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL) {
            return l;
        }
        return -1L;
    }

    private static int toDenseIndex(Object object) {
        long l = NativeArray.toArrayIndex(object);
        return 0L <= l && l < Integer.MAX_VALUE ? (int)l : -1;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        long l;
        super.put(string, scriptable, object);
        if (scriptable == this && (l = NativeArray.toArrayIndex(string)) >= this.length) {
            this.length = l + 1L;
            this.denseOnly = false;
        }
    }

    private boolean ensureCapacity(int n) {
        if (n > this.dense.length) {
            if (n > 0x55555554) {
                this.denseOnly = false;
                return false;
            }
            n = Math.max(n, (int)((double)this.dense.length * 1.5));
            Object[] objectArray = new Object[n];
            System.arraycopy(this.dense, 0, objectArray, 0, this.dense.length);
            Arrays.fill(objectArray, this.dense.length, objectArray.length, Scriptable.NOT_FOUND);
            this.dense = objectArray;
        }
        return true;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (!(scriptable != this || this.isSealed() || this.dense == null || 0 > n || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            if (!this.isExtensible() && this.length <= (long)n) {
                return;
            }
            if (n < this.dense.length) {
                this.dense[n] = object;
                if (this.length <= (long)n) {
                    this.length = (long)n + 1L;
                }
                return;
            }
            if (this.denseOnly && (double)n < (double)this.dense.length * 1.5 && this.ensureCapacity(n + 1)) {
                this.dense[n] = object;
                this.length = (long)n + 1L;
                return;
            }
            this.denseOnly = false;
        }
        super.put(n, scriptable, object);
        if (scriptable == this && (this.lengthAttr & 1) == 0 && this.length <= (long)n) {
            this.length = (long)n + 1L;
        }
    }

    @Override
    public void delete(int n) {
        if (!(this.dense == null || 0 > n || n >= this.dense.length || this.isSealed() || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            this.dense[n] = NOT_FOUND;
        } else {
            super.delete(n);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray = super.getIds();
        if (this.dense == null) {
            return objectArray;
        }
        int n = this.dense.length;
        long l = this.length;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n == 0) {
            return objectArray;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n + n2];
        int n3 = 0;
        for (int i = 0; i != n; ++i) {
            if (this.dense[i] == NOT_FOUND) continue;
            objectArray2[n3] = i;
            ++n3;
        }
        if (n3 != n) {
            Object[] objectArray3 = new Object[n3 + n2];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n3);
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, objectArray2, n3, n2);
        return objectArray2;
    }

    @Override
    public Object[] getAllIds() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(Arrays.asList(this.getIds()));
        linkedHashSet.addAll(Arrays.asList(super.getAllIds()));
        return linkedHashSet.toArray();
    }

    public Integer[] getIndexIds() {
        Object[] objectArray = this.getIds();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(objectArray.length);
        for (Object object : objectArray) {
            int n = ScriptRuntime.toInt32(object);
            if (n < 0 || !ScriptRuntime.toString(n).equals(ScriptRuntime.toString(object))) continue;
            arrayList.add(n);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return this.length;
        }
        return super.getDefaultValue(clazz);
    }

    private ScriptableObject defaultIndexPropertyDescriptor(Object object) {
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.defineProperty("value", object, 0);
        nativeObject.defineProperty("writable", true, 0);
        nativeObject.defineProperty("enumerable", true, 0);
        nativeObject.defineProperty("configurable", true, 0);
        return nativeObject;
    }

    @Override
    public int getAttributes(int n) {
        if (this.dense != null && n >= 0 && n < this.dense.length && this.dense[n] != NOT_FOUND) {
            return 0;
        }
        return super.getAttributes(n);
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        int n;
        if (this.dense != null && 0 <= (n = NativeArray.toDenseIndex(object)) && n < this.dense.length && this.dense[n] != NOT_FOUND) {
            Object object2 = this.dense[n];
            return this.defaultIndexPropertyDescriptor(object2);
        }
        return super.getOwnPropertyDescriptor(context, object);
    }

    @Override
    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        long l;
        if (this.dense != null) {
            Object[] objectArray = this.dense;
            this.dense = null;
            this.denseOnly = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == NOT_FOUND) continue;
                this.put(i, (Scriptable)this, objectArray[i]);
            }
        }
        if ((l = NativeArray.toArrayIndex(object)) >= this.length) {
            this.length = l + 1L;
        }
        super.defineOwnProperty(context, object, scriptableObject, bl);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length == 0) {
            return new NativeArray(0L);
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        Object object = objectArray[0];
        if (objectArray.length > 1 || !(object instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(object);
        if ((double)l != ((Number)object).doubleValue()) {
            String string = ScriptRuntime.getMessage0("msg.arraylength.bad");
            throw ScriptRuntime.constructError("RangeError", string);
        }
        return new NativeArray(l);
    }

    public long getLength() {
        return this.length;
    }

    @Deprecated
    public long jsGet_length() {
        return this.getLength();
    }

    void setDenseOnly(boolean bl) {
        if (bl && !this.denseOnly) {
            throw new IllegalArgumentException();
        }
        this.denseOnly = bl;
    }

    private void setLength(Object object) {
        if ((this.lengthAttr & 1) != 0) {
            return;
        }
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d) {
            String string = ScriptRuntime.getMessage0("msg.arraylength.bad");
            throw ScriptRuntime.constructError("RangeError", string);
        }
        if (this.denseOnly) {
            if (l < this.length) {
                Arrays.fill(this.dense, (int)l, this.dense.length, NOT_FOUND);
                this.length = l;
                return;
            }
            if (l < 0x55555554L && (double)l < (double)this.length * 1.5 && this.ensureCapacity((int)l)) {
                this.length = l;
                return;
            }
            this.denseOnly = false;
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray = this.getIds();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (object2 instanceof String) {
                        String string = (String)object2;
                        long l2 = NativeArray.toArrayIndex(string);
                        if (l2 < l) continue;
                        this.delete(string);
                        continue;
                    }
                    int n = (Integer)object2;
                    if ((long)n < l) continue;
                    this.delete(n);
                }
            } else {
                for (long i = l; i < this.length; ++i) {
                    NativeArray.deleteElem(this, i);
                }
            }
        }
        this.length = l;
    }

    static long getLengthProperty(Context context, Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).getLength();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).getLength();
        }
        Object object = ScriptableObject.getProperty(scriptable, "length");
        if (object == Scriptable.NOT_FOUND) {
            return 0L;
        }
        return ScriptRuntime.toUint32(object);
    }

    private static Object setLengthProperty(Context context, Scriptable scriptable, long l) {
        Number number = ScriptRuntime.wrapNumber(l);
        ScriptableObject.putProperty(scriptable, "length", (Object)number);
        return number;
    }

    private static void deleteElem(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private static Object getElem(Context context, Scriptable scriptable, long l) {
        Object object = NativeArray.getRawElem(scriptable, l);
        return object != Scriptable.NOT_FOUND ? object : Undefined.instance;
    }

    private static Object getRawElem(Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            return ScriptableObject.getProperty(scriptable, Long.toString(l));
        }
        return ScriptableObject.getProperty(scriptable, (int)l);
    }

    private static void defineElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            scriptable.put(string, scriptable, object);
        } else {
            scriptable.put((int)l, scriptable, object);
        }
    }

    private static void setElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptableObject.putProperty(scriptable, string, object);
        } else {
            ScriptableObject.putProperty(scriptable, (int)l, object);
        }
    }

    private static void setRawElem(Context context, Scriptable scriptable, long l, Object object) {
        if (object == NOT_FOUND) {
            NativeArray.deleteElem(scriptable, l);
        } else {
            NativeArray.setElem(context, scriptable, l, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toStringHelper(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        String string;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        StringBuilder stringBuilder = new StringBuilder(256);
        if (bl) {
            stringBuilder.append('[');
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl5 = false;
        long l2 = 0L;
        if (context.iterating == null) {
            bl4 = true;
            bl3 = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl4 = false;
            bl3 = context.iterating.has(scriptable2);
        }
        try {
            if (!bl3) {
                context.iterating.put(scriptable2, 0);
                boolean bl6 = !bl || context.getLanguageVersion() < 150;
                for (l2 = 0L; l2 < l; ++l2) {
                    Object object;
                    Object object2;
                    if (l2 > 0L) {
                        stringBuilder.append(string);
                    }
                    if ((object2 = NativeArray.getRawElem(scriptable2, l2)) == NOT_FOUND || bl6 && (object2 == null || object2 == Undefined.instance)) {
                        bl5 = false;
                        continue;
                    }
                    bl5 = true;
                    if (bl) {
                        stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object2));
                        continue;
                    }
                    if (object2 instanceof String) {
                        object = (String)object2;
                        if (bl) {
                            stringBuilder.append('\"');
                            stringBuilder.append(ScriptRuntime.escapeString((String)object));
                            stringBuilder.append('\"');
                            continue;
                        }
                        stringBuilder.append((String)object);
                        continue;
                    }
                    if (bl2) {
                        object = ScriptRuntime.getPropFunctionAndThis(object2, "toLocaleString", context, scriptable);
                        Scriptable scriptable3 = ScriptRuntime.lastStoredScriptable(context);
                        object2 = object.call(context, scriptable, scriptable3, ScriptRuntime.emptyArgs);
                    }
                    stringBuilder.append(ScriptRuntime.toString(object2));
                }
            }
        }
        finally {
            if (bl4) {
                context.iterating = null;
            }
        }
        if (bl) {
            if (!bl5 && l2 > 0L) {
                stringBuilder.append(", ]");
            } else {
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    private static String js_join(Context context, Scriptable scriptable, Object[] objectArray) {
        String string;
        String[] stringArray;
        String string2;
        int n;
        long l = NativeArray.getLengthProperty(context, scriptable);
        if (l != (long)(n = (int)l)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(l));
        }
        String string3 = string2 = objectArray.length < 1 || objectArray[0] == Undefined.instance ? "," : ScriptRuntime.toString(objectArray[0]);
        if (scriptable instanceof NativeArray) {
            stringArray = (String[])scriptable;
            if (stringArray.denseOnly) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    if (i != 0) {
                        stringBuilder.append(string2);
                    }
                    if (i >= stringArray.dense.length || (object = stringArray.dense[i]) == null || object == Undefined.instance || object == Scriptable.NOT_FOUND) continue;
                    stringBuilder.append(ScriptRuntime.toString(object));
                }
                return stringBuilder.toString();
            }
        }
        if (n == 0) {
            return "";
        }
        stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i != n; ++i) {
            Object object = NativeArray.getElem(context, scriptable, i);
            if (object == null || object == Undefined.instance) continue;
            string = ScriptRuntime.toString(object);
            n2 += string.length();
            stringArray[i] = string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 += (n - 1) * string2.length());
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuilder.append(string2);
            }
            if ((string = stringArray[i]) == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static Scriptable js_reverse(Context context, Scriptable scriptable, Object[] objectArray) {
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly) {
                int n = 0;
                for (int i = (int)nativeArray.length - 1; n < i; ++n, --i) {
                    Object object = nativeArray.dense[n];
                    nativeArray.dense[n] = nativeArray.dense[i];
                    nativeArray.dense[i] = object;
                }
                return scriptable;
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        long l2 = l / 2L;
        for (long i = 0L; i < l2; ++i) {
            long l3 = l - i - 1L;
            Object object = NativeArray.getRawElem(scriptable, i);
            Object object2 = NativeArray.getRawElem(scriptable, l3);
            NativeArray.setRawElem(context, scriptable, i, object2);
            NativeArray.setRawElem(context, scriptable, l3, object);
        }
        return scriptable;
    }

    private static Scriptable js_sort(final Context context, final Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        int n;
        Comparator<Object> comparator;
        if (objectArray.length > 0 && Undefined.instance != objectArray[0]) {
            final Callable callable = ScriptRuntime.getValueFunctionAndThis(objectArray[0], context);
            final Scriptable scriptable3 = ScriptRuntime.lastStoredScriptable(context);
            final Object[] objectArray2 = new Object[2];
            comparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    if (object == Scriptable.NOT_FOUND) {
                        return object2 == Scriptable.NOT_FOUND ? 0 : 1;
                    }
                    if (object2 == Scriptable.NOT_FOUND) {
                        return -1;
                    }
                    if (object == Undefined.instance) {
                        return object2 == Undefined.instance ? 0 : 1;
                    }
                    if (object2 == Undefined.instance) {
                        return -1;
                    }
                    objectArray2[0] = object;
                    objectArray2[1] = object2;
                    Object object3 = callable.call(context, scriptable, scriptable3, objectArray2);
                    double d = ScriptRuntime.toNumber(object3);
                    if (d < 0.0) {
                        return -1;
                    }
                    if (d > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            };
        } else {
            comparator = new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    if (object == Scriptable.NOT_FOUND) {
                        return object2 == Scriptable.NOT_FOUND ? 0 : 1;
                    }
                    if (object2 == Scriptable.NOT_FOUND) {
                        return -1;
                    }
                    if (object == Undefined.instance) {
                        return object2 == Undefined.instance ? 0 : 1;
                    }
                    if (object2 == Undefined.instance) {
                        return -1;
                    }
                    String string = ScriptRuntime.toString(object);
                    String string2 = ScriptRuntime.toString(object2);
                    return string.compareTo(string2);
                }
            };
        }
        long l = NativeArray.getLengthProperty(context, scriptable2);
        int n2 = (int)l;
        if (l != (long)n2) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(l));
        }
        Object[] objectArray3 = new Object[n2];
        for (n = 0; n != n2; ++n) {
            objectArray3[n] = NativeArray.getRawElem(scriptable2, n);
        }
        Arrays.sort(objectArray3, comparator);
        for (n = 0; n < n2; ++n) {
            NativeArray.setRawElem(context, scriptable2, n, objectArray3[n]);
        }
        return scriptable2;
    }

    private static Object js_push(Context context, Scriptable scriptable, Object[] objectArray) {
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                for (int i = 0; i < objectArray.length; ++i) {
                    nativeArray.dense[(int)nativeArray.length++] = objectArray[i];
                }
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        for (int i = 0; i < objectArray.length; ++i) {
            NativeArray.setElem(context, scriptable, l + (long)i, objectArray[i]);
        }
        Object object = NativeArray.setLengthProperty(context, scriptable, l += (long)objectArray.length);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Undefined.instance : objectArray[objectArray.length - 1];
        }
        return object;
    }

    private static Object js_pop(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        long l;
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && nativeArray.length > 0L) {
                --nativeArray.length;
                Object object2 = nativeArray.dense[(int)nativeArray.length];
                nativeArray.dense[(int)nativeArray.length] = NOT_FOUND;
                return object2;
            }
        }
        if ((l = NativeArray.getLengthProperty(context, scriptable)) > 0L) {
            object = NativeArray.getElem(context, scriptable, --l);
            NativeArray.deleteElem(scriptable, l);
        } else {
            object = Undefined.instance;
        }
        NativeArray.setLengthProperty(context, scriptable, l);
        return object;
    }

    private static Object js_shift(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        Object object;
        if (scriptable instanceof NativeArray) {
            object = (NativeArray)scriptable;
            if (((NativeArray)object).denseOnly && ((NativeArray)object).length > 0L) {
                --((NativeArray)object).length;
                Object object2 = ((NativeArray)object).dense[0];
                System.arraycopy(((NativeArray)object).dense, 1, ((NativeArray)object).dense, 0, (int)((NativeArray)object).length);
                ((NativeArray)object).dense[(int)((NativeArray)object).length] = NOT_FOUND;
                return object2 == NOT_FOUND ? Undefined.instance : object2;
            }
        }
        if ((l = NativeArray.getLengthProperty(context, scriptable)) > 0L) {
            long l2 = 0L;
            object = NativeArray.getElem(context, scriptable, l2);
            if (--l > 0L) {
                for (l2 = 1L; l2 <= l; ++l2) {
                    Object object3 = NativeArray.getRawElem(scriptable, l2);
                    NativeArray.setRawElem(context, scriptable, l2 - 1L, object3);
                }
            }
            NativeArray.deleteElem(scriptable, l);
        } else {
            object = Undefined.instance;
        }
        NativeArray.setLengthProperty(context, scriptable, l);
        return object;
    }

    private static Object js_unshift(Context context, Scriptable scriptable, Object[] objectArray) {
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                System.arraycopy(nativeArray.dense, 0, nativeArray.dense, objectArray.length, (int)nativeArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    nativeArray.dense[i] = objectArray[i];
                }
                nativeArray.length += (long)objectArray.length;
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable);
        int n = objectArray.length;
        if (objectArray.length > 0) {
            if (l > 0L) {
                for (long i = l - 1L; i >= 0L; --i) {
                    Object object = NativeArray.getRawElem(scriptable, i);
                    NativeArray.setRawElem(context, scriptable, i + (long)n, object);
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                NativeArray.setElem(context, scriptable, i, objectArray[i]);
            }
        }
        return NativeArray.setLengthProperty(context, scriptable, l += (long)objectArray.length);
    }

    private static Object js_splice(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        Object object2;
        long l2;
        NativeArray nativeArray = null;
        boolean bl = false;
        if (scriptable2 instanceof NativeArray) {
            nativeArray = (NativeArray)scriptable2;
            bl = nativeArray.denseOnly;
        }
        scriptable = NativeArray.getTopLevelScope(scriptable);
        int n = objectArray.length;
        if (n == 0) {
            return context.newArray(scriptable, 0);
        }
        long l3 = NativeArray.getLengthProperty(context, scriptable2);
        long l4 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
        --n;
        if (objectArray.length == 1) {
            l2 = l3 - l4;
        } else {
            double d = ScriptRuntime.toInteger(objectArray[1]);
            l2 = d < 0.0 ? 0L : (d > (double)(l3 - l4) ? l3 - l4 : (long)d);
            --n;
        }
        long l5 = l4 + l2;
        if (l2 != 0L) {
            if (l2 == 1L && context.getLanguageVersion() == 120) {
                object2 = NativeArray.getElem(context, scriptable2, l4);
            } else if (bl) {
                int n2 = (int)(l5 - l4);
                Object[] objectArray2 = new Object[n2];
                System.arraycopy(nativeArray.dense, (int)l4, objectArray2, 0, n2);
                object2 = context.newArray(scriptable, objectArray2);
            } else {
                Scriptable scriptable3 = context.newArray(scriptable, 0);
                for (long i = l4; i != l5; ++i) {
                    Object object3 = NativeArray.getRawElem(scriptable2, i);
                    if (object3 == NOT_FOUND) continue;
                    NativeArray.setElem(context, scriptable3, i - l4, object3);
                }
                NativeArray.setLengthProperty(context, scriptable3, l5 - l4);
                object2 = scriptable3;
            }
        } else {
            object2 = context.getLanguageVersion() == 120 ? Undefined.instance : context.newArray(scriptable, 0);
        }
        long l6 = (long)n - l2;
        if (bl && l3 + l6 < Integer.MAX_VALUE && nativeArray.ensureCapacity((int)(l3 + l6))) {
            System.arraycopy(nativeArray.dense, (int)l5, nativeArray.dense, (int)(l4 + (long)n), (int)(l3 - l5));
            if (n > 0) {
                System.arraycopy(objectArray, 2, nativeArray.dense, (int)l4, n);
            }
            if (l6 < 0L) {
                Arrays.fill(nativeArray.dense, (int)(l3 + l6), (int)l3, NOT_FOUND);
            }
            nativeArray.length = l3 + l6;
            return object2;
        }
        if (l6 > 0L) {
            for (l = l3 - 1L; l >= l5; --l) {
                object = NativeArray.getRawElem(scriptable2, l);
                NativeArray.setRawElem(context, scriptable2, l + l6, object);
            }
        } else if (l6 < 0L) {
            for (l = l5; l < l3; ++l) {
                object = NativeArray.getRawElem(scriptable2, l);
                NativeArray.setRawElem(context, scriptable2, l + l6, object);
            }
            for (l = l3 + l6; l < l3; ++l) {
                NativeArray.deleteElem(scriptable2, l);
            }
        }
        int n3 = objectArray.length - n;
        for (int i = 0; i < n; ++i) {
            NativeArray.setElem(context, scriptable2, l4 + (long)i, objectArray[i + n3]);
        }
        NativeArray.setLengthProperty(context, scriptable2, l3 + l6);
        return object2;
    }

    private static Scriptable js_concat(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3;
        int n;
        scriptable = NativeArray.getTopLevelScope(scriptable);
        Scriptable scriptable4 = context.newArray(scriptable, 0);
        if (scriptable2 instanceof NativeArray && scriptable4 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable2;
            NativeArray nativeArray2 = (NativeArray)scriptable4;
            if (nativeArray.denseOnly && nativeArray2.denseOnly) {
                boolean bl = true;
                int n2 = (int)nativeArray.length;
                for (n = 0; n < objectArray.length && bl; ++n) {
                    if (objectArray[n] instanceof NativeArray) {
                        scriptable3 = (NativeArray)objectArray[n];
                        bl = ((NativeArray)scriptable3).denseOnly;
                        n2 = (int)((long)n2 + ((NativeArray)scriptable3).length);
                        continue;
                    }
                    ++n2;
                }
                if (bl && nativeArray2.ensureCapacity(n2)) {
                    System.arraycopy(nativeArray.dense, 0, nativeArray2.dense, 0, (int)nativeArray.length);
                    n = (int)nativeArray.length;
                    for (int i = 0; i < objectArray.length && bl; ++i) {
                        if (objectArray[i] instanceof NativeArray) {
                            NativeArray nativeArray3 = (NativeArray)objectArray[i];
                            System.arraycopy(nativeArray3.dense, 0, nativeArray2.dense, n, (int)nativeArray3.length);
                            n += (int)nativeArray3.length;
                            continue;
                        }
                        nativeArray2.dense[n++] = objectArray[i];
                    }
                    nativeArray2.length = n2;
                    return scriptable4;
                }
            }
        }
        long l = 0L;
        if (NativeArray.js_isArray(scriptable2)) {
            long l2 = NativeArray.getLengthProperty(context, scriptable2);
            for (l = 0L; l < l2; ++l) {
                Object object = NativeArray.getRawElem(scriptable2, l);
                if (object == NOT_FOUND) continue;
                NativeArray.defineElem(context, scriptable4, l, object);
            }
        } else {
            NativeArray.defineElem(context, scriptable4, l++, scriptable2);
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (NativeArray.js_isArray(objectArray[n])) {
                scriptable3 = (Scriptable)objectArray[n];
                long l3 = NativeArray.getLengthProperty(context, scriptable3);
                long l4 = 0L;
                while (l4 < l3) {
                    Object object = NativeArray.getRawElem(scriptable3, l4);
                    if (object != NOT_FOUND) {
                        NativeArray.defineElem(context, scriptable4, l, object);
                    }
                    ++l4;
                    ++l;
                }
                continue;
            }
            NativeArray.defineElem(context, scriptable4, l++, objectArray[n]);
        }
        NativeArray.setLengthProperty(context, scriptable4, l);
        return scriptable4;
    }

    private Scriptable js_slice(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        long l2;
        Scriptable scriptable2 = NativeArray.getTopLevelScope(this);
        Scriptable scriptable3 = context.newArray(scriptable2, 0);
        long l3 = NativeArray.getLengthProperty(context, scriptable);
        if (objectArray.length == 0) {
            l2 = 0L;
            l = l3;
        } else {
            l2 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
            l = objectArray.length == 1 || objectArray[1] == Undefined.instance ? l3 : NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[1]), l3);
        }
        for (long i = l2; i < l; ++i) {
            Object object = NativeArray.getRawElem(scriptable, i);
            if (object == NOT_FOUND) continue;
            NativeArray.defineElem(context, scriptable3, i - l2, object);
        }
        NativeArray.setLengthProperty(context, scriptable3, Math.max(0L, l - l2));
        return scriptable3;
    }

    private static long toSliceIndex(double d, long l) {
        long l2 = d < 0.0 ? (d + (double)l < 0.0 ? 0L : (long)(d + (double)l)) : (d > (double)l ? l : (long)d);
        return l2;
    }

    private static Object js_indexOf(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        long l2 = NativeArray.getLengthProperty(context, scriptable);
        if (objectArray.length < 2) {
            l = 0L;
        } else {
            l = (long)ScriptRuntime.toInteger(objectArray[1]);
            if (l < 0L && (l += l2) < 0L) {
                l = 0L;
            }
            if (l > l2 - 1L) {
                return NEGATIVE_ONE;
            }
        }
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly) {
                Scriptable scriptable2 = nativeArray.getPrototype();
                int n = (int)l;
                while ((long)n < l2) {
                    Object object2 = nativeArray.dense[n];
                    if (object2 == NOT_FOUND && scriptable2 != null) {
                        object2 = ScriptableObject.getProperty(scriptable2, n);
                    }
                    if (object2 != NOT_FOUND && ScriptRuntime.shallowEq(object2, object)) {
                        return (long)n;
                    }
                    ++n;
                }
                return NEGATIVE_ONE;
            }
        }
        for (long i = l; i < l2; ++i) {
            Object object3 = NativeArray.getRawElem(scriptable, i);
            if (object3 == NOT_FOUND || !ScriptRuntime.shallowEq(object3, object)) continue;
            return i;
        }
        return NEGATIVE_ONE;
    }

    private static Object js_lastIndexOf(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        long l2 = NativeArray.getLengthProperty(context, scriptable);
        if (objectArray.length < 2) {
            l = l2 - 1L;
        } else {
            l = (long)ScriptRuntime.toInteger(objectArray[1]);
            if (l >= l2) {
                l = l2 - 1L;
            } else if (l < 0L) {
                l += l2;
            }
            if (l < 0L) {
                return NEGATIVE_ONE;
            }
        }
        if (scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly) {
                Scriptable scriptable2 = nativeArray.getPrototype();
                for (int i = (int)l; i >= 0; --i) {
                    Object object2 = nativeArray.dense[i];
                    if (object2 == NOT_FOUND && scriptable2 != null) {
                        object2 = ScriptableObject.getProperty(scriptable2, i);
                    }
                    if (object2 == NOT_FOUND || !ScriptRuntime.shallowEq(object2, object)) continue;
                    return (long)i;
                }
                return NEGATIVE_ONE;
            }
        }
        for (long i = l; i >= 0L; --i) {
            Object object3 = NativeArray.getRawElem(scriptable, i);
            if (object3 == NOT_FOUND || !ScriptRuntime.shallowEq(object3, object)) continue;
            return i;
        }
        return NEGATIVE_ONE;
    }

    private static Object iterativeMethod(Context context, int n, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        if (object == null || !(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        if (!(n != 22 && n != 23 || object instanceof NativeFunction)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Function function = (Function)object;
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable4 = objectArray.length < 2 || objectArray[1] == null || objectArray[1] == Undefined.instance ? scriptable3 : ScriptRuntime.toObject(context, scriptable, objectArray[1]);
        if ((22 == n || 23 == n) && scriptable4 == scriptable2) {
            throw ScriptRuntime.typeError("Array.prototype method called on null or undefined");
        }
        Scriptable scriptable5 = null;
        if (n == 18 || n == 20) {
            int n2 = n == 20 ? (int)l : 0;
            scriptable5 = context.newArray(scriptable, n2);
        }
        long l2 = 0L;
        block15: for (long i = 0L; i < l; ++i) {
            Object[] objectArray2 = new Object[3];
            Object object3 = NativeArray.getRawElem(scriptable2, i);
            if (object3 == Scriptable.NOT_FOUND) continue;
            objectArray2[0] = object3;
            objectArray2[1] = i;
            objectArray2[2] = scriptable2;
            Object object4 = function.call(context, scriptable3, scriptable4, objectArray2);
            switch (n) {
                case 17: {
                    if (ScriptRuntime.toBoolean(object4)) continue block15;
                    return Boolean.FALSE;
                }
                case 18: {
                    if (!ScriptRuntime.toBoolean(object4)) continue block15;
                    NativeArray.defineElem(context, scriptable5, l2++, objectArray2[0]);
                    continue block15;
                }
                case 19: {
                    continue block15;
                }
                case 20: {
                    NativeArray.defineElem(context, scriptable5, i, object4);
                    continue block15;
                }
                case 21: {
                    if (!ScriptRuntime.toBoolean(object4)) continue block15;
                    return Boolean.TRUE;
                }
                case 22: {
                    if (!ScriptRuntime.toBoolean(object4)) continue block15;
                    return object3;
                }
                case 23: {
                    if (!ScriptRuntime.toBoolean(object4)) continue block15;
                    return ScriptRuntime.wrapNumber(i);
                }
            }
        }
        switch (n) {
            case 17: {
                return Boolean.TRUE;
            }
            case 18: 
            case 20: {
                return scriptable5;
            }
            case 21: {
                return Boolean.FALSE;
            }
            case 23: {
                return ScriptRuntime.wrapNumber(-1.0);
            }
        }
        return Undefined.instance;
    }

    private static Object reduceMethod(Context context, int n, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        if (object == null || !(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Function function = (Function)object;
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(function);
        boolean bl = n == 24;
        Object object3 = objectArray.length > 1 ? objectArray[1] : Scriptable.NOT_FOUND;
        for (long i = 0L; i < l; ++i) {
            long l2 = bl ? i : l - 1L - i;
            Object object4 = NativeArray.getRawElem(scriptable2, l2);
            if (object4 == Scriptable.NOT_FOUND) continue;
            if (object3 == Scriptable.NOT_FOUND) {
                object3 = object4;
                continue;
            }
            Object[] objectArray2 = new Object[]{object3, object4, l2, scriptable2};
            object3 = function.call(context, scriptable3, scriptable3, objectArray2);
        }
        if (object3 == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeError0("msg.empty.array.reduce");
        }
        return object3;
    }

    private static boolean js_isArray(Object object) {
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return "Array".equals(((Scriptable)object).getClassName());
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) > -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(ScriptRuntime.emptyArgs);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        long l = this.length;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int n = (int)l;
        Object[] objectArray2 = objectArray.length >= n ? objectArray : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = this.get(i);
        }
        return objectArray2;
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        long l = this.length;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        return (int)l;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    public Object get(long l) {
        if (l < 0L || l >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = NativeArray.getRawElem(this, l);
        if (object == Scriptable.NOT_FOUND || object == Undefined.instance) {
            return null;
        }
        if (object instanceof Wrapper) {
            return ((Wrapper)object).unwrap();
        }
        return object;
    }

    public Object get(int n) {
        return this.get((long)n);
    }

    @Override
    public int indexOf(Object object) {
        long l = this.length;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int n = (int)l;
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        long l = this.length;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int n = (int)l;
        if (object == null) {
            for (int i = n - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        long l = this.length;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        final int n2 = (int)l;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListIterator(){
            int cursor;
            {
                this.cursor = n;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < n2;
            }

            @Override
            public Object next() {
                if (this.cursor == n2) {
                    throw new NoSuchElementException();
                }
                return NativeArray.this.get(this.cursor++);
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public Object previous() {
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                return NativeArray.this.get(--this.cursor);
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'm') {
                    if (string.charAt(2) != 'p' || string.charAt(1) != 'a') break;
                    return 20;
                }
                if (c != 'p' || string.charAt(2) != 'p' || string.charAt(1) != 'o') break;
                return 9;
            }
            case 4: {
                switch (string.charAt(2)) {
                    case 'i': {
                        string2 = "join";
                        n = 5;
                        break block0;
                    }
                    case 'm': {
                        string2 = "some";
                        n = 21;
                        break block0;
                    }
                    case 'n': {
                        string2 = "find";
                        n = 22;
                        break block0;
                    }
                    case 'r': {
                        string2 = "sort";
                        n = 7;
                        break block0;
                    }
                    case 's': {
                        string2 = "push";
                        n = 8;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = string.charAt(1);
                if (c == 'h') {
                    string2 = "shift";
                    n = 10;
                    break;
                }
                if (c == 'l') {
                    string2 = "slice";
                    n = 14;
                    break;
                }
                if (c != 'v') break;
                string2 = "every";
                n = 17;
                break;
            }
            case 6: {
                switch (string.charAt(0)) {
                    case 'c': {
                        string2 = "concat";
                        n = 13;
                        break block0;
                    }
                    case 'f': {
                        string2 = "filter";
                        n = 18;
                        break block0;
                    }
                    case 'r': {
                        string2 = "reduce";
                        n = 24;
                        break block0;
                    }
                    case 's': {
                        string2 = "splice";
                        n = 12;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(0)) {
                    case 'f': {
                        string2 = "forEach";
                        n = 19;
                        break block0;
                    }
                    case 'i': {
                        string2 = "indexOf";
                        n = 15;
                        break block0;
                    }
                    case 'r': {
                        string2 = "reverse";
                        n = 6;
                        break block0;
                    }
                    case 'u': {
                        string2 = "unshift";
                        n = 11;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 4;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
                break;
            }
            case 9: {
                string2 = "findIndex";
                n = 23;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
                if (c == 'l') {
                    string2 = "lastIndexOf";
                    n = 16;
                    break;
                }
                if (c != 'r') break;
                string2 = "reduceRight";
                n = 25;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 3;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

