/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

class SpecialRef
extends Ref {
    static final long serialVersionUID = -7521596632456797847L;
    private static final int SPECIAL_NONE = 0;
    private static final int SPECIAL_PROTO = 1;
    private static final int SPECIAL_PARENT = 2;
    private Scriptable target;
    private int type;
    private String name;

    private SpecialRef(Scriptable scriptable, int n, String string) {
        this.target = scriptable;
        this.type = n;
        this.name = string;
    }

    static Ref createSpecial(Context context, Scriptable scriptable, Object object, String string) {
        int n;
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        if (string.equals("__proto__")) {
            n = 1;
        } else if (string.equals("__parent__")) {
            n = 2;
        } else {
            throw new IllegalArgumentException(string);
        }
        if (!context.hasFeature(5)) {
            n = 0;
        }
        return new SpecialRef(scriptable2, n, string);
    }

    @Override
    public Object get(Context context) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.getObjectProp(this.target, this.name, context);
            }
            case 1: {
                return this.target.getPrototype();
            }
            case 2: {
                return this.target.getParentScope();
            }
        }
        throw Kit.codeBug();
    }

    @Override
    @Deprecated
    public Object set(Context context, Object object) {
        throw new IllegalStateException();
    }

    @Override
    public Object set(Context context, Scriptable scriptable, Object object) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.setObjectProp(this.target, this.name, object, context);
            }
            case 1: 
            case 2: {
                Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
                if (scriptable2 != null) {
                    Scriptable scriptable3 = scriptable2;
                    do {
                        if (scriptable3 != this.target) continue;
                        throw Context.reportRuntimeError1("msg.cyclic.value", this.name);
                    } while ((scriptable3 = this.type == 1 ? scriptable3.getPrototype() : scriptable3.getParentScope()) != null);
                }
                if (this.type == 1) {
                    this.target.setPrototype(scriptable2);
                } else {
                    this.target.setParentScope(scriptable2);
                }
                return scriptable2;
            }
        }
        throw Kit.codeBug();
    }

    @Override
    public boolean has(Context context) {
        if (this.type == 0) {
            return ScriptRuntime.hasObjectElem(this.target, this.name, context);
        }
        return true;
    }

    @Override
    public boolean delete(Context context) {
        if (this.type == 0) {
            return ScriptRuntime.deleteObjectElem(this.target, this.name, context);
        }
        return false;
    }
}

