/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

public final class DoubleConversion {
    private static final long kSignMask = Long.MIN_VALUE;
    private static final long kExponentMask = 0x7FF0000000000000L;
    private static final long kSignificandMask = 0xFFFFFFFFFFFFFL;
    private static final long kHiddenBit = 0x10000000000000L;
    private static final int kPhysicalSignificandSize = 52;
    private static final int kSignificandSize = 53;
    private static final int kExponentBias = 1075;
    private static final int kDenormalExponent = -1074;

    private DoubleConversion() {
    }

    private static int exponent(long l) {
        if (DoubleConversion.isDenormal(l)) {
            return -1074;
        }
        int n = (int)((l & 0x7FF0000000000000L) >> 52);
        return n - 1075;
    }

    private static long significand(long l) {
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if (!DoubleConversion.isDenormal(l)) {
            return l2 + 0x10000000000000L;
        }
        return l2;
    }

    private static boolean isDenormal(long l) {
        return (l & 0x7FF0000000000000L) == 0L;
    }

    private static int sign(long l) {
        return (l & Long.MIN_VALUE) == 0L ? 1 : -1;
    }

    public static int doubleToInt32(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        long l = Double.doubleToLongBits(d);
        int n2 = DoubleConversion.exponent(l);
        if (n2 <= -53 || n2 > 31) {
            return 0;
        }
        long l2 = DoubleConversion.significand(l);
        return DoubleConversion.sign(l) * (int)(n2 < 0 ? l2 >> -n2 : l2 << n2);
    }
}

