/*! grafana - v3.0.4 - 2016-06-01
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","test/specs/helpers","../datasource"],function(a){var b,c,d;return{setters:[function(a){b=a},function(a){c=a},function(a){d=a}],execute:function(){b.describe("graphiteDatasource",function(){var a=new c["default"].ServiceTestContext,e={url:[""]};b.beforeEach(b.angularMocks.module("grafana.core")),b.beforeEach(b.angularMocks.module("grafana.services")),b.beforeEach(a.providePhase(["backendSrv"])),b.beforeEach(b.angularMocks.inject(function(b,c,d,e){a.$q=b,a.$httpBackend=d,a.$rootScope=c,a.$injector=e,d.when("GET",/\.html$/).respond("")})),b.beforeEach(function(){a.ds=a.$injector.instantiate(d.GraphiteDatasource,{instanceSettings:e})}),b.describe("When querying influxdb with one target using query editor target spec",function(){var c,d,e={rangeRaw:{from:"now-1h",to:"now"},targets:[{target:"prod1.count"},{target:"prod2.count"}],maxDataPoints:500};b.beforeEach(function(){a.backendSrv.datasourceRequest=function(b){return d=b,a.$q.when({data:[{target:"prod1.count",datapoints:[[10,1],[12,1]]}]})},a.ds.query(e).then(function(a){c=a}),a.$rootScope.$apply()}),b.it("should generate the correct query",function(){b.expect(d.url).to.be("/render")}),b.it("should query correctly",function(){var a=d.data.split("&");b.expect(a).to.contain("target=prod1.count"),b.expect(a).to.contain("target=prod2.count"),b.expect(a).to.contain("from=-1h"),b.expect(a).to.contain("until=now")}),b.it("should exclude undefined params",function(){var a=d.data.split("&");b.expect(a).to.not.contain("cacheTimeout=undefined")}),b.it("should return series list",function(){b.expect(c.data.length).to.be(1),b.expect(c.data[0].target).to.be("prod1.count")}),b.it("should convert to millisecond resolution",function(){b.expect(c.data[0].datapoints[0][0]).to.be(10)})}),b.describe("building graphite params",function(){b.it("should return empty array if no targets",function(){var c=a.ds.buildGraphiteParams({targets:[{}]});b.expect(c.length).to.be(0)}),b.it("should uri escape targets",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"prod1.{test,test2}"},{target:"prod2.count"}]});b.expect(c).to.contain("target=prod1.%7Btest%2Ctest2%7D")}),b.it("should replace target placeholder",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"series1"},{target:"series2"},{target:"asPercent(#A,#B)"}]});b.expect(c[2]).to.be("target=asPercent(series1%2Cseries2)")}),b.it("should replace target placeholder for hidden series",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"series1",hide:!0},{target:"sumSeries(#A)",hide:!0},{target:"asPercent(#A,#B)"}]});b.expect(c[0]).to.be("target="+encodeURIComponent("asPercent(series1,sumSeries(series1))"))}),b.it("should replace target placeholder when nesting query references",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"series1"},{target:"sumSeries(#A)"},{target:"asPercent(#A,#B)"}]});b.expect(c[2]).to.be("target="+encodeURIComponent("asPercent(series1,sumSeries(series1))"))}),b.it("should fix wrong minute interval parameters",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"summarize(prod.25m.count, '25m', 'sum')"}]});b.expect(c[0]).to.be("target="+encodeURIComponent("summarize(prod.25m.count, '25min', 'sum')"))}),b.it("should fix wrong month interval parameters",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"summarize(prod.5M.count, '5M', 'sum')"}]});b.expect(c[0]).to.be("target="+encodeURIComponent("summarize(prod.5M.count, '5mon', 'sum')"))}),b.it("should ignore empty targets",function(){var c=a.ds.buildGraphiteParams({targets:[{target:"series1"},{target:""}]});b.expect(c.length).to.be(2)})})})}}});