/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.BrowserColorsModel;

public class BrowserColorsOptionPane
extends AbstractOptionPane {
    private BrowserColorsModel colorsModel;
    private JTable colorsTable;
    private JButton add;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;

    public BrowserColorsOptionPane() {
        super("browser.colors");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.colorsModel = new BrowserColorsModel();
        this.colorsTable = new JTable(this.colorsModel);
        this.colorsTable.setRowHeight(GUIUtilities.defaultRowHeight());
        this.colorsTable.setAutoResizeMode(4);
        this.colorsTable.getTableHeader().setReorderingAllowed(false);
        this.colorsTable.addMouseListener(new MouseHandler());
        this.colorsTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        TableColumnModel tableColumnModel = this.colorsTable.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(new BrowserColorsModel.ColorRenderer());
        Dimension dimension = this.colorsTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 200);
        JScrollPane jScrollPane = new JScrollPane(this.colorsTable);
        jScrollPane.setPreferredSize(dimension);
        this.add("Center", jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("common.add"));
        this.add.addActionListener(actionHandler);
        jPanel.add(this.add);
        jPanel.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener(actionHandler);
        jPanel.add(this.remove);
        jPanel.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        jPanel.add(this.moveUp);
        jPanel.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        jPanel.add(this.moveDown);
        jPanel.add(Box.createGlue());
        this.add("South", jPanel);
        this.updateEnabled();
    }

    @Override
    protected void _save() {
        this.colorsModel.save();
    }

    private void updateEnabled() {
        int n = this.colorsTable.getSelectedRow();
        this.remove.setEnabled(n != -1);
        this.moveUp.setEnabled(n > 0);
        this.moveDown.setEnabled(n != -1 && n != this.colorsModel.getRowCount() - 1);
    }

    private void setSelectedRow(int n) {
        this.colorsTable.getSelectionModel().setSelectionInterval(n, n);
        this.colorsTable.scrollRectToVisible(this.colorsTable.getCellRect(n, 0, true));
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = BrowserColorsOptionPane.this.colorsTable.rowAtPoint(point);
            int n2 = BrowserColorsOptionPane.this.colorsTable.columnAtPoint(point);
            if (n == -1 || n2 != 1) {
                return;
            }
            Color color = JColorChooser.showDialog(BrowserColorsOptionPane.this, jEdit.getProperty("colorChooser.title"), (Color)BrowserColorsOptionPane.this.colorsModel.getValueAt(n, 1));
            if (color != null) {
                BrowserColorsOptionPane.this.colorsModel.setValueAt(color, n, 1);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BrowserColorsOptionPane.this.add) {
                BrowserColorsOptionPane.this.colorsModel.add();
            } else if (object == BrowserColorsOptionPane.this.remove) {
                int n = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                BrowserColorsOptionPane.this.colorsModel.remove(n);
                BrowserColorsOptionPane.this.updateEnabled();
            } else if (object == BrowserColorsOptionPane.this.moveUp) {
                int n = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                if (n != 0) {
                    BrowserColorsOptionPane.this.colorsModel.moveUp(n);
                    BrowserColorsOptionPane.this.setSelectedRow(n - 1);
                }
                BrowserColorsOptionPane.this.updateEnabled();
            } else if (object == BrowserColorsOptionPane.this.moveDown) {
                int n = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                if (n != BrowserColorsOptionPane.this.colorsTable.getRowCount() - 1) {
                    BrowserColorsOptionPane.this.colorsModel.moveDown(n);
                    BrowserColorsOptionPane.this.setSelectedRow(n + 1);
                }
                BrowserColorsOptionPane.this.updateEnabled();
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BrowserColorsOptionPane.this.updateEnabled();
        }
    }
}

