/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject
extends RubyObject {
    protected JavaAccessibleObject(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result2) {
        result2.defineAnnotatedMethods(JavaAccessibleObject.class);
    }

    public abstract AccessibleObject accessibleObject();

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)other).accessibleObject());
    }

    boolean same(JavaAccessibleObject that) {
        if (this == that) {
            return true;
        }
        return this.accessibleObject() == that.accessibleObject();
    }

    @Override
    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"==", "eql?"})
    public RubyBoolean op_equal(IRubyObject other) {
        return RubyBoolean.newBoolean(this.getRuntime(), this.equals(other));
    }

    @JRubyMethod(name={"equal?"})
    public RubyBoolean same(IRubyObject other) {
        boolean same2 = other instanceof JavaAccessibleObject && this.same((JavaAccessibleObject)other);
        return same2 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"accessible?"})
    public RubyBoolean isAccessible() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.accessibleObject().isAccessible());
    }

    @JRubyMethod(name={"accessible="})
    public IRubyObject setAccessible(IRubyObject object) {
        this.accessibleObject().setAccessible(object.isTrue());
        return object;
    }

    @JRubyMethod
    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        Class annotation2 = ((JavaClass)annoClass).javaClass();
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotation(annotation2));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"})
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        Class annotation2 = ((JavaClass)annoClass).javaClass();
        return this.getRuntime().newBoolean(this.accessibleObject().isAnnotationPresent(annotation2));
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = ((Member)((Object)this.accessibleObject())).getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(((Member)((Object)this.accessibleObject())).getModifiers());
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(((Member)((Object)this.accessibleObject())).getName());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(((Member)((Object)this.accessibleObject())).isSynthetic());
    }

    @JRubyMethod(name={"to_s", "to_string"})
    public RubyString to_string() {
        return this.getRuntime().newString(this.toString());
    }

    @Override
    public String toString() {
        return this.accessibleObject().toString();
    }

    @Override
    public Object toJava(Class target) {
        if (AccessibleObject.class.isAssignableFrom(target)) {
            return this.accessibleObject();
        }
        return super.toJava(target);
    }
}

