/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.interop.RubyMessageResolutionAccessor;
import org.jruby.truffle.language.RubyGuards;

public class RubyObjectType
extends ObjectType {
    @Override
    public String toString(DynamicObject object) {
        CompilerAsserts.neverPartOfCompilation();
        if (RubyGuards.isRubyString(object)) {
            return RopeOperations.decodeRope(this.getContext().getJRubyRuntime(), StringOperations.rope(object));
        }
        if (RubyGuards.isRubySymbol(object)) {
            return Layouts.SYMBOL.getString(object);
        }
        if (RubyGuards.isRubyException(object)) {
            return Layouts.EXCEPTION.getMessage(object).toString();
        }
        if (RubyGuards.isRubyModule(object)) {
            return Layouts.MODULE.getFields(object).toString();
        }
        return String.format("DynamicObject@%x<logicalClass=%s>", System.identityHashCode(object), Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(object)).getName());
    }

    @Override
    public ForeignAccess getForeignAccessFactory(DynamicObject object) {
        return RubyMessageResolutionAccessor.ACCESS;
    }

    public static boolean isInstance(TruffleObject object) {
        return RubyGuards.isRubyBasicObject(object);
    }

    private RubyContext getContext() {
        return Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(this)).getContext();
    }
}

